/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.server;

import com.mcafee.epo.common.db.Tool;
import com.mcafee.epo.common.db.ToolRegistry;
import com.mcafee.epo.common.db.destination.Contact;
import com.mcafee.epo.compliance.action.Action;
import com.mcafee.epo.compliance.action.ActionEnvironment;
import com.mcafee.epo.compliance.action.ActionInvoker;
import com.mcafee.epo.compliance.action.concrete.ExternalToolAction;
import com.mcafee.epo.compliance.action.concrete.QueryEPOAgentAction;
import com.mcafee.epo.compliance.content.ContentLoader;
import com.mcafee.epo.compliance.db.ActionStatus;
import com.mcafee.epo.compliance.db.Configuration;
import com.mcafee.epo.compliance.db.Host;
import com.mcafee.epo.compliance.db.Network;
import com.mcafee.epo.compliance.db.ResponseDatabaseObject;
import com.mcafee.epo.compliance.db.SchemaVersion;
import com.mcafee.epo.compliance.db.Sensor;
import com.mcafee.epo.compliance.db.action.ActionBase;
import com.mcafee.epo.compliance.db.action.ActionFactory;
import com.mcafee.epo.compliance.db.action.ActionFactoryException;
import com.mcafee.epo.compliance.db.action.ActionPropertyException;
import com.mcafee.epo.compliance.event.EventDispatcher;
import com.mcafee.epo.compliance.event.EventFactory;
import com.mcafee.epo.compliance.event.EventHandler;
import com.mcafee.epo.compliance.event.Response;
import com.mcafee.epo.compliance.event.concrete.NewRogueHostEvent;
import com.mcafee.epo.compliance.rsd.AgentDeployedStatusUpdater;
import com.mcafee.epo.compliance.rsd.MessageProcessor;
import com.mcafee.epo.compliance.rsd.NewRogueAction;
import com.mcafee.epo.compliance.server.ActionEnvironmentImpl;
import com.mcafee.epo.compliance.server.EpoSubnetImporter;
import com.mcafee.epo.compliance.server.ServerInitException;
import com.mcafee.epo.compliance.server.ServerProperties;
import com.mcafee.epo.compliance.server.ServerStatistics;
import com.mcafee.epo.compliance.server.SubnetEventGenerator;
import com.mcafee.epo.compliance.server.SubnetStatusTable;
import com.mcafee.epo.compliance.ui.util.ActionUtil;
import com.mcafee.epo.compliance.ui.util.PropDisplayFactory;
import com.mcafee.epo.compliance.util.thread.PeriodicTaskThread;
import com.mcafee.epo.core.EpoCore;
import com.mcafee.epo.core.condition.SerializationException;
import com.mcafee.epo.core.condition.SexpSerializer;
import com.mcafee.epo.core.db.EpoUser;
import com.mcafee.epo.core.db.ServerInfo;
import com.mcafee.epo.core.db.base.Database;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.db.base.Queries;
import com.mcafee.epo.core.log.RollingFileAppender;
import com.mcafee.epo.core.servlet.util.UserUtil;
import com.mcafee.epo.core.util.ResourceException;
import com.mcafee.epo.core.util.resource.Resource;
import com.mcafee.epo.core.util.thread.FileBiff;
import com.mcafee.epo.core.util.thread.FileChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.xml.DOMConfigurator;

public class Server {
    private static final Logger m_log = Logger.getLogger((String)(class$com$mcafee$epo$compliance$server$Server == null ? (class$com$mcafee$epo$compliance$server$Server = Server.class$("com.mcafee.epo.compliance.server.Server")) : class$com$mcafee$epo$compliance$server$Server).getName());
    public static final String DEFAULT_LOG_FILENAME = "compliance.log";
    public static final String LOG_CONFIG_FILENAME = "log_config.xml";
    public static final String SERVER_CONFIG_FILENAME = "ComplianceServer.properties";
    public static final String LOCAL_IP = "127.0.0.1";
    private static Database m_db = null;
    private static Database m_epoDb = null;
    private static boolean m_logAllEvents = false;
    private static boolean m_logErrorEvents = false;
    private static boolean m_sInitialized = false;
    private static boolean m_sInitFailed = false;
    private static int m_eventProcessRetries = 3;
    private static int m_numActionThreads = 3;
    private static int m_numEventThreads = 5;
    private static ServerStatistics m_statistics = new ServerStatistics();
    private static boolean m_statisticsEnabled = false;
    private static Configuration m_config = null;
    private static Contact[] m_contacts = null;
    private static Tool[] m_tools = null;
    private static ActionBase[] m_preConfigActions = null;
    private static String m_initErrorString = "";
    private static EventDispatcher m_eventDispatcher = new EventDispatcher();
    private static ActionInvoker m_actionInvoker = null;
    private static EpoSubnetImporter m_epoSubnetImporter = new EpoSubnetImporter();
    private static SubnetEventGenerator m_subnetEventGen = new SubnetEventGenerator();
    private static PeriodicTaskThread m_periodicTaskThread = new PeriodicTaskThread();
    private static String m_localHostName = "";
    private static InetAddress m_localHost = null;
    private static String m_ePOInstallDir = "";
    private static SubnetStatusTable m_activeSensorTable = new SubnetStatusTable();
    private static ActionFactory m_actionFactory = null;
    private static String m_defaultLocale = null;
    private static PropDisplayFactory m_propDisplayFactory = null;
    private static boolean m_janusEnabled = false;
    private static ServerInfo m_ePOServerInfo = null;
    private static int[] m_epoVersion;
    private static ServerProperties m_serverProps;
    private static FileBiff m_fileWatcher;
    private static final ToolRegistry m_toolRegistry;
    static /* synthetic */ Class class$com$mcafee$epo$compliance$server$Server;

    public static synchronized void init(ServletContext servletContext) throws Exception {
        if (m_sInitialized) {
            return;
        }
        m_sInitFailed = true;
        try {
            boolean bl;
            m_serverProps = new ServerProperties();
            m_serverProps.loadProperties();
            m_serverProps.setupChangeListeners(m_fileWatcher);
            Boolean bl2 = new Boolean(com.mcafee.epo.compliance.util.Resource.getStringOrThrow(m_serverProps, "epo.use.server.ini", SERVER_CONFIG_FILENAME));
            boolean bl3 = bl = bl2 != false && new Boolean(com.mcafee.epo.compliance.util.Resource.getStringOrDefault(m_serverProps, "epo.use.core", "true")) != false && EpoCore.isInitialized();
            if (bl) {
                m_log.debug((Object)"Epo core is initialized, and using ePO database.  Initializing with ePO core.");
                m_db = EpoCore.getEpoDb();
                m_epoDb = EpoCore.getEpoDb();
            } else {
                Server.initLogging();
                m_log.debug((Object)"Epo core is either not initialized, or not selected for use.  Initializing without the core.");
                Server.initDatabase(m_serverProps);
            }
            Server.setGeneralProperties(m_serverProps);
            Server.setEPOProperties();
            Server.setLocalHost();
            SchemaVersion.verifyDbSchemaVersion(Server.getDb());
            ActionEnvironment.setInstance(new ActionEnvironmentImpl());
            m_log.debug((Object)("Starting " + m_numActionThreads + " action processing threads."));
            m_actionInvoker = new ActionInvoker(m_numActionThreads);
            Server.reloadConfiguration();
            MessageProcessor.instance().setNewRogueAction(new NewRogueActionImpl());
            MessageProcessor.instance().setAgentDeployedStatusUpdater(new AgentStatusUpdaterImpl());
            m_log.debug((Object)("Starting " + m_numEventThreads + " event processing threads."));
            m_eventDispatcher.start(m_numEventThreads);
            Server.initPeriodicTasks(m_serverProps);
            ActionUtil.buildActions(m_defaultLocale);
            ContentLoader.loadAllContent(m_epoDb.getEPODBDir(), m_epoDb);
            m_propDisplayFactory = new PropDisplayFactory(m_db, m_config);
            Server.initToolRegistry(servletContext);
        }
        catch (Exception exception) {
            m_log.error((Object)com.mcafee.epo.compliance.util.Resource.getString("server_init_failed"), (Throwable)exception);
            m_initErrorString = exception.getMessage();
            throw exception;
        }
        m_statistics.reset();
        m_sInitFailed = false;
        m_initErrorString = "";
        m_sInitialized = true;
    }

    private static void initToolRegistry(ServletContext servletContext) {
        ToolRegistry toolRegistry = Server.getToolRegistry();
        ToolRegistry.register((Object)new Integer(1), (ToolRegistry)toolRegistry);
        try {
            toolRegistry.loadRegisteredTools((class$com$mcafee$epo$compliance$server$Server == null ? (class$com$mcafee$epo$compliance$server$Server = Server.class$("com.mcafee.epo.compliance.server.Server")) : class$com$mcafee$epo$compliance$server$Server).getClassLoader());
        }
        catch (FileNotFoundException fileNotFoundException) {
            m_log.warn((Object)com.mcafee.epo.compliance.util.Resource.getString("load_registered_tools_failed"));
            try {
                if (servletContext != null) {
                    toolRegistry.createRegisteredTools(servletContext);
                } else {
                    m_log.debug((Object)"Server.initToolRegistry - Servlet context was null");
                }
            }
            catch (IOException iOException) {
                m_log.error((Object)com.mcafee.epo.compliance.util.Resource.getString("error_creating_registered_tools"), (Throwable)iOException);
            }
        }
        catch (IOException iOException) {
            m_log.error((Object)com.mcafee.epo.compliance.util.Resource.getString("error_loading_registered_tools"), (Throwable)iOException);
        }
    }

    private static final void initPeriodicTasks(Properties properties) {
        long l = Long.parseLong(com.mcafee.epo.compliance.util.Resource.getStringOrDefault(properties, "uncovered.subnet.check.period", "600000"));
        m_periodicTaskThread.addPeriodicTask(m_epoSubnetImporter);
        m_periodicTaskThread.addPeriodicTask(m_subnetEventGen, l);
        m_periodicTaskThread.start();
        m_periodicTaskThread.runAsync(m_epoSubnetImporter);
    }

    public static synchronized void shutdown() {
        if (!m_sInitialized) {
            return;
        }
        m_fileWatcher.shutdown();
        m_eventDispatcher.stop(false);
        m_actionInvoker.stop();
        m_periodicTaskThread.stop(false);
        m_sInitialized = false;
    }

    public static Database getDb() {
        return m_db;
    }

    public static Database getEpoDb() {
        return m_epoDb;
    }

    public static String getInitErrorString() {
        return m_initErrorString;
    }

    public static EventDispatcher getEventDispatcher() {
        return m_eventDispatcher;
    }

    public static ActionInvoker getActionInvoker() {
        return m_actionInvoker;
    }

    public static final String getTomcatPort() {
        Integer n = new Integer(8444);
        if (m_ePOServerInfo != null && m_ePOServerInfo.getSensorSecureHttpPort() != null) {
            n = m_ePOServerInfo.getSensorSecureHttpPort();
        }
        return n.toString();
    }

    public static final String getLocalHostName() {
        return m_localHostName;
    }

    public static final String getEPOInstallDir() {
        return m_ePOInstallDir;
    }

    public static final String getAgentHttpPort() {
        Integer n = new Integer(8080);
        if (m_ePOServerInfo != null && m_ePOServerInfo.getAgentHTTPPort() != null) {
            n = m_ePOServerInfo.getAgentHTTPPort();
        }
        return n.toString();
    }

    public static EpoSubnetImporter getEpoSubnetImporter() {
        return m_epoSubnetImporter;
    }

    public static SubnetStatusTable getActiveSensorTable() {
        return m_activeSensorTable;
    }

    public static boolean isJanusEnabled() {
        return m_janusEnabled;
    }

    public static void addFileWatch(String string, long l, FileChangeListener fileChangeListener) throws FileNotFoundException {
        m_fileWatcher.addChangeListener(string, l, fileChangeListener);
    }

    public static void removeFileWatch(String string, FileChangeListener fileChangeListener) {
        m_fileWatcher.removeChangeListener(string, fileChangeListener);
    }

    public static String getServerTitle(String string) {
        if (m_janusEnabled) {
            return com.mcafee.epo.compliance.util.Resource.getString("jsputil_snowcap_title_and_version", string);
        }
        return com.mcafee.epo.compliance.util.Resource.getString("common_rogue_machines", string);
    }

    public static ActionFactory getActionFactory() {
        return m_actionFactory;
    }

    public static final boolean shouldLogAllEvents() {
        return m_logAllEvents;
    }

    public static final boolean shouldLogErrorEvents() {
        return m_logErrorEvents;
    }

    public static final boolean profilingEnabled() {
        return m_statisticsEnabled;
    }

    public static final ServerStatistics getStatistics() {
        return m_statistics;
    }

    public static final int numEventProcRetries() {
        return m_eventProcessRetries;
    }

    public static synchronized void cleanup() {
    }

    public static final synchronized boolean initialized() {
        return m_sInitialized;
    }

    public static final synchronized boolean initFailed() {
        return m_sInitFailed;
    }

    public static final void logError(String string) {
        m_log.error((Object)string);
    }

    private static void initLogging() {
        Object object;
        Object object2;
        URL uRL = (class$com$mcafee$epo$compliance$server$Server == null ? (class$com$mcafee$epo$compliance$server$Server = Server.class$("com.mcafee.epo.compliance.server.Server")) : class$com$mcafee$epo$compliance$server$Server).getClassLoader().getResource(LOG_CONFIG_FILENAME);
        System.out.println("logConfigURL: " + uRL);
        if (uRL != null) {
            DOMConfigurator.configureAndWatch((String)uRL.getFile());
        }
        Logger logger = Logger.getRootLogger();
        boolean bl = false;
        if (!logger.getAllAppenders().hasMoreElements()) {
            object2 = System.getProperty("catalina.home");
            bl = true;
            PatternLayout patternLayout = new PatternLayout("%d{ISO8601} %-5p [%t]%-15c{2} %x - %m%n");
            RollingFileAppender rollingFileAppender = new RollingFileAppender();
            rollingFileAppender.setMaxFileSize("2MB");
            rollingFileAppender.setMaxBackupIndex(9);
            ConsoleAppender consoleAppender = new ConsoleAppender();
            rollingFileAppender.setName("ToFile");
            rollingFileAppender.setLayout((Layout)patternLayout);
            rollingFileAppender.setBufferedIO(false);
            object = object2 != null && ((String)object2).length() > 0 ? (String)object2 + "/logs" : "C:";
            rollingFileAppender.setFile((String)object + "/" + DEFAULT_LOG_FILENAME);
            rollingFileAppender.setAppend(true);
            rollingFileAppender.activateOptions();
            consoleAppender.setName("ToStdout");
            consoleAppender.setLayout((Layout)patternLayout);
            consoleAppender.setTarget("System.out");
            consoleAppender.activateOptions();
            logger.addAppender((Appender)rollingFileAppender);
            logger.addAppender((Appender)consoleAppender);
            logger.setLevel(Level.INFO);
        }
        if (bl) {
            m_log.warn((Object)com.mcafee.epo.compliance.util.Resource.formatString("server_template_init_failed", LOG_CONFIG_FILENAME));
        }
        object2 = logger.getAllAppenders();
        while (object2.hasMoreElements()) {
            object = (Appender)object2.nextElement();
            if (!(object instanceof FileAppender)) continue;
            m_log.info((Object)com.mcafee.epo.compliance.util.Resource.formatString("server_template_writing_log_file", ((FileAppender)object).getFile()));
        }
    }

    private static final String exhaustActionAsString(byte by) {
        switch (by) {
            case 1: {
                return "block";
            }
            case 2: {
                return "grow";
            }
        }
        return "<INVALID-VALUE>";
    }

    public static final boolean allowedToEdit(HttpServletRequest httpServletRequest) {
        EpoUser epoUser = UserUtil.getEpoUser((HttpServletRequest)httpServletRequest);
        boolean bl = Server.getConfiguration().getAllowSiteAdmins();
        boolean bl2 = epoUser.isReviewer() ? false : !epoUser.isSiteAccount() || bl;
        return bl2;
    }

    public static void initDatabase(Properties properties) throws ServerInitException {
        try {
            m_db = new Database(properties, "compliance", Queries.VALIDATE_SNOWCAP_DB);
        }
        catch (Exception exception) {
            throw new ServerInitException(com.mcafee.epo.compliance.util.Resource.formatString("server_template_error_connecting", new Object[]{"Rogue System Server", exception.getMessage()}), exception);
        }
        m_log.info((Object)com.mcafee.epo.compliance.util.Resource.getString("server_snowcap_db_init_success"));
        try {
            m_epoDb = new Database(properties, "epo", Queries.VALIDATE_EPO_DB);
        }
        catch (Exception exception) {
            throw new ServerInitException(com.mcafee.epo.compliance.util.Resource.formatString("server_template_error_connecting", new Object[]{"ePO Server", exception.getMessage()}), exception);
        }
        m_log.info((Object)com.mcafee.epo.compliance.util.Resource.getString("server_epo_db_init_success"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void reloadConfiguration() throws SQLException, ActionPropertyException, ActionFactoryException, SerializationException, IllegalAccessException, InvocationTargetException {
        Connection connection = null;
        try {
            connection = Server.getDb().getConnection();
            m_log.debug((Object)"(re)loading configuration.");
            m_config = Configuration.get(connection);
            m_contacts = Contact.getAll((Connection)connection);
            m_tools = Tool.getAll((Connection)connection, (int)1);
            m_actionFactory = new ActionFactory(connection);
            m_preConfigActions = ActionBase.getPreConfiguredActions(connection, m_actionFactory);
            m_log.debug((Object)"Loading new response set.");
            ResponseDatabaseObject[] responseDatabaseObjectArray = ResponseDatabaseObject.getEnabledInOrder(connection);
            EventHandler[] eventHandlerArray = new EventHandler[responseDatabaseObjectArray.length];
            Response.DefaultErrorHandler defaultErrorHandler = new Response.DefaultErrorHandler();
            int n = 0;
            while (n < responseDatabaseObjectArray.length) {
                Response response = new Response(defaultErrorHandler, Server.getActionInvoker());
                eventHandlerArray[n] = response;
                response.setName(responseDatabaseObjectArray[n].getName());
                response.setEventType(responseDatabaseObjectArray[n].getEventType());
                if (responseDatabaseObjectArray[n].getCondition().length() > 0) {
                    response.setCondition(SexpSerializer.read((String)responseDatabaseObjectArray[n].getCondition()));
                } else {
                    response.setCondition(null);
                }
                m_log.debug((Object)("[*] Adding response:" + response.getName()));
                ActionBase[] actionBaseArray = ActionBase.getByResponseId(connection, responseDatabaseObjectArray[n].getId(), m_actionFactory);
                int n2 = 0;
                while (n2 < actionBaseArray.length) {
                    response.addAction((Action)((Object)actionBaseArray[n2]));
                    m_log.debug((Object)("   -- Adding action:" + actionBaseArray[n2]));
                    ++n2;
                }
                ++n;
            }
            m_eventDispatcher.replaceHandlers(eventHandlerArray);
            m_log.debug((Object)"Current response set replaced with new set.");
            m_epoSubnetImporter.setRunPeriodInMs(m_config.getEpoImportPeriod(), System.currentTimeMillis());
            m_subnetEventGen.setServerInfo(m_config.getSensorWindow(), m_eventDispatcher, Server.getDb());
            Server.logEpoLookupMethod();
            MessageProcessor.instance().setEpoDbLookupMethod(m_config.getEpoDbLookupMethod());
            long l = m_config.getDeadAgentPeriod();
            m_log.debug((Object)("Setting inactive agent period to:" + (l == 0L ? "<disabled>" : l + " milliSec.")));
            MessageProcessor.instance().setDeadAgentPeriodInMs(l);
            m_activeSensorTable.setInactiveSensorPeriod(m_config.getSensorWindow());
            m_activeSensorTable.setMaxSensorsPerSubnet(m_config.getMaxActiveSensors());
            m_activeSensorTable.setSensorRotationPeriod(m_config.getMaxActiveSensorTime());
            m_activeSensorTable.setEnabled(m_config.isLimitSensorsEnabled());
            long l2 = m_config.getGracePeriod();
            if (!m_config.isGracePeriodEnabled()) {
                l2 = 0L;
            }
            m_log.debug((Object)("Setting rogue grace period period to:" + (l2 == 0L ? "<disabled>" : l2 + " milliSec")));
            MessageProcessor.instance().setGracePeriodInMs(l2);
            QueryEPOAgentAction.setPorts(Server.getAgentHttpPort(), m_config.getAddnlAgentPorts().split(":"));
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    public static boolean isValidEpoLookupMethod(int n) {
        return n == 1 || n == 3 || n == 7;
    }

    private static void logEpoLookupMethod() {
        String string = "";
        switch (m_config.getEpoDbLookupMethod()) {
            case 7: {
                string = "MAC,Name (with domain)";
                break;
            }
            case 3: {
                string = "MAC,Name";
                break;
            }
            case 1: {
                string = "MAC";
                break;
            }
            default: {
                m_config.setEpoDbLookupMethod(1);
                string = "MAC";
            }
        }
        m_log.info((Object)("Setting ePO host lookup method to:" + string));
    }

    private static void setLocalHost() throws ServerInitException {
        String string = m_epoDb.getEPOAppServerIP();
        if ("".equals(string)) {
            string = m_ePOServerInfo.getLastKnownTCPIP();
        }
        try {
            m_localHost = InetAddress.getByName(string);
            m_localHostName = m_localHost.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new ServerInitException(com.mcafee.epo.compliance.util.Resource.getString("server_no_localhost_name"));
        }
    }

    public static final boolean isLocal(HttpServletRequest httpServletRequest) {
        Boolean bl = (Boolean)httpServletRequest.getAttribute("ISLOCAL");
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public static final void setLocal(HttpServletRequest httpServletRequest) {
        String string;
        String string2 = httpServletRequest.getRemoteAddr();
        boolean bl = string2.compareTo(string = m_localHost.getHostAddress()) == 0 || string2.compareTo(LOCAL_IP) == 0;
        httpServletRequest.setAttribute("ISLOCAL", (Object)bl);
    }

    public static Contact[] getContacts() {
        return m_contacts;
    }

    public static ActionBase[] getPreConfiguredActions() {
        return m_preConfigActions;
    }

    public static Tool[] getTools() {
        return m_tools;
    }

    public static Configuration getConfiguration() {
        return m_config;
    }

    public static String getDefaultLocale() {
        return m_defaultLocale;
    }

    public static PropDisplayFactory getPropDisplayFactory() {
        return m_propDisplayFactory;
    }

    public static final void setGeneralProperties(Properties properties) throws ResourceException {
        String string = properties.getProperty("log.event.details", "none");
        String string2 = Locale.getDefault().getLanguage();
        if (string2 == null) {
            string2 = "en";
        }
        m_defaultLocale = com.mcafee.epo.compliance.util.Resource.getStringOrDefault(properties, "server.default.language", string2);
        com.mcafee.epo.compliance.util.Resource.setDefaultLanguage(m_defaultLocale);
        m_log.info((Object)com.mcafee.epo.compliance.util.Resource.formatString("server_template_default_lang", Resource.getString((String)("language_" + m_defaultLocale)), m_defaultLocale));
        if (string.equals("all")) {
            m_logAllEvents = true;
            m_logErrorEvents = false;
        } else if (string.equals("error")) {
            m_logAllEvents = false;
            m_logErrorEvents = true;
        } else {
            m_logAllEvents = false;
            m_logErrorEvents = false;
        }
        m_eventProcessRetries = Integer.parseInt(properties.getProperty("event.processing.retries", "3"));
        if (m_eventProcessRetries < 0) {
            m_eventProcessRetries = 0;
        }
        String string3 = properties.getProperty("server.performance.profiling", "false");
        m_statisticsEnabled = string3.equals("true");
        m_ePOInstallDir = com.mcafee.epo.compliance.util.Resource.getStringOrThrow(properties, "epo.install.dir", SERVER_CONFIG_FILENAME);
        m_numActionThreads = Integer.parseInt(properties.getProperty("num.action.threads", "3"));
        m_numEventThreads = Integer.parseInt(properties.getProperty("num.event.threads", "5"));
        ExternalToolAction.setTTL(Integer.parseInt(properties.getProperty("tool.max.runtime", "60000")));
        String string4 = properties.getProperty("server.janus.enabled", "false");
        m_janusEnabled = string4.equalsIgnoreCase("true");
    }

    public static ServerInfo getEPOServerInfo() {
        return m_ePOServerInfo;
    }

    public static int[] getEpoVersion() {
        return m_epoVersion;
    }

    public static boolean isRedtail() {
        return m_epoVersion[0] == 3 && m_epoVersion[1] == 5;
    }

    public static boolean isAtlas() {
        return m_epoVersion[0] == 3 && m_epoVersion[1] == 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setEPOProperties() throws Exception {
        Connection connection = null;
        try {
            connection = m_epoDb.getConnection();
            m_ePOServerInfo = ServerInfo.load((Connection)connection);
            m_epoVersion = ServerInfo.parseEPOVersion((ServerInfo)m_ePOServerInfo);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    public static ToolRegistry getToolRegistry() {
        return m_toolRegistry;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        m_serverProps = null;
        m_fileWatcher = new FileBiff();
        m_toolRegistry = new ToolRegistry("Registered EXEs for use in Snowcap.");
    }

    public static class AgentStatusUpdaterImpl
    implements AgentDeployedStatusUpdater {
        public void update(Connection connection, Host host, Timestamp timestamp) throws SQLException {
            ActionStatus.updateAgentDeployedStatus(connection, host.getId(), timestamp);
        }
    }

    public static class NewRogueActionImpl
    implements NewRogueAction {
        public void newRogueDetected(Connection connection, Network network, Sensor sensor, Host host) {
            NewRogueHostEvent newRogueHostEvent = null;
            try {
                newRogueHostEvent = EventFactory.createNewRogueHostEvent(connection, host, network, sensor);
            }
            catch (SQLException sQLException) {
                m_log.warn((Object)"Unable to add new rogue host event to the database..", (Throwable)sQLException);
                newRogueHostEvent = EventFactory.createNewRogueHostEvent(host, network, sensor);
            }
            Server.getEventDispatcher().addEvent(newRogueHostEvent);
        }
    }
}

