/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.server;

import java.util.Date;

public class ServerStatistics {
    private long m_numEventsProcessed;
    private long m_numHostsProcessed;
    private long m_serverStartTime;
    private long m_totalEventProcessingTime;
    private long m_totalEventDatabaseTime;
    private long m_numErrorEvents;
    private long m_errorProcessingTime;
    private long m_lastEventProcessedTime;

    public ServerStatistics() {
        this.reset();
    }

    public synchronized void reset() {
        this.m_numEventsProcessed = 0L;
        this.m_numHostsProcessed = 0L;
        this.m_serverStartTime = System.currentTimeMillis();
        this.m_totalEventProcessingTime = 0L;
        this.m_totalEventDatabaseTime = 0L;
        this.m_errorProcessingTime = 0L;
        this.m_numErrorEvents = 0L;
        this.m_lastEventProcessedTime = 0L;
    }

    public synchronized void eventProcessed(int n, long l, long l2) {
        ++this.m_numEventsProcessed;
        ++this.m_numHostsProcessed;
        this.m_totalEventProcessingTime += l;
        this.m_totalEventDatabaseTime += l2;
        this.m_lastEventProcessedTime = System.currentTimeMillis();
    }

    public synchronized void errorEvent(long l) {
        ++this.m_numErrorEvents;
        this.m_errorProcessingTime += l;
        this.m_lastEventProcessedTime = System.currentTimeMillis();
    }

    public synchronized void setServerStartTime(long l) {
        this.m_serverStartTime = l;
    }

    public synchronized long uptime() {
        if (this.m_serverStartTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.m_serverStartTime;
    }

    public synchronized String lastEventProcessedTime() {
        if (this.m_lastEventProcessedTime == 0L) {
            return "--";
        }
        return new Date(this.m_lastEventProcessedTime).toString();
    }

    public synchronized long avgProcessTime() {
        if (this.m_numEventsProcessed == 0L) {
            return 0L;
        }
        return this.m_totalEventProcessingTime / this.m_numEventsProcessed;
    }

    public synchronized long avgDbTime() {
        if (this.m_numEventsProcessed == 0L) {
            return 0L;
        }
        return this.m_totalEventDatabaseTime / this.m_numEventsProcessed;
    }

    public synchronized long getNumEventsProcessed() {
        return this.m_numEventsProcessed;
    }

    public synchronized long getNumHostsProcessed() {
        return this.m_numHostsProcessed;
    }

    public synchronized long getServerStartTime() {
        return this.m_serverStartTime;
    }

    public synchronized long getTotalEventProcessingTime() {
        return this.m_totalEventProcessingTime;
    }

    public synchronized long getTotalEventDatabaseTime() {
        return this.m_totalEventDatabaseTime;
    }

    public synchronized long getNumErrorEvents() {
        return this.m_numErrorEvents;
    }

    public synchronized long getErrorProcessingTime() {
        return this.m_errorProcessingTime;
    }

    public synchronized long getLastEventProcessedTime() {
        return this.m_lastEventProcessedTime;
    }
}

