/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.ui;

import com.mcafee.epo.common.ui.tables.HtmlTable;
import com.mcafee.epo.common.ui.tables.HtmlTableCell;
import com.mcafee.epo.common.ui.tables.HtmlTableHeader;
import com.mcafee.epo.common.ui.tables.HtmlTableRow;
import com.mcafee.epo.common.ui.util.PaginationState;
import com.mcafee.epo.common.ui.util.SessionUtil;
import com.mcafee.epo.compliance.db.ComplianceRules;
import com.mcafee.epo.compliance.db.Configuration;
import com.mcafee.epo.compliance.server.Server;
import com.mcafee.epo.compliance.ui.util.ActionUtil;
import com.mcafee.epo.compliance.ui.util.SessionState;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.servlet.util.UserUtil;
import com.mcafee.epo.core.ui.ActionBeanBase;
import java.sql.Connection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DisplayComplianceBean
extends ActionBeanBase {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$compliance$ui$DisplayComplianceBean == null ? (class$com$mcafee$epo$compliance$ui$DisplayComplianceBean = DisplayComplianceBean.class$("com.mcafee.epo.compliance.ui.DisplayComplianceBean")) : class$com$mcafee$epo$compliance$ui$DisplayComplianceBean));
    static /* synthetic */ Class class$com$mcafee$epo$compliance$ui$DisplayComplianceBean;

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        m_log.debug((Object)"Executing the display Compliance bean.");
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        Connection connection = null;
        PaginationState paginationState = null;
        HtmlTable htmlTable = null;
        String[] stringArray = null;
        try {
            connection = Server.getDb().getConnection();
            Configuration configuration = Server.getConfiguration();
            stringArray = configuration.getMachineListCols().split(":");
            SessionUtil.setAutoRefreshParams((HttpServletRequest)httpServletRequest, (long)configuration.getAutoRefreshPeriod(), (int)configuration.getAutoRefreshActivated());
            paginationState = SessionState.getPaginationState("Host", 0, configuration.getPageCount(), httpServletRequest);
            m_log.debug((Object)"Retrieving compliance rules.");
            ComplianceRules[] complianceRulesArray = ComplianceRules.get(connection);
            if (complianceRulesArray == null) {
                m_log.debug((Object)"Creating rules table -- empty, no rules defined.");
                paginationState.getPagMgr().setListCount(0);
                htmlTable = this.createHtmlTable(paginationState, string);
                this.addEmptyRow(htmlTable);
            } else {
                m_log.debug((Object)"Creating rules table with rules.");
                paginationState.getPagMgr().setListCount(complianceRulesArray.length);
                htmlTable = this.createHtmlTable(paginationState, string);
                this.addRules(htmlTable, stringArray, complianceRulesArray, connection);
                m_log.debug((Object)"Done creating rules table.");
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        ActionUtil.buildActions(string);
        httpServletRequest.setAttribute("actionsListAllActions", (Object)ActionUtil.getActions());
        httpServletRequest.setAttribute("Host", (Object)htmlTable.getHtml(string));
        httpServletRequest.setAttribute("index", (Object)Integer.toString(paginationState.getPagMgr().getIndex()));
        httpServletRequest.setAttribute("statusFlags", (Object)Integer.toString(paginationState.getStatusFlags()));
        SessionUtil.setCustomFilterDisplayString((HttpServletRequest)httpServletRequest, (String)paginationState.getSearchSexpStr(), (String)string);
        httpServletRequest.setAttribute("configureTableId", (Object)Integer.toString(1));
        SessionUtil.handleButtonState((HttpServletRequest)httpServletRequest, (String)"selectedMachineListAction");
        m_log.debug((Object)"Done, forwarding to the JSP.");
        return "compliance.jsp";
    }

    private HtmlTable createHtmlTable(PaginationState paginationState, String string) {
        HtmlTable htmlTable = new HtmlTable();
        htmlTable.setHasCheckbox(true);
        htmlTable.setId("ruleList");
        htmlTable.setPaginationMgr(paginationState.getPagMgr());
        HtmlTableHeader htmlTableHeader = htmlTable.getHeader();
        htmlTableHeader.setCheckboxId("checkboxToggle");
        StringBuffer stringBuffer = new StringBuffer();
        int n = paginationState.getSortCol();
        stringBuffer.append("Rule Name");
        htmlTableHeader.addCell(stringBuffer.toString());
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append("Description");
        htmlTableHeader.addCell(stringBuffer.toString());
        stringBuffer.delete(0, stringBuffer.length());
        return htmlTable;
    }

    private void addRules(HtmlTable htmlTable, String[] stringArray, ComplianceRules[] complianceRulesArray, Connection connection) throws Exception {
        HtmlTableRow htmlTableRow = null;
        HtmlTableCell htmlTableCell = null;
        int n = 0;
        int n2 = complianceRulesArray.length;
        while (n < n2) {
            ComplianceRules complianceRules = complianceRulesArray[n];
            htmlTableRow = htmlTable.addRow();
            htmlTableRow.setCheckboxId("CheckBox_" + complianceRules.getRuleID());
            htmlTableCell = htmlTableRow.addCell(complianceRules.getRuleName());
            htmlTableCell = htmlTableRow.addCell(complianceRules.getRuleDescription());
            ++n;
        }
    }

    private void addEmptyRow(HtmlTable htmlTable) {
        HtmlTableRow htmlTableRow = null;
        HtmlTableCell htmlTableCell = null;
        htmlTableRow = htmlTable.addRow();
        htmlTableCell = htmlTableRow.addCell("(No rules defined.)");
        htmlTableCell = htmlTableRow.addCell();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

