/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.ui;

import com.mcafee.epo.common.ui.tables.HtmlTable;
import com.mcafee.epo.common.ui.tables.HtmlTableCell;
import com.mcafee.epo.common.ui.tables.HtmlTableHeader;
import com.mcafee.epo.common.ui.tables.HtmlTableRow;
import com.mcafee.epo.common.ui.util.PaginationMgr;
import com.mcafee.epo.common.ui.util.PaginationState;
import com.mcafee.epo.common.ui.util.SessionUtil;
import com.mcafee.epo.common.ui.util.UIPropStack;
import com.mcafee.epo.compliance.db.Configuration;
import com.mcafee.epo.compliance.db.Host;
import com.mcafee.epo.compliance.db.Network;
import com.mcafee.epo.compliance.db.QueryUtil;
import com.mcafee.epo.compliance.db.action.ActionFactoryException;
import com.mcafee.epo.compliance.db.action.ActionPropertyException;
import com.mcafee.epo.compliance.server.Server;
import com.mcafee.epo.compliance.ui.util.ActionUtil;
import com.mcafee.epo.compliance.ui.util.HostPropDisplay;
import com.mcafee.epo.compliance.ui.util.SessionState;
import com.mcafee.epo.compliance.util.Resource;
import com.mcafee.epo.core.condition.SerializationException;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.servlet.util.UserUtil;
import com.mcafee.epo.core.ui.ActionBeanBase;
import com.mcafee.epo.core.ui.InvalidParameterException;
import com.mcafee.epo.core.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DisplayMachinesBean
extends ActionBeanBase {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$compliance$ui$DisplayMachinesBean == null ? (class$com$mcafee$epo$compliance$ui$DisplayMachinesBean = DisplayMachinesBean.class$("com.mcafee.epo.compliance.ui.DisplayMachinesBean")) : class$com$mcafee$epo$compliance$ui$DisplayMachinesBean));
    public static final String ACTION_STRING = "displaymachines.do";
    static /* synthetic */ Class class$com$mcafee$epo$compliance$ui$DisplayMachinesBean;
    static /* synthetic */ Class class$com$mcafee$epo$compliance$db$Host;

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        String string = httpServletRequest.getParameter("index");
        if (string != null && string.length() > 0 && !SessionUtil.isIntegerGT((String)string, (int)-1)) {
            throw new InvalidParameterException("Error: DisplayMachinesBean - Negative machine index requested.");
        }
        String string2 = httpServletRequest.getParameter("statusFlags");
        if (!(string2 == null || string2.length() <= 0 || SessionUtil.isIntegerLE((String)string2, (int)6) && SessionUtil.isIntegerGT((String)string2, (int)0))) {
            throw new InvalidParameterException("Error: DisplayMachinesBean - Illegal value for SessionUtil.PARAM_STATUS_FLAGS found.");
        }
        String string3 = httpServletRequest.getParameter("sortOrder");
        if (!(string3 == null || string3.length() <= 0 || SessionUtil.isIntegerLE((String)string3, (int)2) && SessionUtil.isIntegerGT((String)string3, (int)0))) {
            throw new InvalidParameterException("Error: DisplayMachinesBean - Illegal value for SessionUtil.PARAM_SORT_ORDER found.");
        }
        String string4 = httpServletRequest.getParameter("sortColumn");
        if (!(string4 == null || string4.length() <= 0 || SessionUtil.isIntegerGT((String)string4, (int)-1) && SessionUtil.isIntegerLE((String)string4, (int)29))) {
            throw new InvalidParameterException("Error: DisplayMachinesBean - Illegal value for SessionUtil.PARAM_SORT_COLUMN found.");
        }
        String string5 = httpServletRequest.getParameter("subnetId");
        if (string5 != null && string5.length() > 0 && !SessionUtil.isIntegerGT((String)string5, (int)-1)) {
            throw new InvalidParameterException("Error: DisplayMachinesBean - Illegal value for SessionUtil.PARAM_SUBNET_ID found.");
        }
        String string6 = httpServletRequest.getParameter("NetworkAddress");
        if (string6 != null && string6.length() > 0 && !SessionUtil.isNonEmptyString((String)string6)) {
            throw new InvalidParameterException("Error: DisplayMachinesBean - Illegal value for SessionUtil.ATTR_NETWORK_ADDRESS found.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Configuration configuration;
        String string;
        String string2;
        String string3;
        HostPropDisplay hostPropDisplay;
        String[] stringArray;
        HtmlTable htmlTable;
        PaginationState paginationState;
        Connection connection;
        String string4;
        block5: {
            String string5;
            string4 = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
            connection = null;
            paginationState = null;
            htmlTable = null;
            stringArray = null;
            hostPropDisplay = (HostPropDisplay)Server.getPropDisplayFactory().createPropDisplay(class$com$mcafee$epo$compliance$db$Host == null ? (class$com$mcafee$epo$compliance$db$Host = DisplayMachinesBean.class$("com.mcafee.epo.compliance.db.Host")) : class$com$mcafee$epo$compliance$db$Host, UserUtil.getEpoUser((HttpServletRequest)httpServletRequest));
            string3 = null;
            string2 = null;
            string = null;
            try {
                connection = Server.getDb().getConnection();
                configuration = Server.getConfiguration();
                stringArray = configuration.getMachineListCols().split(":");
                if (this.validateColumns(stringArray, configuration, connection)) break block5;
                String string6 = Resource.getString("common_columns_reset", string4);
                SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getString("jsputil_user_input_required", string4), (String)string6, (String)ACTION_STRING);
                string5 = "actiontaken.jsp";
                Object var16_17 = null;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                DatabaseUtil.close((Connection)connection);
                throw throwable;
            }
            DatabaseUtil.close((Connection)connection);
            return string5;
        }
        SessionUtil.setAutoRefreshParams((HttpServletRequest)httpServletRequest, (long)configuration.getAutoRefreshPeriod(), (int)configuration.getAutoRefreshActivated());
        paginationState = SessionState.getPaginationState("Host", hostPropDisplay.getDefaultSortCol(), configuration.getPageCount(), httpServletRequest);
        int n = configuration.getSortColumn1();
        string3 = QueryUtil.makeHostQuery(paginationState.getNetworkId(), paginationState.getStatusFlags(), n, paginationState.getSortCol(), paginationState.getSortOrder(), configuration.getMachineWindow(), paginationState.getSearchSexpStr());
        string2 = "Hosts left join OUIs on Hosts.OUI = OUIs.OUI";
        string = QueryUtil.makeHostWhereClause(paginationState.getNetworkId(), paginationState.getStatusFlags(), configuration.getMachineWindow(), paginationState.getSearchSexpStr());
        paginationState.getPagMgr().setListCount(DatabaseUtil.countRows((Connection)connection, (String)string2, (String)string));
        m_log.debug((Object)("Performing query: " + string3));
        Host[] hostArray = Host.getByQuery(connection, string3, paginationState.getPagMgr().getIndex(), paginationState.getPagMgr().getItemsPerPage());
        if ((hostArray == null || hostArray.length < 1) && paginationState.getPagMgr().getIndex() > 1) {
            paginationState.getPagMgr().computePagination();
            hostArray = Host.getByQuery(connection, string3, paginationState.getPagMgr().getIndex(), paginationState.getPagMgr().getItemsPerPage());
        }
        htmlTable = this.createHtmlTable(paginationState, stringArray, hostPropDisplay, string4);
        this.addMachines(htmlTable, stringArray, hostPropDisplay, hostArray, configuration.getSortColumn1() == 9, connection, configuration.getMachineWindow(), paginationState.getPagMgr().getIndex());
        Object var16_18 = null;
        DatabaseUtil.close((Connection)connection);
        ActionUtil.buildActions(string4);
        httpServletRequest.setAttribute("actionsListAllActions", (Object)ActionUtil.getActions());
        httpServletRequest.setAttribute("Host", (Object)htmlTable.getHtml(string4));
        httpServletRequest.setAttribute("index", (Object)Integer.toString(paginationState.getPagMgr().getIndex()));
        httpServletRequest.setAttribute("statusFlags", (Object)Integer.toString(paginationState.getStatusFlags()));
        SessionUtil.setCustomFilterDisplayString((HttpServletRequest)httpServletRequest, (String)paginationState.getSearchSexpStr(), (String)string4);
        UIPropStack.initPropStack((String)ACTION_STRING, (HttpServletRequest)httpServletRequest, ((Object)((Object)this)).getClass(), (String)string3, (PaginationMgr)paginationState.getPagMgr(), (Class)(class$com$mcafee$epo$compliance$db$Host == null ? (class$com$mcafee$epo$compliance$db$Host = DisplayMachinesBean.class$("com.mcafee.epo.compliance.db.Host")) : class$com$mcafee$epo$compliance$db$Host), (String)string2, (String)string);
        if (paginationState.getNetworkFlags() == 2) {
            httpServletRequest.setAttribute("networkFlags", (Object)Integer.toString(paginationState.getNetworkFlags()));
            httpServletRequest.setAttribute("NetworkAddress", (Object)paginationState.getNetworkAddress());
        }
        httpServletRequest.setAttribute("configureTableId", (Object)Integer.toString(1));
        SessionUtil.handleButtonState((HttpServletRequest)httpServletRequest, (String)"selectedMachineListAction");
        return "machinelist.jsp";
    }

    private boolean validateColumns(String[] stringArray, Configuration configuration, Connection connection) throws SQLException, ActionFactoryException, ActionPropertyException, SerializationException, IllegalAccessException, InvocationTargetException {
        try {
            int n = 0;
            while (n < stringArray.length) {
                Integer.parseInt(stringArray[n]);
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            configuration.setMachineListCols(configuration.getMLColsDefault());
            configuration.update(connection);
            connection.commit();
            Server.reloadConfiguration();
            return false;
        }
        return true;
    }

    private HtmlTable createHtmlTable(PaginationState paginationState, String[] stringArray, HostPropDisplay hostPropDisplay, String string) {
        HtmlTable htmlTable = new HtmlTable();
        htmlTable.setHasCheckbox(true);
        htmlTable.setId("machineList");
        htmlTable.setPaginationMgr(paginationState.getPagMgr());
        HtmlTableHeader htmlTableHeader = htmlTable.getHeader();
        htmlTableHeader.setCheckboxId("checkboxToggle");
        StringBuffer stringBuffer = new StringBuffer();
        int n = paginationState.getSortCol();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (Integer.parseInt(stringArray[n2]) == 27) {
                stringBuffer.append("<a href='JavaScript:sortByCol(").append(Integer.parseInt(stringArray[n2])).append(")' class='blackLink'>").append("<img src='images/MarkedForAction.gif' align=absMiddle border=0 ").append("alt='").append(Resource.getString("displaymachinesbean_action_required", string)).append("' title='").append(Resource.getString("displaymachinesbean_action_required", string)).append("'").append("/>");
            } else {
                stringBuffer.append("<a href='JavaScript:sortByCol(").append(Integer.parseInt(stringArray[n2])).append(")' class='blackLink'>").append(hostPropDisplay.getTruncatedHeader(Integer.parseInt(stringArray[n2])));
            }
            if (Integer.parseInt(stringArray[n2]) == n) {
                stringBuffer.append(HtmlTable.getSortMarker((int)paginationState.getSortOrder(), (String)string));
            }
            stringBuffer.append("</a>");
            htmlTableHeader.addCell(stringBuffer.toString());
            stringBuffer.delete(0, stringBuffer.length());
            ++n2;
        }
        return htmlTable;
    }

    private void addMachines(HtmlTable htmlTable, String[] stringArray, HostPropDisplay hostPropDisplay, Host[] hostArray, boolean bl, Connection connection, long l, int n) throws Exception {
        HtmlTableRow htmlTableRow = null;
        HtmlTableCell htmlTableCell = null;
        long l2 = System.currentTimeMillis();
        int n2 = 0;
        int n3 = hostArray.length;
        int n4 = 0;
        while (n2 < n3) {
            if (bl && n4 != hostArray[n2].getNetworkID()) {
                this.addNetworkHeader(htmlTable, connection, hostArray[n2].getNetworkID());
            }
            Host host = hostArray[n2];
            host.calculateProperties(l2, l);
            hostPropDisplay.setDbo(host);
            htmlTableRow = htmlTable.addRow(hostPropDisplay.getStyle());
            htmlTableRow.setCheckboxId(hostPropDisplay.getFullProperty(29) + hostPropDisplay.getFullProperty(1));
            int n5 = 0;
            while (n5 < stringArray.length) {
                htmlTableCell = htmlTableRow.addCell(hostPropDisplay.getFullProperty(Integer.parseInt(stringArray[n5])));
                htmlTableCell.setOnClick("clickNonCheckboxCell(" + host.getId() + "," + (n + n2) + ")");
                ++n5;
            }
            n4 = host.getNetworkID();
            ++n2;
        }
    }

    private void addNetworkHeader(HtmlTable htmlTable, Connection connection, int n) throws Exception {
        Network[] networkArray = Network.getByQuery(connection, "select * from Networks where NetworkID = " + n);
        if (networkArray.length < 1) {
            throw new Exception("No network associated with NetworkID of " + n + ".");
        }
        if (networkArray.length > 1) {
            throw new Exception("More than one network associated with NetworkID of " + n + ".");
        }
        HtmlTableRow htmlTableRow = htmlTable.addRow(6);
        HtmlTableCell htmlTableCell = htmlTableRow.addCell(networkArray[0].getNetworkName() + "<img src='images/px_trans.gif' height=1 width=6 border=0>" + networkArray[0].getNetworkAddress() + StringUtil.getShortNetmask((String)networkArray[0].getSubnetMask()));
        htmlTableCell.setOnClick("displaySubnet( \"" + networkArray[0].getId() + "\", \"" + networkArray[0].getNetworkAddress() + "\" )");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

