/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.ui.deploywizard;

import com.mcafee.epo.common.ui.util.SessionUtil;
import com.mcafee.epo.compliance.action.ActionInvocationException;
import com.mcafee.epo.compliance.action.ActionInvoker;
import com.mcafee.epo.compliance.action.EPOActionContext;
import com.mcafee.epo.compliance.action.concrete.DeploySensorAction;
import com.mcafee.epo.compliance.db.Configuration;
import com.mcafee.epo.compliance.db.Network;
import com.mcafee.epo.compliance.event.EventFactory;
import com.mcafee.epo.compliance.event.concrete.UserRequestEvent;
import com.mcafee.epo.compliance.server.Server;
import com.mcafee.epo.compliance.ui.deploywizard.DeployWizardStateBean;
import com.mcafee.epo.compliance.ui.util.EpoHostList;
import com.mcafee.epo.compliance.ui.util.SubnetInfo;
import com.mcafee.epo.compliance.util.Resource;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.ui.ActionBeanBase;
import com.mcafee.epo.core.util.BeanUtil;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DeploySensorsBean
extends ActionBeanBase {
    private DeployWizardStateBean m_state;
    private static final Logger m_log = Logger.getLogger((String)(class$com$mcafee$epo$compliance$ui$deploywizard$DeploySensorsBean == null ? (class$com$mcafee$epo$compliance$ui$deploywizard$DeploySensorsBean = DeploySensorsBean.class$("com.mcafee.epo.compliance.ui.deploywizard.DeploySensorsBean")) : class$com$mcafee$epo$compliance$ui$deploywizard$DeploySensorsBean).getName());
    static /* synthetic */ Class class$com$mcafee$epo$compliance$ui$deploywizard$DeploySensorsBean;

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        this.m_state = (DeployWizardStateBean)httpServletRequest.getSession().getAttribute("deployWizBean");
        if (this.m_state != null) {
            BeanUtil.initBean((HttpServletRequest)httpServletRequest, (Object)this.m_state);
        }
        if (this.m_state == null) {
            String string = Resource.getString("deploysensorsbean_no_state_bean", this.m_lang);
            SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getString("jsputil_action_failed", this.m_lang), (String)string, (String)"displaysubnets.do");
            return "actiontaken.jsp";
        }
        String string = this.m_state.getSensorInstallDir();
        if (!SessionUtil.isNonEmptyString((String)string)) {
            String string2 = Resource.getString("deploysensorsbean_need_install_dir", this.m_lang);
            SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getString("jsputil_user_input_required", this.m_lang), (String)string2, (String)this.m_state.getReturnAction());
            return "actiontaken.jsp";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConf(Configuration configuration, String string) throws Exception {
        Connection connection = Server.getDb().getConnection();
        try {
            configuration.setSensorDeployAuto(this.m_state.getDeploymentAuto().toString());
            configuration.setNumSensorsPerSubnet(this.m_state.getNumberSensorsPerSubnet());
            configuration.setSensorDeployPref(this.m_state.getDeploymentCriteria());
            configuration.setSensorDeployHostOp(String.valueOf(this.m_state.getHostnameOperation()));
            configuration.setSensorDeployHostValue(this.m_state.getHostnameValue());
            configuration.setSensorInstallDir(string);
            configuration.update(connection);
            connection.commit();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        Server.reloadConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserRequestEvent createUserRequestEvent() throws SQLException {
        UserRequestEvent userRequestEvent;
        Connection connection = Server.getDb().getConnection();
        try {
            userRequestEvent = EventFactory.createUserRequestEvent(connection);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        return userRequestEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Network getNetwork(SubnetInfo subnetInfo) throws SQLException {
        Network network;
        Connection connection = Server.getDb().getConnection();
        try {
            network = Network.getBySubnetInfo(connection, subnetInfo.getNetworkAddress(), subnetInfo.getSubnetMask());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        return network;
    }

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        boolean bl = false;
        String string = this.m_state.getSensorInstallDir();
        Configuration configuration = Server.getConfiguration();
        UserRequestEvent userRequestEvent = null;
        DeploySensorAction deploySensorAction = new DeploySensorAction();
        EPOActionContext ePOActionContext = null;
        this.updateConf(configuration, string);
        userRequestEvent = this.createUserRequestEvent();
        EpoHostList epoHostList = this.m_state.getHostList();
        int n = 0;
        while (n < epoHostList.size()) {
            object = epoHostList.getAt(n);
            Network network = this.getNetwork((SubnetInfo)object);
            if (network == null) {
                throw new ActionInvocationException(Resource.getString("deploysensorsbean_netfindfailed", this.m_lang));
            }
            int n2 = 0;
            while (n2 < ((SubnetInfo)object).size()) {
                int n3 = Integer.parseInt(((SubnetInfo)object).getLeafNodeIdAt(n2));
                String string2 = ((SubnetInfo)object).getHostnameAt(n2);
                ePOActionContext = new EPOActionContext(userRequestEvent.getEventType(), userRequestEvent.getId(), network, n3, string2);
                try {
                    ActionInvoker.invokeAction(deploySensorAction, ePOActionContext);
                }
                catch (ActionInvocationException actionInvocationException) {
                    m_log.error((Object)Resource.getString("deploysensorsbean_failed"), (Throwable)actionInvocationException);
                    bl = true;
                }
                m_log.info((Object)Resource.formatString("deploysensorsbean_template_installed_to", string2));
                ++n2;
            }
            ++n;
        }
        epoHostList.clear();
        if (bl) {
            object = Resource.getString("deploysensorsbean_failures", this.m_lang);
            SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getString("jsputil_user_input_required", this.m_lang), (String)object, (String)"displayactionlist.do");
            return "actiontaken.jsp";
        }
        return "displayactionlist.do";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

