/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.ui.util;

import com.mcafee.epo.compliance.ui.util.SubnetInfo;
import com.mcafee.epo.core.ui.InvalidParameterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class EpoHostList {
    private boolean m_clearOnRead = false;
    private int m_index = 1;
    private ArrayList m_subnets = new ArrayList();

    public SubnetInfo addSubnet(String string, String string2) throws InvalidParameterException {
        if (!this.isValid(string, string2)) {
            throw new InvalidParameterException("Null or length zero parameter passed in.");
        }
        SubnetInfo subnetInfo = new SubnetInfo(string, string2);
        boolean bl = false;
        if (this.m_subnets.size() < 1) {
            this.m_subnets.add(subnetInfo);
            bl = true;
        }
        int n = 0;
        Iterator iterator = this.m_subnets.iterator();
        while (!bl && iterator.hasNext()) {
            SubnetInfo subnetInfo2 = (SubnetInfo)iterator.next();
            int n2 = string.compareTo(subnetInfo2.m_networkAddress);
            if (n2 < 0) {
                this.m_subnets.add(n, subnetInfo);
                bl = true;
            }
            if (n2 == 0) {
                n2 = string2.compareTo(subnetInfo2.m_subnetMask);
                if (n2 < 0) {
                    this.m_subnets.add(n, subnetInfo);
                    bl = true;
                }
                if (n2 == 0) {
                    subnetInfo = (SubnetInfo)this.m_subnets.get(n);
                    bl = true;
                }
            }
            ++n;
        }
        if (!bl) {
            this.m_subnets.add(n, subnetInfo);
        }
        return subnetInfo;
    }

    public void append(SubnetInfo subnetInfo) {
        this.m_subnets.add(subnetInfo);
    }

    public SubnetInfo getAt(int n) {
        return (SubnetInfo)this.m_subnets.get(n);
    }

    public int size() {
        return this.m_subnets.size();
    }

    public void clear() {
        this.m_subnets.clear();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIndex(int n) {
        this.m_index = n;
    }

    public void clearHosts() {
        Iterator iterator = this.m_subnets.iterator();
        while (iterator.hasNext()) {
            ((SubnetInfo)iterator.next()).clear();
        }
    }

    public boolean containsSubnet(String string, String string2) {
        boolean bl = false;
        Iterator iterator = this.m_subnets.iterator();
        while (!bl && iterator.hasNext()) {
            SubnetInfo subnetInfo = (SubnetInfo)iterator.next();
            if (subnetInfo.m_networkAddress.compareTo(string) != 0 || subnetInfo.m_networkAddress.compareTo(string) != 0) continue;
            bl = true;
        }
        return bl;
    }

    public void addHost(String string, String string2, String string3, String string4) throws InvalidParameterException {
        if (!this.isValid(string, string2, string3, string4)) {
            throw new InvalidParameterException("Null or length zero parameter passed in.");
        }
        SubnetInfo subnetInfo = this.addSubnet(string3, string4);
        subnetInfo.addHost(string, string2);
    }

    public void addToStore(HttpServletRequest httpServletRequest) throws InvalidParameterException {
        boolean bl = this.m_clearOnRead;
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf("patternSub") != 0) continue;
            if (bl) {
                bl = false;
                this.m_subnets.clear();
            }
            this.addSubnet(string.substring("patternSub".length()), httpServletRequest.getParameter(string));
        }
    }

    public void removeFromStore(HttpServletRequest httpServletRequest) throws InvalidParameterException {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf("patternSub") != 0) continue;
            SubnetInfo subnetInfo = this.addSubnet(string.substring("patternSub".length()), httpServletRequest.getParameter(string));
            this.m_subnets.remove(subnetInfo);
        }
    }

    public void updateIndex(int n, int n2) {
        int n3 = (this.m_index + n2 - 1) / n2;
        if (n > n3 * n2) {
            this.m_index = n / n2 * n2 + 1;
        }
        if (n > 0 && n <= (n3 - 1) * n2) {
            n3 = n / n2;
            this.m_index = n3 > 1 ? (n3 - 1) * n2 + 1 : 1;
        }
    }

    private boolean isValid(String string, String string2) {
        return this.isValid("A", "B", string, string2);
    }

    private boolean isValid(String string, String string2, String string3, String string4) {
        return string != null && string2 != null && string3 != null && string4 != null && string.length() >= 1 && string2.length() >= 1 && string3.length() >= 1 && string4.length() >= 1;
    }
}

