/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.util.snmp;

import com.mcafee.epo.compliance.util.snmp.SnmpResultsDispatcher;
import com.mcafee.epo.compliance.util.snmp.SnmpResultsListener;
import com.mcafee.epo.compliance.util.snmp.SnmpSessionWrapper;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.joesnmp.protocols.snmp.SnmpHandler;
import org.joesnmp.protocols.snmp.SnmpInt32;
import org.joesnmp.protocols.snmp.SnmpNull;
import org.joesnmp.protocols.snmp.SnmpObjectId;
import org.joesnmp.protocols.snmp.SnmpOctetString;
import org.joesnmp.protocols.snmp.SnmpParameters;
import org.joesnmp.protocols.snmp.SnmpPduPacket;
import org.joesnmp.protocols.snmp.SnmpPduRequest;
import org.joesnmp.protocols.snmp.SnmpPeer;
import org.joesnmp.protocols.snmp.SnmpSession;
import org.joesnmp.protocols.snmp.SnmpSyntax;
import org.joesnmp.protocols.snmp.SnmpVarBind;

public class SnmpBase
implements SnmpHandler,
SnmpResultsDispatcher {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$compliance$util$snmp$SnmpBase == null ? (class$com$mcafee$epo$compliance$util$snmp$SnmpBase = SnmpBase.class$("com.mcafee.epo.compliance.util.snmp.SnmpBase")) : class$com$mcafee$epo$compliance$util$snmp$SnmpBase));
    private SnmpSessionWrapper m_session;
    private SnmpObjectId m_oid;
    private SnmpPduRequest m_pdu;
    private SnmpPeer m_remoteSystem;
    private SnmpParameters m_params;
    private Set m_statusListeners = new HashSet();
    static /* synthetic */ Class class$com$mcafee$epo$compliance$util$snmp$SnmpBase;

    public void initGet(String string, String string2, InetAddress inetAddress) {
        this.init(160, string, null, string2, inetAddress);
        this.m_pdu.addVarBind(new SnmpVarBind(this.m_oid));
    }

    public void initSet(String string, String string2, String string3, Object object, InetAddress inetAddress) {
        SnmpNull snmpNull = new SnmpNull();
        if (object instanceof Integer) {
            snmpNull = new SnmpInt32((Integer)object);
        } else if (object instanceof String) {
            snmpNull = new SnmpOctetString(((String)object).getBytes());
        }
        this.init(163, string, string2, string3, inetAddress);
        SnmpVarBind snmpVarBind = new SnmpVarBind(this.m_oid, (SnmpSyntax)snmpNull);
        this.m_pdu.addVarBind(snmpVarBind);
    }

    private void init(int n, String string, String string2, String string3, InetAddress inetAddress) {
        this.m_remoteSystem = new SnmpPeer(inetAddress);
        this.m_oid = new SnmpObjectId(string3);
        this.m_params = new SnmpParameters(string);
        if (string2 != null) {
            this.m_params.setWriteCommunity(string2);
        }
        this.m_remoteSystem.setParameters(this.m_params);
        this.m_remoteSystem.setTimeout(5000);
        this.m_pdu = new SnmpPduRequest(n);
        this.m_pdu.setPeer(this.m_remoteSystem);
    }

    public int send() throws SocketException {
        this.m_session = new SnmpSessionWrapper(this.m_remoteSystem);
        int n = this.m_session.send((SnmpPduPacket)this.m_pdu, this);
        return n;
    }

    public int send(Object object) throws SocketException {
        this.m_session = new SnmpSessionWrapper(this.m_remoteSystem);
        this.m_session.setCallBackDataObject(object);
        int n = this.m_session.send((SnmpPduPacket)this.m_pdu, this);
        return n;
    }

    public void snmpReceivedPdu(SnmpSession snmpSession, int n, SnmpPduPacket snmpPduPacket) {
        SnmpVarBind snmpVarBind;
        int n2 = -1;
        HashMap<SnmpObjectId, SnmpSyntax> hashMap = new HashMap<SnmpObjectId, SnmpSyntax>();
        Object object = null;
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)"Received a response from the peer.");
            m_log.debug((Object)("Remote System: " + snmpSession.getPeer().getPeer()));
            m_log.debug((Object)("The command sent: " + n));
            m_log.debug((Object)("The number of PDUs returned: " + snmpPduPacket.getLength()));
        }
        int n3 = 0;
        while (n3 < snmpPduPacket.getLength()) {
            snmpVarBind = snmpPduPacket.getVarBindAt(n3);
            hashMap.put(snmpVarBind.getName(), snmpVarBind.getValue());
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)("The returned OID: " + snmpVarBind.getName()));
                m_log.debug((Object)("The value returned: " + snmpVarBind.getValue()));
            }
            ++n3;
        }
        if (snmpPduPacket instanceof SnmpPduRequest) {
            snmpVarBind = (SnmpPduRequest)snmpPduPacket;
            n2 = snmpVarBind.getErrorStatus();
        }
        if (snmpSession instanceof SnmpSessionWrapper) {
            object = ((SnmpSessionWrapper)snmpSession).getCallBackDataObject();
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("SNMP Error status=" + n2));
            if (n2 == 0) {
                m_log.debug((Object)"SNMP Command completed successfully!");
            } else {
                m_log.debug((Object)"SNMP Command failed with error!");
            }
        }
        this.dispatchStatus(n2, hashMap, object);
        snmpSession.close();
    }

    public void snmpInternalError(SnmpSession snmpSession, int n, SnmpSyntax snmpSyntax) {
        this.dispatchStatus(100, null, ((SnmpSessionWrapper)snmpSession).getCallBackDataObject());
        m_log.debug((Object)"Received an SNMP internal error.");
    }

    public void snmpTimeoutError(SnmpSession snmpSession, SnmpSyntax snmpSyntax) {
        this.dispatchStatus(101, null, ((SnmpSessionWrapper)snmpSession).getCallBackDataObject());
        m_log.debug((Object)"Received an SNMP timeout error.");
    }

    public void addSnmpResultsListener(SnmpResultsListener snmpResultsListener) {
        this.m_statusListeners.add(snmpResultsListener);
    }

    public void removeSnmpResultsListener(SnmpResultsListener snmpResultsListener) {
        this.m_statusListeners.remove(snmpResultsListener);
    }

    private void dispatchStatus(int n, HashMap hashMap, Object object) {
        Iterator iterator = this.m_statusListeners.iterator();
        while (iterator.hasNext()) {
            SnmpResultsListener snmpResultsListener = (SnmpResultsListener)iterator.next();
            snmpResultsListener.receiveSnmpResults(n, hashMap, object);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

