/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.util.thread;

import com.mcafee.epo.compliance.util.thread.PeriodicTask;
import com.mcafee.epo.compliance.util.thread.WorkerThread;
import java.util.ArrayList;

public class PeriodicTaskThread
extends WorkerThread {
    private ArrayList m_tasks = new ArrayList();

    public PeriodicTaskThread(long l) {
        this.setSleepTime(l);
    }

    public PeriodicTaskThread() {
        this(60000L);
    }

    public synchronized void addPeriodicTask(PeriodicTask periodicTask, long l) {
        periodicTask.setRunPeriodInMs(l, System.currentTimeMillis());
        this.m_tasks.add(periodicTask);
    }

    public synchronized void addPeriodicTask(PeriodicTask periodicTask) {
        this.m_tasks.add(periodicTask);
    }

    public synchronized void runAsync(PeriodicTask periodicTask) {
        periodicTask.runAsync(System.currentTimeMillis());
        this.wakeupThread();
    }

    protected String threadName() {
        return "Periodic Task Runner";
    }

    protected synchronized void doTask() {
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < this.m_tasks.size()) {
            ((PeriodicTask)this.m_tasks.get(n)).run(l);
            ++n;
        }
    }
}

