/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.ruleEngine.rules.notificationTarget;

import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.util.LocaleName;
import com.mcafee.epo.core.util.StringUtil;
import com.mcafee.epo.notifications.db.AlertUserRule;
import com.mcafee.epo.notifications.db.NotificationLog;
import com.mcafee.epo.notifications.db.TokenList;
import com.mcafee.epo.notifications.ruleEngine.MessageAdaptorInterface;
import com.mcafee.epo.notifications.ruleEngine.RuleInterface;
import com.mcafee.epo.notifications.ruleEngine.RuleListenerInterface;
import com.mcafee.epo.notifications.ruleEngine.rules.MessageAdaptorMap;
import com.mcafee.epo.notifications.ruleEngine.rules.RuleLogic;
import com.mcafee.epo.notifications.ruleEngine.rules.RuleLogicInterface;
import com.mcafee.epo.notifications.ruleEngine.rules.UserNotificationRule;
import com.mcafee.epo.notifications.ruleEngine.rules.notificationTarget.ActionEnvironment;
import com.mcafee.epo.notifications.ruleEngine.rules.notificationTarget.NotificationTargetFactory;
import com.mcafee.epo.notifications.ruleEngine.rules.notificationTarget.NotificationTargetFactoryException;
import com.mcafee.epo.notifications.ruleEngine.rules.notificationTarget.NotificationTargetSettings;
import com.mcafee.epo.notifications.ui.util.NotificationLogPropDisplay;
import com.mcafee.epo.notifications.ui.util.PropDisplay;
import com.mcafee.epo.notifications.util.Progress;
import com.mcafee.epo.notifications.util.ProgressListener;
import com.mcafee.epo.notifications.util.Resource;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class NotificationTargetBase
extends DatabaseObject
implements RuleLogicInterface,
Progress,
ProgressListener {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$notifications$ruleEngine$rules$notificationTarget$NotificationTargetBase == null ? (class$com$mcafee$epo$notifications$ruleEngine$rules$notificationTarget$NotificationTargetBase = NotificationTargetBase.class$("com.mcafee.epo.notifications.ruleEngine.rules.notificationTarget.NotificationTargetBase")) : class$com$mcafee$epo$notifications$ruleEngine$rules$notificationTarget$NotificationTargetBase));
    public static final int COL_ID = 1;
    public static final int COL_RULE_ID = 2;
    public static final int COL_RULE_CLASS_NAME = 3;
    public static final int COL_LOCALE_NAME = 4;
    public static final int NUM_COLS = 4;
    public static final int NUM_PROPERTIES = 4;
    public static final int MAX_LEN_NAME = 25;
    public static final int MAX_LEN_LOCALE_NAME = 2;
    public static final String TABLE_NAME = "notificationTarget";
    public static final String[] PROPERTY_NAMES = new String[]{"", "NotificationTargetId", "AlertUserRuleId", "RuleClassName", "LocaleName"};
    public static final String SQL_GET_BY_RULE = "select * from notificationTarget where AlertUserRuleId=?";
    protected static final String UNIQUE_SQL = "select * from notificationTarget where notificationTargetId=?";
    private HashMap m_progressMap = new HashMap();
    private long m_id = -1L;
    private long m_userRuleId = -1L;
    private String m_ruleClass = "";
    protected String m_validateError = null;
    private String m_localeName = "en";
    private boolean m_synchronous = false;
    private NotificationTargetSettings m_settings;
    private RuleLogic m_ruleInterface = new RuleLogic(this);
    static /* synthetic */ Class class$com$mcafee$epo$notifications$ruleEngine$rules$notificationTarget$NotificationTargetBase;

    public abstract String getType();

    public abstract int getNumSettings();

    public abstract String[] getSettingNames();

    public abstract String getSettingName(int var1);

    public abstract void validate();

    public abstract int invoke(MessageAdaptorInterface var1, Hashtable var2, NotificationLog var3, StringBuffer var4);

    public abstract void calculateProperties(Connection var1) throws SQLException;

    public String getTypeForDisplay(String string) {
        return Resource.getString("common_na", string);
    }

    public String getDetail(String string) {
        return Resource.getString(this.getUnLocalizedDetail(), string);
    }

    public String getUnLocalizedDetail() {
        return "common_na";
    }

    public String getRecipients() {
        return null;
    }

    public void updateRule(RuleInterface ruleInterface) {
        this.m_ruleInterface.updateRule(((NotificationTargetBase)ruleInterface).m_ruleInterface);
    }

    public void start() {
        this.m_ruleInterface.start();
    }

    public void stop() {
        this.m_ruleInterface.stop();
    }

    public boolean isStarted() {
        return this.m_ruleInterface.isStarted();
    }

    public void addTrueRule(RuleListenerInterface ruleListenerInterface) {
        this.m_ruleInterface.addTrueRule(ruleListenerInterface);
    }

    public void removeTrueRule(RuleListenerInterface ruleListenerInterface) {
        this.m_ruleInterface.removeTrueRule(ruleListenerInterface);
    }

    public List getTrueRules() {
        return this.m_ruleInterface.getTrueRules();
    }

    public void addFalseRule(RuleListenerInterface ruleListenerInterface) {
        this.m_ruleInterface.addFalseRule(ruleListenerInterface);
    }

    public void removeFalseRule(RuleListenerInterface ruleListenerInterface) {
        this.m_ruleInterface.removeFalseRule(ruleListenerInterface);
    }

    public List getFalseRules() {
        return this.m_ruleInterface.getFalseRules();
    }

    public int size() {
        return this.m_ruleInterface.size();
    }

    public void doUpdate(RuleInterface ruleInterface) {
        this.m_ruleInterface.doUpdate(ruleInterface);
    }

    public String getRuleID() {
        return this.getClass().getName() + this.getNotificationTargetId();
    }

    public Object getRuleIDAsObject() {
        return new Long(this.getNotificationTargetId());
    }

    public void updateMessage(RuleInterface ruleInterface) {
        this.m_ruleInterface.updateMessage(ruleInterface);
    }

    public boolean onMessage(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        return this.m_ruleInterface.onMessage(messageAdaptorInterface, hashtable);
    }

    public void onTime(double d, Hashtable hashtable) {
        this.m_ruleInterface.onTime(d, hashtable);
    }

    public String getRuleText() {
        return this.m_ruleInterface.getRuleText();
    }

    public void setRuleText(String string) {
        this.m_ruleInterface.setRuleText(string);
    }

    private static final NotificationTargetBase[] createNTByResponseId(Connection connection, long l, NotificationTargetFactory notificationTargetFactory) throws SQLException, NotificationTargetFactoryException {
        return NotificationTargetBase.createNTByQuery(connection, SQL_GET_BY_RULE, l, notificationTargetFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final NotificationTargetBase[] createNTByQuery(Connection connection, String string, long l, NotificationTargetFactory notificationTargetFactory) throws SQLException, NotificationTargetFactoryException {
        NotificationTargetBase[] notificationTargetBaseArray;
        block3: {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setLong(1, l);
                ResultSet resultSet = preparedStatement.executeQuery();
                Vector<NotificationTargetBase> vector = new Vector<NotificationTargetBase>();
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    int n2 = resultSet.getInt(2);
                    String string2 = resultSet.getString(3);
                    String string3 = resultSet.getString(4);
                    NotificationTargetBase notificationTargetBase = notificationTargetFactory.create(string2);
                    notificationTargetBase.setUniqueID(n);
                    notificationTargetBase.setAlertUserRuleId(n2);
                    notificationTargetBase.setLocaleName(string3);
                    notificationTargetBase.loadSettings(connection);
                    notificationTargetBase.calculateProperties(connection);
                    vector.add(notificationTargetBase);
                }
                NotificationTargetBase[] notificationTargetBaseArray2 = new NotificationTargetBase[]{};
                notificationTargetBaseArray = vector.toArray(notificationTargetBaseArray2);
                Object var14_14 = null;
                if (preparedStatement == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var14_15 = null;
                    if (preparedStatement == null) break block4;
                    preparedStatement.close();
                }
                throw throwable;
            }
            preparedStatement.close();
        }
        return notificationTargetBaseArray;
    }

    public static NotificationTargetBase[] getByRuleId(Connection connection, long l, NotificationTargetFactory notificationTargetFactory) throws SQLException, NotificationTargetFactoryException {
        NotificationTargetBase[] notificationTargetBaseArray = NotificationTargetBase.createNTByResponseId(connection, l, notificationTargetFactory);
        int n = 0;
        while (n < notificationTargetBaseArray.length) {
            notificationTargetBaseArray[n].loadSettings(connection);
            ++n;
        }
        return notificationTargetBaseArray;
    }

    public static void deleteNotificationTarget(Connection connection, NotificationTargetBase notificationTargetBase) throws SQLException {
        NotificationTargetBase.deleteNotificationTargetById(connection, notificationTargetBase.getNotificationTargetId());
    }

    public static void deleteNotificationTargetById(Connection connection, long l) throws SQLException {
        String string = "delete from NotificationTargetSettings where " + PROPERTY_NAMES[1] + "=" + l;
        String string2 = "delete from notificationTarget where " + PROPERTY_NAMES[1] + "=" + l;
        m_log.debug((Object)("Executing SQL: " + string));
        DatabaseUtil.executeUpdate((Connection)connection, (String)string);
        m_log.debug((Object)("Executing SQL: " + string2));
        DatabaseUtil.executeUpdate((Connection)connection, (String)string2);
    }

    public static NotificationTargetBase getById(Connection connection, Class clazz, long l) throws SQLException {
        Vector vector = null;
        PreparedStatement preparedStatement = null;
        preparedStatement = connection.prepareStatement(UNIQUE_SQL);
        preparedStatement.setLong(1, l);
        vector = DatabaseObject.getByQuery((Connection)connection, (PreparedStatement)preparedStatement, (Class)clazz, (int)1, (int)1);
        if (vector.size() < 1) {
            return null;
        }
        if (vector.size() > 1) {
            throw new SQLException("getById() returned >1 row!");
        }
        NotificationTargetBase notificationTargetBase = (NotificationTargetBase)vector.firstElement();
        notificationTargetBase.loadSettings(connection);
        return notificationTargetBase;
    }

    public int getNumColumns() {
        return 4;
    }

    public int getNumProperties() {
        return 4 + this.getNumSettings();
    }

    public String getPropertyName(int n) {
        if (n >= 4) {
            return this.getSettingName(n - 4);
        }
        return PROPERTY_NAMES[n];
    }

    public Object getProperty(int n) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (n >= 4) {
            return this.m_settings.getProperty(n);
        }
        return super.getProperty(n);
    }

    public Object getProperty(String string) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String[] stringArray = this.getSettingNames();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string)) {
                return this.m_settings.getProperty(string);
            }
            ++n;
        }
        return super.getProperty(string);
    }

    public String getInsertSql() {
        return "insert into notificationTarget values(?, ?, ?)";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)1, (long)this.m_userRuleId);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)2, (String)this.getType(), (int)25);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)3, (String)this.getLocaleName(), (int)2);
    }

    public String getUpdateSql() {
        return "update notificationTarget set AlertUserRuleId=?, RuleClassName=?, LocaleName=? where NotificationTargetId=?";
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)4, (long)this.m_id);
    }

    public void setUniqueID(int n) throws SQLException {
        this.m_id = n;
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        this.m_id = resultSet.getLong(1);
        this.m_userRuleId = resultSet.getLong(2);
        this.m_ruleClass = resultSet.getString(3);
        this.m_localeName = resultSet.getString(4);
    }

    public void add(Connection connection, boolean bl) throws SQLException {
        super.add(connection, bl);
        this.saveSettings(connection);
    }

    public void add(Connection connection) throws SQLException {
        super.add(connection);
        this.saveSettings(connection);
    }

    public void update(Connection connection) throws SQLException {
        super.update(connection);
        this.saveSettings(connection);
    }

    public NotificationTargetBase(String string) {
        this.m_ruleClass = string;
        this.m_settings = new NotificationTargetSettings();
        this.m_settings.setSettingNames(this.getSettingNames());
    }

    public Vector asVector(Object object) {
        Vector<Object> vector = new Vector<Object>();
        if (object == null) {
            return vector;
        }
        if (object instanceof Hashtable) {
            vector.addAll(((Hashtable)object).keySet());
        } else if (object instanceof Collection) {
            vector.addAll((Collection)object);
        } else {
            vector.add(object);
        }
        return vector;
    }

    private Hashtable prepareAggregatedValues(NotificationLog notificationLog, Hashtable hashtable) {
        Hashtable hashtable2 = hashtable;
        m_log.debug((Object)"Preparing aggregated values.");
        NotificationLogPropDisplay notificationLogPropDisplay = new NotificationLogPropDisplay(this.getLocaleName());
        notificationLogPropDisplay.setDbo(notificationLog);
        String[] stringArray = TokenList.getTokenList(null);
        int n = 0;
        while (n < stringArray.length) {
            try {
                String string = ((PropDisplay)notificationLogPropDisplay).getFullProperty(TokenList.getColumnForToken(stringArray[n]), false);
                m_log.debug((Object)("Replacing substitution value for " + stringArray[n] + " with " + string));
                hashtable2.put(stringArray[n], string);
            }
            catch (Exception exception) {
                m_log.debug((Object)("Could not find value for property: " + stringArray[n] + " setting to blank."));
                hashtable2.put(stringArray[n], "");
            }
            ++n;
        }
        m_log.debug((Object)("New context map is: " + hashtable2));
        return hashtable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEventDescriptions(Hashtable hashtable) throws SQLException {
        Object object;
        String string = (String)LocaleName.getLanguages().get(this.getLocaleName());
        m_log.debug((Object)("Going to add descriptions for language ID: " + string));
        Hashtable hashtable2 = (Hashtable)hashtable.get("EventID");
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        Set set = hashtable2.keySet();
        Vector<String> vector = new Vector<String>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = ActionEnvironment.instance().getEPODbConnection();
            statement = connection.createStatement();
            object = set.iterator();
            while (object.hasNext()) {
                int n = Integer.parseInt(object.next().toString());
                String string2 = "select * from EventFilterDesc where EventID=" + n + " AND [Language]='" + string + "'";
                m_log.debug((Object)("Looking for event description with SQL=" + string2));
                resultSet = statement.executeQuery(string2);
                if (!resultSet.next()) continue;
                vector.add(resultSet.getString(2));
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            DatabaseUtil.close((Statement)statement);
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Statement)statement);
        DatabaseUtil.close((Connection)connection);
        object = StringUtil.getStringFromCollection(vector, (String)"; ");
        m_log.debug((Object)("Putting the following descriptions in the context:" + (String)object));
        hashtable.put("EventDescriptions", object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean evaluate(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        Hashtable<String, Timestamp> hashtable2 = new Hashtable<String, Timestamp>();
        hashtable2.putAll(hashtable);
        m_log.debug((Object)("******************************* In evaluate for :" + this.getClass().getName()));
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        hashtable2.put("TimeNotificationSent", timestamp);
        try {
            m_log.debug((Object)"Adding the event descriptions.");
            this.addEventDescriptions(hashtable2);
        }
        catch (Exception exception) {
            m_log.warn((Object)"Failed to lookup the event descriptions from the database.", (Throwable)exception);
        }
        try {
            Object object;
            NotificationLog notificationLog;
            block28: {
                Object object2;
                m_log.debug((Object)"Creating the NotificationLog entry.");
                notificationLog = new NotificationLog();
                MessageAdaptorMap messageAdaptorMap = new MessageAdaptorMap(messageAdaptorInterface, hashtable2);
                AlertUserRule alertUserRule = (AlertUserRule)((Object)hashtable2.get(UserNotificationRule.RULE_OBJECT_TAG));
                if (messageAdaptorInterface == null) {
                    m_log.error((Object)"Message is NULL");
                    return false;
                }
                if (hashtable2 == null) {
                    m_log.error((Object)"Context is NULL");
                    return false;
                }
                m_log.debug((Object)("Context is " + hashtable2));
                try {
                    object2 = NotificationLog.PROPERTY_NAMES;
                    int n = 0;
                    while (true) {
                        if (n >= ((String[])object2).length) {
                            notificationLog.setNotificationRuleId(alertUserRule.getId());
                            notificationLog.setSiteId(alertUserRule.getSiteId());
                            notificationLog.setNotificationType(this.getType());
                            notificationLog.setNotificationDetails(this.getUnLocalizedDetail());
                            notificationLog.setNotificationRecipients(this.getRecipients());
                            notificationLog.setPriority(alertUserRule.getPriority());
                            notificationLog.setThreatText(alertUserRule.getThreatText());
                            notificationLog.setThreatTextOperator(alertUserRule.getThreatExp());
                            notificationLog.setConfiguredEventCategories(alertUserRule.getEventCategoryNames());
                            notificationLog.setConfiguredProductFamilies(alertUserRule.getAlertFamilyNames());
                            break;
                        }
                        String string = object2[n];
                        if (string.length() > 0) {
                            try {
                                object = messageAdaptorMap.getAsObject(string);
                                if (object != null) {
                                    m_log.debug((Object)("Setting property: " + string + " of type: " + object.getClass().getName() + " to value: " + object));
                                    notificationLog.setProperty(string, object);
                                } else {
                                    m_log.debug((Object)("Parameter for " + string + " is null."));
                                }
                            }
                            catch (Exception exception) {
                                m_log.debug((Object)("Unable to set property: " + string + ": " + exception.getMessage()));
                            }
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    m_log.error((Object)"", (Throwable)exception);
                }
                object2 = null;
                try {
                    try {
                        object2 = ActionEnvironment.instance().getDbConnection();
                        if (m_log.isDebugEnabled()) {
                            m_log.debug((Object)"Adding Notification Log entry to database.");
                            m_log.debug((Object)notificationLog.toString());
                        }
                        notificationLog.add((Connection)object2, true);
                        object2.commit();
                    }
                    catch (Exception exception) {
                        m_log.error((Object)"Error adding Notification Log entry to database.", (Throwable)exception);
                        DatabaseUtil.rollback((Connection)object2);
                        Object var13_20 = null;
                        DatabaseUtil.close((Connection)object2);
                        break block28;
                    }
                    Object var13_19 = null;
                }
                catch (Throwable throwable) {
                    Object var13_21 = null;
                    DatabaseUtil.close((Connection)object2);
                    throw throwable;
                }
                DatabaseUtil.close((Connection)object2);
            }
            Hashtable hashtable3 = this.prepareAggregatedValues(notificationLog, hashtable2);
            int n = -1;
            object = new StringBuffer();
            m_log.debug((Object)"------------------------------------------------- Invoking action.");
            m_log.info((Object)Resource.formatString("notificationtargetbase_sending_notification", this.toString()));
            n = this.invoke(messageAdaptorInterface, hashtable3, notificationLog, (StringBuffer)object);
            if (n > 0) {
                m_log.error((Object)(Resource.getString("notificationtargetbase_invoke_failed") + ":" + object));
            }
            if (n >= 0) {
                m_log.debug((Object)("Result was " + n + ", updating status."));
                this.updateStatus(notificationLog, n, (StringBuffer)object);
            } else {
                m_log.debug((Object)"Result was -1, skipping status update.");
            }
            if (n == 0) {
                this.doTrueRules(messageAdaptorInterface, hashtable2);
            } else if (n > 0) {
                this.doFalseRules(messageAdaptorInterface, hashtable2);
            }
            if (n != 0) return false;
            return true;
        }
        catch (Exception exception) {
            m_log.error((Object)"", (Throwable)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateStatus(NotificationLog notificationLog, int n, StringBuffer stringBuffer) {
        if (notificationLog == null) {
            return;
        }
        m_log.debug((Object)("Setting result to: " + n));
        notificationLog.setStatus(n);
        m_log.debug((Object)("Setting output to: " + stringBuffer));
        if (stringBuffer != null && stringBuffer.length() != 0) {
            notificationLog.setActionOutput(stringBuffer.toString());
        }
        Connection connection = null;
        try {
            try {
                connection = ActionEnvironment.instance().getDbConnection();
                m_log.debug((Object)"Updating Notification Log entry to database.");
                notificationLog.update(connection);
                connection.commit();
            }
            catch (SQLException sQLException) {
                m_log.error((Object)Resource.getString("notificationlogupdate_failed"), (Throwable)sQLException);
                DatabaseUtil.rollback((Connection)connection);
                Object var7_6 = null;
                DatabaseUtil.close((Connection)connection);
                return;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    protected void setLogMessageBody(NotificationLog notificationLog, String string) {
        notificationLog.setMessageBody(string);
    }

    protected void setLogMessageSubject(NotificationLog notificationLog, String string) {
        notificationLog.setMessageSubject(string);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        return Resource.formatString("notification_target_tostring", new Object[]{this.getTypeForDisplay(string), this.getDetail(string), this.getRecipients() == null ? "" : this.getRecipients()});
    }

    public Object getSetting(int n) {
        return this.getSetting(this.getSettingName(n));
    }

    public Object getSetting(String string) {
        Object object = null;
        try {
            object = this.getProperty(string);
        }
        catch (Exception exception) {
            m_log.debug((Object)"", (Throwable)exception);
        }
        return object;
    }

    public void setSetting(String string, String string2) {
        m_log.debug((Object)("Setting " + string + " to: " + string2));
        this.m_settings.setProperty(string, string2);
    }

    public long getNotificationTargetId() {
        return this.m_id;
    }

    public void setNotificationTargetId(long l) {
        this.m_id = l;
    }

    public long getAlertUserRuleId() {
        return this.m_userRuleId;
    }

    public void setAlertUserRuleId(long l) {
        this.m_userRuleId = l;
    }

    public String getRuleClassName() {
        return this.m_ruleClass;
    }

    public void setRuleClassName(String string) {
        this.m_ruleClass = string;
    }

    public String getLocaleName() {
        return this.m_localeName;
    }

    public void setLocaleName(String string) {
        this.m_localeName = string;
    }

    public String getValidationErrorKey() {
        return this.m_validateError;
    }

    public boolean isValid() {
        return this.m_validateError == null;
    }

    protected void setNotificationTargetSettings(NotificationTargetSettings notificationTargetSettings) {
        this.m_settings = notificationTargetSettings;
    }

    private void loadSettings(Connection connection) throws SQLException {
        this.m_settings = NotificationTargetSettings.getSettingsForTarget(connection, this);
    }

    private void saveSettings(Connection connection) throws SQLException {
        if (this.m_settings != null) {
            String[] stringArray = this.getSettingNames();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                String string2 = null;
                try {
                    string2 = (String)this.getProperty(string);
                }
                catch (Exception exception) {
                    throw new SQLException(exception.getMessage());
                }
                this.m_settings.setProperty(string, string2);
                ++n;
            }
            this.m_settings.setNotificationTargetId(this.m_id);
            this.m_settings.update(connection);
        }
    }

    public Vector getListenersForThread() {
        Vector vector = (Vector)this.m_progressMap.get(Thread.currentThread().getName());
        if (vector == null) {
            vector = new Vector();
        }
        return vector;
    }

    public void addProgressListener(ProgressListener progressListener) {
        Vector vector = this.getListenersForThread();
        vector.add(progressListener);
        this.m_progressMap.put(Thread.currentThread().getName(), vector);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        Vector vector = this.getListenersForThread();
        vector.remove(progressListener);
    }

    public void sendFormattedStep(Vector vector, int n, int n2, int n3, String string, Object[] objectArray, boolean bl) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ProgressListener progressListener = (ProgressListener)iterator.next();
            String string2 = Resource.formatString(string, objectArray, progressListener.getLanguage());
            this.sendStep(progressListener, n, n2, n3, string2, bl);
        }
    }

    public void sendSimpleStep(Vector vector, int n, int n2, int n3, String string, boolean bl) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ProgressListener progressListener = (ProgressListener)iterator.next();
            String string2 = Resource.getString(string, progressListener.getLanguage());
            this.sendStep(progressListener, n, n2, n3, string2, bl);
        }
    }

    private void sendStep(ProgressListener progressListener, int n, int n2, int n3, String string, boolean bl) {
        if (bl) {
            progressListener.startStep(n, n2, string);
        } else {
            progressListener.endStep(n, n3, string);
        }
    }

    public void startStep(int n, int n2, String string) {
        this.sendSimpleStep(this.getListenersForThread(), n, n2, 0, string, true);
    }

    public void endStep(int n, int n2, String string) {
        this.sendSimpleStep(this.getListenersForThread(), n, 0, n2, string, false);
    }

    public String getLanguage() {
        Vector vector = this.getListenersForThread();
        String string = vector.size() > 0 ? ((ProgressListener)vector.firstElement()).getLanguage() : null;
        return string;
    }

    public boolean doFalseRules(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        return this.m_ruleInterface.doFalseRules(messageAdaptorInterface, hashtable);
    }

    public boolean doTrueRules(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        return this.m_ruleInterface.doTrueRules(messageAdaptorInterface, hashtable);
    }

    public boolean aggregateTrueEvent(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        return this.m_ruleInterface.aggregateTrueEvent(messageAdaptorInterface, hashtable);
    }

    public boolean hasAccumulatedData() {
        return this.m_ruleInterface.hasAccumulatedData();
    }

    public void setComputersExceed(long l) {
        this.m_ruleInterface.setComputersExceed(l);
    }

    public void setEventsExceed(long l) {
        this.m_ruleInterface.setEventsExceed(l);
    }

    public void setEveryEvent(boolean bl) {
        this.m_ruleInterface.setEveryEvent(bl);
    }

    public void setThrottle(boolean bl) {
        this.m_ruleInterface.setThrottle(bl);
    }

    public void setThrottleTimePeriod(long l) {
        this.m_ruleInterface.setThrottleTimePeriod(l);
    }

    public void setTimePeriod(long l) {
        this.m_ruleInterface.setTimePeriod(l);
    }

    public void setAggregateByComputers(boolean bl) {
        this.m_ruleInterface.setAggregateByComputers(bl);
    }

    public void setAggregateByEvents(boolean bl) {
        this.m_ruleInterface.setAggregateByEvents(bl);
    }

    public boolean getIsSynchronous() {
        return this.m_synchronous;
    }

    public void setIsSynchronous(boolean bl) {
        this.m_synchronous = bl;
    }

    public int hashCode() {
        return this.getRuleID().hashCode();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

