/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.common.db;

import com.mcafee.epo.common.db.DuplicateEntryException;
import com.mcafee.epo.common.db.Tool;
import java.sql.Connection;
import java.sql.SQLException;

public class ToolInstance {
    private Tool m_tool = null;

    private void init(Connection connection, int n) throws SQLException {
        this.m_tool = n != -1 ? Tool.getByID(connection, n) : new Tool();
    }

    public ToolInstance(Connection connection, int n) throws SQLException {
        this.init(connection, n);
    }

    public ToolInstance() {
        try {
            this.init(null, -1);
        }
        catch (SQLException sQLException) {}
    }

    public ToolInstance(Connection connection, String string, String string2, String string3) throws SQLException, DuplicateEntryException {
        this.init(connection, -1);
        this.m_tool.setExeName(string);
        this.m_tool.setCmdLine(string2);
        int n = this.m_tool.lookupIdForTool(connection);
        if (n != -1) {
            throw new DuplicateEntryException(n);
        }
        this.m_tool.setDisplayName(string3);
    }

    public void setExeName(String string) {
        this.m_tool.setExeName(string);
    }

    public void setDisplayName(String string) {
        this.m_tool.setDisplayName(string);
    }

    public void setCmdArgs(String string) {
        this.m_tool.setCmdLine(string);
    }

    public String getExeName() {
        return this.m_tool.getExeName();
    }

    public String getCmdLine() {
        return this.m_tool.getCmdLine();
    }

    public String getDisName() {
        return this.m_tool.getDisplayName();
    }

    public int getToolId() {
        return this.m_tool.getId();
    }

    public int commitToolInstance(Connection connection) throws SQLException {
        if (this.m_tool.getId() != -1) {
            this.m_tool.update(connection);
        } else {
            this.m_tool.add(connection, true);
        }
        connection.commit();
        return this.m_tool.getId();
    }

    public void removeFromDb(Connection connection) throws SQLException {
        Tool.deleteFromDatabase(connection, this.m_tool.getId());
        connection.commit();
    }
}

