/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.common.db;

import com.mcafee.epo.common.db.Tool;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.util.StringUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class ToolRegistry {
    private static final Map m_registryMap;
    private static final Logger m_log;
    static final String REGTOOLS_PROPS = "RegisteredTools.properties";
    private static final String SLASH;
    static final int MAX_EXE_NAME_LEN = 255;
    private final Properties m_toolDefs = new Properties();
    private final String m_description;
    static /* synthetic */ Class class$com$mcafee$epo$common$db$ToolInstance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$mcafee$epo$common$db$ToolRegistry;

    public ToolRegistry(String string) {
        if (string == null) {
            string = "";
        }
        this.m_description = string;
    }

    public ToolRegistry() {
        this("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Object object, ToolRegistry toolRegistry) {
        if (object == null) {
            throw new IllegalArgumentException("key may not be null");
        }
        Map map = m_registryMap;
        synchronized (map) {
            m_registryMap.put(object, toolRegistry);
        }
    }

    public static void register(int n, ToolRegistry toolRegistry) {
        ToolRegistry.register(new Integer(n), toolRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ToolRegistry get(Object object) {
        ToolRegistry toolRegistry = null;
        Map map = m_registryMap;
        synchronized (map) {
            toolRegistry = (ToolRegistry)m_registryMap.get(object);
        }
        return toolRegistry;
    }

    public static final String getExeCommandForApp(int n, String string) {
        return ToolRegistry.getExeCommandForApp(new Integer(n), string);
    }

    public static final String getExeCommandForApp(Integer n, String string) {
        String string2 = null;
        ToolRegistry toolRegistry = ToolRegistry.get(n);
        if (toolRegistry != null) {
            string2 = toolRegistry.getExeCommand(string);
        }
        return string2;
    }

    public static void updateToolInstanceNames(Connection connection, String string, String string2) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string3 = "update Tools set ExeName=? where ExeName=? ";
        preparedStatement = connection.prepareStatement(string3);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        int n = preparedStatement.executeUpdate();
        preparedStatement.close();
        m_log.debug((Object)("Updated " + n + " rows in Tools table with new registered executable name."));
    }

    public static boolean isCmdNameSaved(Connection connection, String string, int n) throws SQLException {
        String string2 = "select count(*) from Tools where DisplayName = '" + StringUtil.escapeSql(string) + "' and AppAssociation='" + n + "'";
        return DatabaseUtil.executeIntQuery(connection, string2.toString()) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRegisteredTools(ClassLoader classLoader) throws FileNotFoundException, IOException {
        InputStream inputStream = classLoader.getResourceAsStream(REGTOOLS_PROPS);
        if (inputStream == null) {
            throw new FileNotFoundException(REGTOOLS_PROPS);
        }
        Properties properties = this.m_toolDefs;
        synchronized (properties) {
            this.m_toolDefs.load(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRegisteredTools(String string) throws IOException {
        String string2 = null;
        if (string == null || string.length() == 0) {
            string = ".";
        }
        string2 = string + SLASH + REGTOOLS_PROPS;
        m_log.info((Object)("Creating properties file: " + string2));
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        Properties properties = this.m_toolDefs;
        synchronized (properties) {
            this.m_toolDefs.store(fileOutputStream, this.m_description);
        }
        fileOutputStream.close();
    }

    public void createRegisteredTools(ServletContext servletContext) throws IOException {
        String string = null;
        URL uRL = servletContext.getClass().getClassLoader().getResource(REGTOOLS_PROPS);
        m_log.debug((Object)("Class loader returned URL: " + uRL));
        if (uRL == null) {
            String string2 = (String)servletContext.getAttribute("org.apache.catalina.jsp_classpath");
            String[] stringArray = string2.split(";");
            int n = 0;
            while (n < stringArray.length) {
                m_log.debug((Object)("Found classpath element: " + stringArray[n]));
                if (stringArray[n].indexOf("WEB-INF") != -1 && stringArray[n].indexOf("classes") != -1) {
                    m_log.debug((Object)("Using classpath element: " + stringArray[n]));
                    string = stringArray[n];
                    break;
                }
                ++n;
            }
        } else {
            string = uRL.getPath();
        }
        this.createRegisteredTools(string);
    }

    public static boolean isExeUsedByCmdLine(Connection connection, String string, int n) throws SQLException {
        Tool[] toolArray = Tool.getAll(connection, n);
        if (toolArray != null) {
            int n2 = 0;
            while (n2 < toolArray.length) {
                if (toolArray[n2].getExeName().compareTo(string) == 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isCmdLineUsedByResponse(Connection connection, int n) {
        CharSequence charSequence;
        int n2 = 0;
        try {
            charSequence = new StringBuffer();
            charSequence.append("").append("'");
            n2 = DatabaseUtil.executeIntQuery(connection, "select count(*) from ActionSettings where Name='ToolId' and Value='" + n + "'");
        }
        catch (SQLException sQLException) {
            m_log.debug((Object)"Failed to count CMDline uses.", (Throwable)sQLException);
        }
        try {
            charSequence = "select count(*) from NotificationTarget as n left join NotificationTargetSettings as s on n.NotificationTargetId=s.NotificationTargetId where n.RuleClassName='exttool' and s.Name='toolSel' and s.Value='" + n + "'";
            n2 += DatabaseUtil.executeIntQuery(connection, (String)charSequence);
        }
        catch (SQLException sQLException) {
            m_log.debug((Object)"Failed to count CMDline uses.", (Throwable)sQLException);
        }
        return n2 > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRegisteredTools(ClassLoader classLoader) throws IOException {
        String string = null;
        URL uRL = classLoader.getResource(REGTOOLS_PROPS);
        if (uRL == null) {
            throw new FileNotFoundException(REGTOOLS_PROPS);
        }
        string = uRL.getFile();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        Properties properties = this.m_toolDefs;
        synchronized (properties) {
            this.m_toolDefs.store(fileOutputStream, this.m_description);
        }
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegisteredTool(String string, String string2, ClassLoader classLoader) throws IOException {
        Properties properties = this.m_toolDefs;
        synchronized (properties) {
            this.m_toolDefs.setProperty(string, string2);
            this.writeRegisteredTools(classLoader);
        }
    }

    public final Map getToolMap() {
        return this.m_toolDefs;
    }

    public Iterator getToolNames() {
        Set<Object> set = this.m_toolDefs.keySet();
        TreeSet<Object> treeSet = new TreeSet<Object>(set);
        return treeSet.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExeCommand(String string) {
        String string2 = null;
        Properties properties = this.m_toolDefs;
        synchronized (properties) {
            string2 = this.m_toolDefs.getProperty(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExeCount() {
        int n;
        Properties properties = this.m_toolDefs;
        synchronized (properties) {
            n = this.m_toolDefs.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExeNameSaved(String string) {
        boolean bl = false;
        if (!($assertionsDisabled || string != null && string.length() > 0)) {
            throw new AssertionError();
        }
        Properties properties = this.m_toolDefs;
        synchronized (properties) {
            Enumeration<?> enumeration = this.m_toolDefs.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string.equalsIgnoreCase(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExe(String string, ClassLoader classLoader) throws IOException {
        if (!($assertionsDisabled || string != null && string.length() > 0)) {
            throw new AssertionError();
        }
        Properties properties = this.m_toolDefs;
        synchronized (properties) {
            if (this.isExeNameSaved(string)) {
                this.m_toolDefs.remove(string);
                this.writeRegisteredTools(classLoader);
            }
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Testing load and unload of the properties file...");
        ClassLoader classLoader = (class$com$mcafee$epo$common$db$ToolRegistry == null ? (class$com$mcafee$epo$common$db$ToolRegistry = ToolRegistry.class$("com.mcafee.epo.common.db.ToolRegistry")) : class$com$mcafee$epo$common$db$ToolRegistry).getClassLoader();
        ToolRegistry toolRegistry = new ToolRegistry();
        try {
            toolRegistry.loadRegisteredTools(classLoader);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        try {
            toolRegistry.setRegisteredTool("\\\\\\\\", "ping.exe", classLoader);
            toolRegistry.setRegisteredTool("nslookup", "C:\\winnt\\system32\\nslookup.exe", classLoader);
            toolRegistry.writeRegisteredTools(classLoader);
            if (toolRegistry.isExeNameSaved("\\\\\\\\")) {
                toolRegistry.removeExe("\\\\\\\\", classLoader);
            } else {
                System.out.println("Tool name isn't saved!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Properties properties = System.getProperties();
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    public Object getDescription() {
        return this.m_description;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$mcafee$epo$common$db$ToolRegistry == null ? (class$com$mcafee$epo$common$db$ToolRegistry = ToolRegistry.class$("com.mcafee.epo.common.db.ToolRegistry")) : class$com$mcafee$epo$common$db$ToolRegistry).desiredAssertionStatus();
        m_registryMap = new HashMap(5);
        m_log = Logger.getLogger((String)(class$com$mcafee$epo$common$db$ToolInstance == null ? (class$com$mcafee$epo$common$db$ToolInstance = ToolRegistry.class$("com.mcafee.epo.common.db.ToolInstance")) : class$com$mcafee$epo$common$db$ToolInstance).getName());
        SLASH = System.getProperty("file.separator");
    }
}

