/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.common.db.epo;

import com.mcafee.epo.core.db.base.DatabaseTestSetup;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.TestCase;

public class EpoTestBase
extends TestCase {
    public static String SHALEYDEV_GUID = "C491AD26-62F0-4218-85A7-0C66CC005D80";
    public static String ANOTHER_GUID = "C491AD26-62F0-4218-85A7-0C66CC005D81";
    protected Connection m_epoDb = null;
    protected Connection m_mainDb = null;

    public EpoTestBase(String string) {
        super(string);
    }

    public void clearTestData() throws SQLException {
        DatabaseUtil.executeUpdate(this.m_epoDb, "delete from UserTable");
        DatabaseUtil.executeUpdate(this.m_epoDb, "delete from LeafNode");
        DatabaseUtil.executeUpdate(this.m_epoDb, "delete from ComputerProperties");
        DatabaseUtil.executeUpdate(this.m_epoDb, "delete from TaskSettings");
        DatabaseUtil.executeUpdate(this.m_epoDb, "delete from Task");
        DatabaseUtil.executeUpdate(this.m_epoDb, "delete from BranchNode");
        this.m_mainDb.commit();
        this.m_epoDb.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeArbitrarySQL(Connection connection, String string) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close(statement);
            throw throwable;
        }
        DatabaseUtil.close(statement);
    }

    public void setLeafNodeIDInsert(boolean bl) throws SQLException {
        String string = "SET IDENTITY_INSERT LeafNode ";
        if (bl) {
            this.executeArbitrarySQL(this.m_epoDb, string + "ON");
        } else {
            this.executeArbitrarySQL(this.m_epoDb, string + "OFF");
        }
    }

    public void setBranchNodeIDInsert(boolean bl) throws SQLException {
        String string = "SET IDENTITY_INSERT BranchNode ";
        if (bl) {
            this.executeArbitrarySQL(this.m_epoDb, string + "ON");
        } else {
            this.executeArbitrarySQL(this.m_epoDb, string + "OFF");
        }
    }

    public void setUp() throws Exception {
        DatabaseTestSetup databaseTestSetup = DatabaseTestSetup.instance();
        this.m_mainDb = DatabaseTestSetup.instance().getConnection();
        try {
            Method method = databaseTestSetup.getClass().getMethod("getEpoConnection", null);
            this.m_epoDb = (Connection)method.invoke((Object)databaseTestSetup, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.m_epoDb = this.m_mainDb;
        }
        try {
            this.clearTestData();
        }
        catch (Exception exception) {
            DatabaseUtil.close(this.m_epoDb);
            DatabaseUtil.close(this.m_mainDb);
            throw exception;
        }
    }

    public void tearDown() throws Exception {
        if (!this.m_epoDb.isClosed()) {
            this.m_epoDb.close();
        }
        if (!this.m_mainDb.isClosed()) {
            this.m_mainDb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createEpoTestData(Connection connection) throws SQLException {
        this.setBranchNodeIDInsert(true);
        try {
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(1, 'GlobalRoot', 7, 0)");
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(2, 'Directory', 4, 1)");
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(3, 'TestSite1', 6, 2)");
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(4, 'TestSite2', 6, 2)");
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(5, 'TestGroup1', 3, 3)");
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(6, 'TestGroup2', 3, 5)");
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(7, 'TestGroup3', 3, 6)");
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(8, 'TestGroup4', 3, 7)");
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(9, 'Lost&Found', 5, 2)");
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(9, 'Lost&Found', 5, 3)");
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(10, 'Lost&Found', 5, 4)");
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(11, 'Lost&Found', 5, 5)");
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(12, 'Lost&Found', 5, 6)");
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(13, 'Lost&Found', 5, 7)");
            DatabaseUtil.executeUpdate(connection, "insert into BranchNode (AutoID, NodeName, Type, ParentID) values(14, 'Lost&Found', 5, 8)");
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setBranchNodeIDInsert(false);
            throw throwable;
        }
        this.setBranchNodeIDInsert(false);
        this.setLeafNodeIDInsert(true);
        try {
            DatabaseUtil.executeUpdate(connection, "insert into [LeafNode] (AutoID,ParentID,LastUpdate,AgentGUID) values (1,1,'20030916090850',newid())");
            DatabaseUtil.executeUpdate(connection, "insert into [LeafNode] (AutoID,ParentID,LastUpdate,AgentGUID) values (2,1,'20030916090850',newid())");
            DatabaseUtil.executeUpdate(connection, "insert into [LeafNode] (AutoID,ParentID,LastUpdate,AgentGUID) values (3,0,'20030916090850',newid())");
            DatabaseUtil.executeUpdate(connection, "insert into [LeafNode] (AutoID,ParentID,LastUpdate,AgentGUID, NodePath, AgentPlatform) values (4,8,'20030916090850','" + SHALEYDEV_GUID + "', '1/2/3/4/5', 'WNTS:5:0:3')");
            DatabaseUtil.executeUpdate(connection, "insert into [LeafNode] (AutoID,ParentID,LastUpdate,AgentGUID, NodePath, AgentPlatform) values (5,8,'20030916090850','" + ANOTHER_GUID + "', '1/2/5', 'WNTW:5:0:3')");
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setLeafNodeIDInsert(false);
            throw throwable;
        }
        this.setLeafNodeIDInsert(false);
        DatabaseUtil.executeUpdate(connection, "insert into [ComputerProperties] (ParentID, NetAddress, ComputerName, DomainName, IPAddress) values (1, '00b0d0f964de', 'astro', 'beaeng', '10.0.0.1')");
        DatabaseUtil.executeUpdate(connection, "insert into [ComputerProperties] (ParentID, NetAddress, ComputerName, DomainName, IPAddress) values (2, '00065bbd1549', 'brewer', '', '10.0.0.2')");
        DatabaseUtil.executeUpdate(connection, "insert into [ComputerProperties] (ParentID, NetAddress, ComputerName, DomainName, IPAddress) values (3, '00065bbd1409', 'padre', 'beaeng', '10.0.0.3')");
        DatabaseUtil.executeUpdate(connection, "insert into [ComputerProperties] (ParentID, NetAddress, ComputerName, DomainName, IPAddress, OSPlatform,OSType, CPUSpeed, NumOfCPU, TotalPhysicalMemory, SubnetAddress, SubnetMask) values (4, '112233aabbcc', 'astro', 'workgroup', '192.168.1.100', 'Server', 'Windows', 500, 2, 128, '172.16.32.0', '255.255.255.0')");
        DatabaseUtil.executeUpdate(connection, "insert into [ComputerProperties] (ParentID, NetAddress, ComputerName, DomainName, IPAddress, OSPlatform) values (5, '112233aabbcc', 'wtest', 'workgroup', '192.168.1.100', 'Workstation')");
        DatabaseUtil.executeUpdate(connection, "insert into [Software] (ProductCode, SoftwareName, PackageName,PackDir, ProductCfgPath, InstallGUID, ProductVersion, ProductFamily, Language, PlatformsSupported, RepositoryType, OSType, RepoFlag) values('EPOAGENT3000', 'ePO Agent', '', 'Current\\EPOAGENT3000\\Install\\0409','EPOAGENT3000\\Product.cfg', '{1EA9745B-A14F-4B91-82AB-3770DE39C62D}', '3.5.0', 'EPO','0409', 'WNTS|WNTW|WIN95|WIN98|WINME|WXPW|WXPS|WXPHE|W2KS|W2KW', 'Products', 'Windows','111')");
        DatabaseUtil.executeUpdate(connection, "insert into [Software] (ProductCode, SoftwareName, PackageName,PackDir, ProductCfgPath, InstallGUID, ProductVersion, ProductFamily, Language, PlatformsSupported, RepositoryType, OSType, RepoFlag) values('EPOAGENT3000', 'ePO Agent', '', 'Current\\EPOAGENT3000\\Install\\0409','EPOAGENT3000\\Product.cfg', '{1EA9745B-A14F-4B91-82AC-3770DE39C62D}', '3.5.0', 'EPO','0409', 'WNTS|WNTW|WIN95|WIN98|WINME|WXPW|WXPS|WXPHE|W2KS|W2KW', 'Products', 'Linux','111')");
        DatabaseUtil.executeUpdate(connection, "insert into [Software] (ProductCode, SoftwareName, PackageName,PackDir, ProductCfgPath, InstallGUID, ProductVersion, ProductFamily, Language, PlatformsSupported, RepositoryType, OSType, RepoFlag) values('SNOWCAP_1000', 'Snowcap Sensor', '', '','SNOWCAP_1000\\Product.cfg', '{86EBA7D0-02CB-490F-8F7E-79FA95798A8F}', '1.0.0', 'SECURE','0409', 'WNTW:4:0:6|WNTS|W2KW|W2KS|W2KAS|W2KDC|WXPW|WXPS|WXPHE', 'Products', 'Windows','35')");
        connection.commit();
    }

    protected void addEpoSubnet(String string, String string2) throws SQLException {
        string = string == null ? "null" : "'" + string + "'";
        string2 = string2 == null ? "null" : "'" + string2 + "'";
        DatabaseUtil.executeUpdate(this.m_epoDb, "insert into ComputerProperties (ParentID, SubnetAddress, SubnetMask) values (5353, " + string + ", " + string2 + ")");
        this.m_epoDb.commit();
    }
}

