/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.common.ui.tables;

import com.mcafee.epo.common.ui.tables.HtmlTable;
import com.mcafee.epo.common.ui.tables.HtmlTableCell;
import com.mcafee.epo.common.ui.tables.InvalidTableException;
import java.util.ArrayList;

public class HtmlTableRow {
    public static final int ROW_TYPE_MIN = 0;
    public static final int ROW_TYPE_DEFAULT = 0;
    public static final int ROW_TYPE_ROGUE = 1;
    public static final int ROW_TYPE_EXCEPTION = 2;
    public static final int ROW_TYPE_DEAD = 3;
    public static final int ROW_TYPE_MANAGED = 4;
    public static final int ROW_TYPE_HEAD = 5;
    public static final int ROW_TYPE_SUBNET = 6;
    public static final int ROW_TYPE_DEPLOY = 7;
    public static final int ROW_TYPE_ACTIVE = 8;
    public static final int ROW_TYPE_MAX = 8;
    protected ArrayList m_cells = new ArrayList();
    protected int m_rowType = 4;
    protected HtmlTable m_parent = null;
    protected String m_valign = null;
    protected String m_checkboxId = null;
    protected String m_checkboxValue = null;
    protected boolean m_checkboxChecked = false;
    protected boolean m_checkboxDisabled = false;

    public HtmlTableCell addCell() {
        this.m_cells.add(new HtmlTableCell());
        ((HtmlTableCell)this.m_cells.get(this.m_cells.size() - 1)).setParent(this);
        return (HtmlTableCell)this.m_cells.get(this.m_cells.size() - 1);
    }

    public HtmlTableCell addCell(String string) {
        HtmlTableCell htmlTableCell = this.addCell();
        htmlTableCell.setInnerHtml(string);
        return htmlTableCell;
    }

    public void getHtml(StringBuffer stringBuffer, int n) throws InvalidTableException {
        stringBuffer.append("    <tr");
        switch (this.m_rowType) {
            case 0: {
                stringBuffer.append(" class='").append("clsBackground").append("'");
                break;
            }
            case 1: {
                stringBuffer.append(" class='").append("TaskTableRowRogue").append("'");
                break;
            }
            case 2: {
                stringBuffer.append(" class='").append("TaskTableRowException").append("'");
                break;
            }
            case 3: {
                stringBuffer.append(" class='").append("TaskTableRowDead").append("'");
                break;
            }
            case 4: {
                stringBuffer.append(" class='").append("TaskTableRowManaged").append("'");
                break;
            }
            case 6: {
                stringBuffer.append(" class='").append("TaskTableRowSubnet").append("'");
                break;
            }
            case 7: {
                stringBuffer.append(" class='").append("TaskTableRowDeploy").append("'");
                break;
            }
            case 8: {
                stringBuffer.append(" class='").append("TaskTableRowActive").append("'");
                break;
            }
            default: {
                throw new InvalidTableException("Attempted to use invalid rowType.");
            }
        }
        if (this.m_parent == null) {
            throw new InvalidTableException("Attempted to use HtmlTableRow or HtmlTableHeader with no parent HtmlTable.");
        }
        if (this.m_cells.size() <= 0) {
            throw new InvalidTableException("Attempted to use HtmlTableRow or HtmlTableHeader with no cells.");
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.m_cells.size()) {
            if (((HtmlTableCell)this.m_cells.get(n2)).getOnClick() != null) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl) {
            stringBuffer.append(" style='cursor:pointer;' ").append("onmouseover='colorRowText(event,\"").append("#CC0033").append("\")' onmouseout='colorRowText(event,\"\")'");
        }
        if (this.m_valign != null) {
            stringBuffer.append(" valign='").append(this.m_valign).append("'");
        }
        stringBuffer.append(">\n");
        if (this.m_rowType == 6) {
            HtmlTableCell htmlTableCell = (HtmlTableCell)this.m_cells.get(0);
            htmlTableCell.setColspan(this.m_parent.getHeader().getNumCells());
            htmlTableCell.getHtml(stringBuffer, 4);
        } else if (this.m_parent.is2col()) {
            int n3 = this.m_cells.size() / 2;
            int n4 = 0;
            while (n4 < n3) {
                ((HtmlTableCell)this.m_cells.get(n4)).getHtml(stringBuffer, this.cellType(n4, 0, n3 - 1));
                ++n4;
            }
            if (n == 0) {
                HtmlTableCell htmlTableCell = new HtmlTableCell();
                htmlTableCell.setParent(this);
                htmlTableCell.setWidth("10px");
                htmlTableCell.setRowspan(this.m_parent.getNumRows());
                htmlTableCell.getHtml(stringBuffer, 5);
            }
            n4 = n3;
            while (n4 < this.m_cells.size()) {
                ((HtmlTableCell)this.m_cells.get(n4)).getHtml(stringBuffer, this.cellType(n4, n3, this.m_cells.size() - 1));
                ++n4;
            }
        } else {
            if (this.m_parent.getHasCheckbox()) {
                HtmlTableCell htmlTableCell = new HtmlTableCell();
                htmlTableCell.setParent(this);
                if (this.m_checkboxId != null) {
                    StringBuffer stringBuffer2 = new StringBuffer(1024);
                    stringBuffer2.append("<input type='checkbox' class='clsCheckBox'").append(" id='").append(this.m_checkboxId).append("'").append(" name='").append(this.m_checkboxId).append("'");
                    if (this.m_checkboxValue != null) {
                        stringBuffer2.append(" value='").append(this.m_checkboxValue).append("'");
                    }
                    if (this.m_checkboxChecked) {
                        stringBuffer2.append(" checked ");
                    }
                    if (this.m_checkboxDisabled) {
                        stringBuffer2.append(" disabled ");
                    }
                    stringBuffer2.append("></input>");
                    htmlTableCell.setAlign("center");
                    htmlTableCell.setInnerHtml(stringBuffer2.toString());
                    if (!this.m_checkboxDisabled) {
                        htmlTableCell.setOnClick("clickCheckboxCell(event)");
                    }
                } else {
                    htmlTableCell.setInnerHtml("&nbsp;");
                }
                htmlTableCell.getHtml(stringBuffer, 1);
            }
            int n5 = 0;
            while (n5 < this.m_cells.size()) {
                ((HtmlTableCell)this.m_cells.get(n5)).getHtml(stringBuffer, this.cellType(n5, 0, this.m_cells.size() - 1));
                ++n5;
            }
        }
        stringBuffer.append("    </tr>\n");
    }

    protected int cellType(int n, int n2, int n3) {
        if (this.m_cells.size() == 1) {
            if (this.m_parent.getHasCheckbox()) {
                return 3;
            }
            return 4;
        }
        if (n == n2) {
            if (this.m_parent.getHasCheckbox()) {
                return 2;
            }
            return 1;
        }
        if (n == n3) {
            return 3;
        }
        return 2;
    }

    public int getNumCells() throws InvalidTableException {
        if (this.m_parent == null) {
            throw new InvalidTableException("Attempted to use HtmlTableRow or HtmlTableHeader with no parent HtmlTable.");
        }
        if (this.m_parent.getHasCheckbox()) {
            return this.m_cells.size() + 1;
        }
        return this.m_cells.size();
    }

    public int getRowType() {
        return this.m_rowType;
    }

    public void setRowType(int n) throws InvalidTableException {
        if (n < 0 || n > 8) {
            throw new InvalidTableException("Attempted to set invalid rowType.");
        }
        this.m_rowType = n;
    }

    public HtmlTable getParent() {
        return this.m_parent;
    }

    public void setParent(HtmlTable htmlTable) {
        this.m_parent = htmlTable;
    }

    public String getCheckboxId() {
        return this.m_checkboxId;
    }

    public void setCheckboxId(String string) {
        this.m_checkboxId = string;
    }

    public String getValign() {
        return this.m_valign;
    }

    public void setValign(String string) {
        this.m_valign = string;
    }

    public String getCheckboxValue() {
        return this.m_checkboxValue;
    }

    public void setCheckboxValue(String string) {
        this.m_checkboxValue = string;
    }

    public boolean getCheckboxChecked() {
        return this.m_checkboxChecked;
    }

    public void setCheckboxChecked(boolean bl) {
        this.m_checkboxChecked = bl;
    }

    public boolean getCheckboxDisabled() {
        return this.m_checkboxDisabled;
    }

    public void setCheckboxDisabled(boolean bl) {
        this.m_checkboxDisabled = bl;
    }
}

