/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.common.ui.util;

import com.mcafee.epo.common.ui.tables.InvalidTableException;
import com.mcafee.epo.core.ui.InvalidParameterException;
import com.mcafee.epo.core.util.resource.Resource;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class PaginationMgr
implements Serializable {
    private static final Logger m_log;
    public static final int ITEMS_PER_PAGE_DEFAULT = 15;
    public static final String PARAM_TARGET_PAGE = "targetPage";
    private int m_index = 1;
    private int m_listCount = 0;
    private int m_itemsPerPage = 15;
    private boolean m_showCheckboxes = false;
    private int m_firstIndex = 0;
    private int m_prevIndex = 0;
    private int m_nextIndex = 0;
    private int m_lastIndex = 0;
    private int m_currentPage = 0;
    private int m_pageCount = 0;
    static /* synthetic */ Class class$com$mcafee$epo$common$ui$util$PaginationMgr;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PaginationMgr() {
    }

    public PaginationMgr(int n, boolean bl) throws InvalidParameterException {
        if (n < 1) {
            throw new InvalidParameterException("Attempted to create PaginationMgr with Items per Page < 1");
        }
        this.m_itemsPerPage = n;
        this.m_showCheckboxes = bl;
    }

    public void computePagination() {
        this.updatePageCountAndIndex();
        if (this.m_itemsPerPage != 0) {
            this.m_currentPage = (this.m_index + this.m_itemsPerPage - 1) / this.m_itemsPerPage;
            m_log.debug((Object)("Setting current page to:" + this.m_currentPage));
            if (this.m_currentPage > 1 && this.m_currentPage <= this.m_pageCount) {
                this.m_prevIndex = (this.m_currentPage - 2) * this.m_itemsPerPage + 1;
                this.m_firstIndex = 1;
            } else {
                this.m_prevIndex = 0;
                this.m_firstIndex = 0;
            }
            if (this.m_currentPage >= 1 && this.m_currentPage < this.m_pageCount) {
                this.m_nextIndex = this.m_currentPage * this.m_itemsPerPage + 1;
                this.m_lastIndex = (this.m_pageCount - 1) * this.m_itemsPerPage + 1;
            } else {
                this.m_nextIndex = 0;
                this.m_lastIndex = 0;
            }
        } else {
            m_log.debug((Object)"ItemsPerPage is zero.  Divide by zero averted.");
        }
    }

    public String getHtml(String string) throws InvalidTableException {
        this.computePagination();
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<table id='machineList' cellSpacing=0 cellPadding=0 border=0 class='clsLabel' width='100%'><tr>\n");
        if (this.m_showCheckboxes) {
            stringBuffer.append("<td><a href='javascript:setAllCheckboxes(true)' ").append("style='font-size:9px; font-weight:normal'>").append(Resource.getString("paginationmgr_check_all", string)).append("</a> ").append("<img src='images/px_trans.gif' height=1 width=3 border=0></img> ").append("<a href='javascript:setAllCheckboxes(false)' ").append("style='font-size:9px; font-weight:normal'>").append(Resource.getString("paginationmgr_uncheck_all", string)).append("</a></td>");
        }
        stringBuffer.append("<td align='right'>");
        String string2 = this.m_listCount == 1 ? Resource.getString("paginationmgr_item", string) : Resource.getString("paginationmgr_items");
        String string3 = this.m_pageCount == 1 ? Resource.getString("paginationmgr_page", string) : Resource.getString("paginationmgr_pages", string);
        stringBuffer.append(Resource.formatString("paginationmgr_template_info", new Object[]{Integer.toString(this.m_listCount), string2, Integer.toString(this.m_pageCount), string3}, string));
        if (this.m_pageCount > 1) {
            this.addPagText(stringBuffer, this.m_itemsPerPage, this.m_pageCount, this.m_currentPage);
            this.addPagButton(stringBuffer, "FirstPage", Resource.getString("paginationmgr_first_page", string), this.m_firstIndex);
            this.addPagButton(stringBuffer, "PreviousPage", Resource.getString("paginationmgr_prev_page", string), this.m_prevIndex);
            this.addPagButton(stringBuffer, "NextPage", Resource.getString("paginationmgr_next_page", string), this.m_nextIndex);
            this.addPagButton(stringBuffer, "LastPage", Resource.getString("paginationmgr_last_page", string), this.m_lastIndex);
        } else {
            stringBuffer.append("<img src='images/px_trans.gif' height=17 width=1 border=0 align=middle></img>\n");
        }
        stringBuffer.append("</td></tr></table>");
        return stringBuffer.toString();
    }

    public int updateIndex(int n) {
        if (n > this.m_currentPage * this.m_itemsPerPage) {
            this.m_currentPage = n / this.m_itemsPerPage + 1;
            this.m_index = (this.m_currentPage - 1) * this.m_itemsPerPage + 1;
        }
        if (n > 0 && n <= (this.m_currentPage - 1) * this.m_itemsPerPage) {
            this.m_currentPage = n / this.m_itemsPerPage + 1;
            this.m_index = this.m_currentPage > 1 ? (this.m_currentPage - 1) * this.m_itemsPerPage + 1 : 1;
        }
        this.updatePageCountAndIndex();
        return this.m_index;
    }

    private void updatePageCountAndIndex() {
        if (this.m_itemsPerPage != 0) {
            this.m_pageCount = (this.m_listCount + this.m_itemsPerPage - 1) / this.m_itemsPerPage;
            m_log.debug((Object)("Page count is:" + this.m_pageCount));
            if (this.m_pageCount < this.m_currentPage) {
                int n = this.m_pageCount - 1;
                m_log.debug((Object)("Past end of list, resetting previous page is:" + n));
                this.m_index = n > 1 ? n * this.m_itemsPerPage + 1 : 1;
                m_log.debug((Object)("Past end of list, resetting index to:" + this.m_index));
            }
            if (this.m_pageCount < 1) {
                m_log.debug((Object)("List is empty, resetting index to:" + this.m_index));
                this.m_index = 0;
            }
            if (this.m_pageCount > 0 && this.m_index == 0) {
                m_log.debug((Object)("List is no longer empty, resetting index to:" + this.m_index));
                this.m_index = 1;
            }
        } else {
            m_log.debug((Object)"ItemsPerpage is set to zero, divide by zero averted.");
        }
    }

    private void addPagText(StringBuffer stringBuffer, int n, int n2, int n3) {
        stringBuffer.append(" ").append(Resource.getString("paginationmgr_go_to_page")).append(" <input type=text onKeyDown='if(event.keyCode==13){gotoPage(\"").append(PARAM_TARGET_PAGE).append("\", ").append(n).append(", ").append(n2).append(", ").append(n3).append(");}' value='").append(n3).append("' onKeyPress='validatePosInt(event);' size=8 class='clsInputText' ").append("onKeyUp='blankInvalidPosNum(event);' onclick='select()' ").append("style='font-size:10px; line-height:10px; width:30px; height:15px' name='").append(PARAM_TARGET_PAGE).append("' id='").append(PARAM_TARGET_PAGE).append("'>").append("</input> ");
    }

    private void addPagButton(StringBuffer stringBuffer, String string, String string2, int n) {
        stringBuffer.append("<img src='images/px_trans.gif' height=1 width=1 border=0></img>\n");
        stringBuffer.append("<img height=17 width=19 align=middle ").append("alt='").append(string2).append("' ").append("title='").append(string2).append("' ");
        if (n > 0) {
            stringBuffer.append("src='images/").append(string).append(".gif' ").append("onclick='javascript:displayMore(").append(n).append(")' ").append("style='cursor:pointer'");
        } else {
            stringBuffer.append("src='images/").append(string).append("Disabled.gif' ");
        }
        stringBuffer.append("></img>\n");
    }

    public int getIndex() {
        this.updatePageCountAndIndex();
        return this.m_index;
    }

    public void setIndex(int n) {
        this.m_index = n;
    }

    public int getItemsPerPage() {
        return this.m_itemsPerPage;
    }

    public void setItemsPerPage(int n) {
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        this.m_itemsPerPage = n;
    }

    public boolean getShowCheckboxes() {
        return this.m_showCheckboxes;
    }

    public void setShowCheckboxes(boolean bl) {
        this.m_showCheckboxes = bl;
    }

    public int getListCount() {
        return this.m_listCount;
    }

    public void setListCount(int n) throws InvalidParameterException {
        if (n < 0) {
            throw new InvalidParameterException("List count set to " + n);
        }
        this.m_listCount = n;
        m_log.debug((Object)("Setting list count to:" + this.m_listCount));
    }

    public int getFirstIndex() {
        return this.m_firstIndex;
    }

    public int getPrevIndex() {
        return this.m_prevIndex;
    }

    public int getNextIndex() {
        return this.m_nextIndex;
    }

    public int getLastIndex() {
        return this.m_lastIndex;
    }

    public int getCurrentPage() {
        return this.m_currentPage;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$mcafee$epo$common$ui$util$PaginationMgr == null ? (class$com$mcafee$epo$common$ui$util$PaginationMgr = PaginationMgr.class$("com.mcafee.epo.common.ui.util.PaginationMgr")) : class$com$mcafee$epo$common$ui$util$PaginationMgr).desiredAssertionStatus();
        m_log = Logger.getLogger((Class)(class$com$mcafee$epo$common$ui$util$PaginationMgr == null ? (class$com$mcafee$epo$common$ui$util$PaginationMgr = PaginationMgr.class$("com.mcafee.epo.common.ui.util.PaginationMgr")) : class$com$mcafee$epo$common$ui$util$PaginationMgr));
    }
}

