/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.common.ui.util;

import com.mcafee.epo.common.ui.util.PaginationMgr;
import com.mcafee.epo.core.ui.InvalidParameterException;
import javax.servlet.http.HttpServletRequest;

public class PaginationState {
    public static final int ORDER_MIN = 1;
    public static final int ORDER_ASCENDING = 1;
    public static final int ORDER_DESCENDING = 2;
    public static final int ORDER_MAX = 2;
    public static final int STATUS_MIN = 1;
    public static final int STATUS_ANY = 1;
    public static final int STATUS_FILTER = 2;
    public static final int STATUS_ROGUE = 3;
    public static final int STATUS_EXCEPTION = 4;
    public static final int STATUS_MANAGED = 5;
    public static final int STATUS_INACTIVE = 6;
    public static final int STATUS_ALLOWED = 7;
    public static final int STATUS_QUARANTINED = 8;
    public static final int STATUS_DROPPED = 9;
    public static final int STATUS_MAX = 9;
    public static final int NETWORK_MIN = 1;
    public static final int NETWORK_ALL = 1;
    public static final int NETWORK_SINGLE = 2;
    public static final int NETWORK_MAX = 2;
    private int m_statusFlags = 1;
    private int m_networkFlags = 1;
    private Integer m_networkId = null;
    private String m_networkAddress = null;
    private int m_sortOrder = 1;
    private int m_sortCol = 1;
    private String m_searchSexpStr = null;
    private PaginationMgr m_pagMgr = null;

    private PaginationState() {
    }

    public PaginationState(int n, int n2, int n3, HttpServletRequest httpServletRequest) throws InvalidParameterException, Exception {
        if (n3 < 1) {
            throw new InvalidParameterException("Attempted to create PaginationMgr with Items per Page < 1");
        }
        this.m_pagMgr = new PaginationMgr(n3, true);
        this.setSortCol(n);
        this.setSortOrder(n2);
        if (httpServletRequest != null) {
            this.setRequestAttributes(httpServletRequest);
        }
    }

    public void setRequestAttributes(HttpServletRequest httpServletRequest) throws Exception {
        String string = httpServletRequest.getParameter("index");
        String string2 = httpServletRequest.getParameter("statusFlags");
        String string3 = httpServletRequest.getParameter("networkFlags");
        String string4 = httpServletRequest.getParameter("subnetId");
        String string5 = httpServletRequest.getParameter("NetworkAddress");
        String string6 = httpServletRequest.getParameter("sortColumn");
        if (string != null && string.length() > 0) {
            this.m_pagMgr.setIndex(Integer.parseInt(string));
        }
        if (string2 != null && string2.length() > 0) {
            this.setStatusFlags(Integer.parseInt(string2));
        }
        if (string4 != null && string4.length() > 0) {
            this.setNetworkId(new Integer(string4));
        }
        if (string5 != null && string5.length() > 0) {
            this.setNetworkAddress(string5);
        }
        if (string3 != null && string3.length() > 0) {
            this.setNetworkFlags(Integer.parseInt(string3));
        }
        if (string6 != null && string6.length() > 0) {
            int n = Integer.parseInt(string6);
            if (n <= 0) {
                throw new InvalidParameterException("An attempt was made to set an invalid sort column, value: " + n);
            }
            if (n == this.getSortCol()) {
                this.switchSortOrder();
            } else {
                this.setSortCol(n);
            }
        }
    }

    private void switchSortOrder() throws InvalidParameterException {
        if (this.getSortOrder() == 1) {
            this.setSortOrder(2);
        } else {
            this.setSortOrder(1);
        }
    }

    public String getHtml(String string) throws Exception {
        return this.m_pagMgr.getHtml(string);
    }

    public PaginationMgr getPagMgr() {
        return this.m_pagMgr;
    }

    public int getSortCol() {
        return this.m_sortCol;
    }

    private void setSortCol(int n) {
        this.m_sortCol = n;
    }

    public String getSearchSexpStr() {
        return this.m_searchSexpStr;
    }

    public void setSearchSexpStr(String string) {
        this.m_searchSexpStr = string;
    }

    private void setStatusFlags(int n) throws InvalidParameterException {
        if (n < 1 || n > 9) {
            throw new InvalidParameterException("Attempting to set illegal machine status flag. Status Flag is: " + n);
        }
        this.m_statusFlags = n;
    }

    public int getStatusFlags() {
        return this.m_statusFlags;
    }

    private void setNetworkFlags(int n) throws InvalidParameterException {
        if (n < 1 || n > 2) {
            throw new InvalidParameterException("Attempting to set illegal network status flag.");
        }
        this.m_networkFlags = n;
        if (this.m_networkFlags == 1) {
            this.m_networkId = null;
            this.m_networkAddress = null;
        }
    }

    public int getNetworkFlags() {
        return this.m_networkFlags;
    }

    private void setNetworkAddress(String string) {
        this.m_networkAddress = string;
    }

    public String getNetworkAddress() {
        return this.m_networkAddress;
    }

    private void setNetworkId(Integer n) {
        this.m_networkId = n;
    }

    public Integer getNetworkId() throws Exception {
        if (this.m_networkId == null && this.m_networkFlags == 2) {
            throw new Exception("No networkId specified, but network flag set to 'single'.");
        }
        return this.m_networkId;
    }

    private void setSortOrder(int n) throws InvalidParameterException {
        if (n < 1 || n > 2) {
            throw new InvalidParameterException("Attempting to set illegal machine ordering flag.");
        }
        this.m_sortOrder = n;
    }

    public int getSortOrder() {
        return this.m_sortOrder;
    }
}

