/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.db;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class EpoPassword {
    public static final int KEY_MIN = 1;
    public static final int KEY_PRE_35 = 1;
    public static final int KEY_35_SERVERINI = 2;
    public static final int KEY_35_AGENT_INSTALL = 3;
    public static final int KEY_MAX = 3;
    public static final String TEST_PASSWORD = "wWwxWcA4exVnY6QNOsVexH9psAU8z0HbZ2OkDTrFXsR/abAFPM9B3Q==";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$mcafee$epo$core$db$EpoPassword;

    public static String decryptPassphrase(String string, int n) throws Exception {
        boolean bl = n != 1;
        boolean bl2 = n == 1;
        byte[] byArray = EpoPassword.base64ToBytes(string);
        if (bl2) {
            EpoPassword.doEpoXor(byArray);
        }
        if (!$assertionsDisabled && byArray.length < 8 && bl) {
            throw new AssertionError();
        }
        byte[] byArray2 = EpoPassword.decrypt3DES(EpoPassword.getEpoKey(n), byArray, bl);
        byArray2 = EpoPassword.trimZeros(byArray2);
        String string2 = new String(byArray2, "UTF8");
        return string2;
    }

    public static String decryptPassphrase(String string) throws Exception {
        return EpoPassword.decryptPassphrase(string, 1);
    }

    public static String encryptPassphrase(String string, int n) throws Exception {
        boolean bl = n != 1;
        boolean bl2 = n == 1;
        byte[] byArray = string.getBytes("UTF8");
        byArray = EpoPassword.addZeros(byArray);
        byte[] byArray2 = EpoPassword.encrypt3DES(EpoPassword.getEpoKey(n), byArray, bl);
        if (bl2) {
            EpoPassword.doEpoXor(byArray2);
        }
        String string2 = EpoPassword.bytesToBase64(byArray2);
        return string2;
    }

    public static String encryptPassphrase(String string) throws Exception {
        return EpoPassword.encryptPassphrase(string, 1);
    }

    public static final byte[] hashPassphrase(String string, String string2) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA1").digest((string + "SS" + string2).getBytes("UTF8"));
    }

    public static final String hashAndBase64Passphrase(String string, String string2) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return EpoPassword.bytesToBase64(EpoPassword.hashPassphrase(string, string2));
    }

    public static final String answerEpoServerChallenge(String string, String string2, String string3, boolean bl) throws Exception {
        byte[] byArray = null;
        byArray = bl ? EpoPassword.hashPassphrase(string2, string3) : EpoPassword.base64ToBytes(string3);
        byte[] byArray2 = EpoPassword.padTo24(byArray);
        byte[] byArray3 = EpoPassword.roundToEightByteMultiple(string.getBytes("UTF8"));
        byte[] byArray4 = EpoPassword.encrypt3DES(byArray2, byArray3, true);
        return EpoPassword.bytesToBase64(byArray4);
    }

    public static final byte[] decryptChallengeResponse(String string, String string2, boolean bl, String string3) throws Exception {
        byte[] byArray = null;
        byArray = bl ? EpoPassword.hashPassphrase(string, string2) : EpoPassword.base64ToBytes(string2);
        byte[] byArray2 = EpoPassword.padTo24(byArray);
        byte[] byArray3 = EpoPassword.base64ToBytes(string3);
        return EpoPassword.trimZeros(EpoPassword.decrypt3DES(byArray2, byArray3, true));
    }

    private static byte[] getEpoKey(int n) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (!($assertionsDisabled || n >= 1 && n <= 3)) {
            throw new AssertionError();
        }
        byte[] byArray = null;
        switch (n) {
            case 2: {
                byArray = new byte[]{31, 17, 51, 113, 17, -15, 17, -127, -103, 17, -123, 17, 120, 35, 16, -128};
                break;
            }
            case 3: {
                byArray = new byte[]{-3, 17, 99, 113, -40, -1, -47, -127, -18, 17, -123, -113, 120, -45, 16, -24};
                break;
            }
            default: {
                byArray = "<!@#$%^>".getBytes("UTF8");
            }
        }
        byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
        return EpoPassword.padTo24(byArray2);
    }

    private static final byte[] padTo24(byte[] byArray) throws NoSuchAlgorithmException {
        byte[] byArray2 = new byte[24];
        if (!$assertionsDisabled && byArray.length > byArray2.length) {
            throw new AssertionError();
        }
        Arrays.fill(byArray2, (byte)0);
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static byte[] trimZeros(byte[] byArray) {
        int n = 0;
        n = 0;
        while (n < byArray.length) {
            if (byArray[n] == 0) break;
            ++n;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static final byte[] addZeros(byte[] byArray) {
        byte[] byArray2 = new byte[40];
        Arrays.fill(byArray2, (byte)0);
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length > 40 ? 40 : byArray.length);
        return byArray2;
    }

    private static void doEpoXor(byte[] byArray) {
        byte[] byArray2 = new byte[]{18, 21, 15, 16, 17, 28, 26, 6, 10, 31, 27, 24, 23, 22, 5, 25};
        int n = 0;
        while (n < byArray.length - 1) {
            byArray[n] = (byte)(byArray[n] ^ byArray2[n % byArray2.length]);
            ++n;
        }
    }

    public static final byte[] base64ToBytes(String string) throws IOException {
        return new BASE64Decoder().decodeBuffer(string);
    }

    public static final String bytesToBase64(byte[] byArray) {
        String string = new BASE64Encoder().encodeBuffer(byArray);
        string = string.trim();
        return string;
    }

    private static final byte[] roundToEightByteMultiple(byte[] byArray) {
        int n = byArray.length % 8;
        if (n == 0) {
            return byArray;
        }
        int n2 = byArray.length + (8 - n);
        byte[] byArray2 = new byte[n2];
        Arrays.fill(byArray2, (byte)0);
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        if (!$assertionsDisabled && byArray2.length % 8 != 0) {
            throw new AssertionError();
        }
        return byArray2;
    }

    private static final byte[] encrypt3DES(byte[] byArray, byte[] byArray2, boolean bl) throws Exception {
        DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
        SecretKey secretKey = SecretKeyFactory.getInstance("DESede").generateSecret(dESedeKeySpec);
        String string = bl ? "DESede/CBC/NoPadding" : "DESede/ECB/NoPadding";
        Cipher cipher = Cipher.getInstance(string);
        cipher.init(1, secretKey);
        byte[] byArray3 = cipher.doFinal(byArray2);
        if (bl) {
            byte[] byArray4 = cipher.getIV();
            if (!$assertionsDisabled && byArray4.length != 8) {
                throw new AssertionError();
            }
            byte[] byArray5 = new byte[byArray3.length + byArray4.length];
            System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
            System.arraycopy(byArray3, 0, byArray5, byArray4.length, byArray3.length);
            byArray3 = byArray5;
        }
        return byArray3;
    }

    private static final byte[] decrypt3DES(byte[] byArray, byte[] byArray2, boolean bl) throws Exception {
        DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
        SecretKey secretKey = SecretKeyFactory.getInstance("DESede").generateSecret(dESedeKeySpec);
        String string = bl ? "DESede/CBC/NoPadding" : "DESede/ECB/NoPadding";
        Cipher cipher = Cipher.getInstance(string);
        if (bl) {
            cipher.init(2, (Key)secretKey, new IvParameterSpec(byArray2, 0, 8));
        } else {
            cipher.init(2, secretKey);
        }
        byte[] byArray3 = bl ? cipher.doFinal(byArray2, 8, byArray2.length - 8) : cipher.doFinal(byArray2);
        return byArray3;
    }

    private static void printBuffer(String string, byte[] byArray) {
        System.out.println(string + " length=" + byArray.length);
        int n = 0;
        while (n < byArray.length) {
            System.out.println("[" + n + "] 0x" + Integer.toHexString(byArray[n]));
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$mcafee$epo$core$db$EpoPassword == null ? (class$com$mcafee$epo$core$db$EpoPassword = EpoPassword.class$("com.mcafee.epo.core.db.EpoPassword")) : class$com$mcafee$epo$core$db$EpoPassword).desiredAssertionStatus();
    }
}

