/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.db.base;

import com.mcafee.epo.core.db.base.DatabaseTestSetup;
import java.sql.Connection;
import junit.framework.Assert;
import junit.framework.TestCase;

public class DatabaseObjectTestBase
extends TestCase {
    protected Connection m_con = null;

    public DatabaseObjectTestBase(String string) {
        super(string);
    }

    public void initConnection() throws Exception {
        if (this.m_con == null) {
            this.m_con = DatabaseTestSetup.instance().getConnection();
        }
    }

    public void cleanupConnection() throws Exception {
        if (this.m_con != null) {
            this.m_con.close();
            this.m_con = null;
        }
    }

    public void setUp() throws Exception {
        this.initConnection();
    }

    public void tearDown() throws Exception {
        this.cleanupConnection();
    }

    public static final void assertNotEquals(Object object, Object object2) {
        if (object == null && object2 != null) {
            return;
        }
        if (object != null && object2 == null) {
            return;
        }
        if (object == null && object2 == null) {
            Assert.fail((String)"Expected to be unequal; got two nulls!");
        }
        if (object.equals(object2)) {
            Assert.fail((String)("Expected to be non-equal:" + object + " " + object2));
        }
    }

    public static final void assertNotEquals(int n, int n2) {
        DatabaseObjectTestBase.assertNotEquals(new Integer(n), new Integer(n2));
    }

    public static final void assertNotEquals(long l, long l2) {
        DatabaseObjectTestBase.assertNotEquals(new Long(l), new Long(l2));
    }

    public static final void assertNotEquals(boolean bl, boolean bl2) {
        DatabaseObjectTestBase.assertNotEquals(new Boolean(bl), new Boolean(bl2));
    }
}

