/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.db.base;

import com.mcafee.epo.core.db.base.Database;
import com.mcafee.epo.core.db.base.DbConnectionPool;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;

public class DatabaseTestSetup {
    private static DatabaseTestSetup m_instance;
    private boolean m_setup = false;
    private boolean m_dbTestsEnabled = false;
    private Database m_db;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$mcafee$epo$core$db$base$DatabaseTestSetup;

    public String getValidationQuery() {
        return "select count(*) from LeafNode";
    }

    public String getConfigFilename() {
        return "../../build.properties";
    }

    public String name() {
        return "unit";
    }

    protected void additionalSetup(Properties properties) throws Exception {
    }

    protected void additionalCleanup() {
    }

    public boolean testSchemaVersion(Test test, TestResult testResult) {
        return true;
    }

    public static final synchronized DatabaseTestSetup instance() {
        if (m_instance == null) {
            m_instance = new DatabaseTestSetup();
        }
        return m_instance;
    }

    public static final synchronized void setInstance(DatabaseTestSetup databaseTestSetup) {
        m_instance = databaseTestSetup;
    }

    public void setup() throws Exception {
        Properties properties = this.loadProperties();
        this.m_dbTestsEnabled = DatabaseTestSetup.getString(properties, "db.enabled", "true").equals("true");
        if (this.m_dbTestsEnabled) {
            this.m_db = new Database(properties, this.name(), this.getValidationQuery());
            int n = DbConnectionPool.stringTojdbcDriver(DatabaseTestSetup.getString(properties, "db.jdbc.driver", "jtds"));
            System.out.println("Using database driver:" + DbConnectionPool.jdbcDriverAsString(n));
            this.additionalSetup(properties);
            this.m_setup = true;
        }
    }

    public void cleanup() {
        this.additionalCleanup();
        if (this.m_db != null) {
            this.m_db.close();
            this.m_db = null;
        }
        this.m_setup = false;
    }

    public void ensureAllConnectionsClosed(Test test, TestResult testResult) {
        this.ensureAllConnectionsClosed(this.name(), this.getDatabase(), test, testResult);
    }

    protected void ensureAllConnectionsClosed(String string, Database database, Test test, TestResult testResult) {
        if (database.getPool().getNumBorrowed() != database.getPool().getNumReturned()) {
            testResult.addFailure(test, new AssertionFailedError(string + " db had " + database.getPool().getNumBorrowed() + " borrows and " + database.getPool().getNumReturned() + " returns"));
        }
    }

    public Connection getConnection() throws SQLException {
        if (!$assertionsDisabled && !this.isSetup()) {
            throw new AssertionError();
        }
        return this.m_db.getConnection();
    }

    public Database getDatabase() {
        if (!$assertionsDisabled && !this.isSetup()) {
            throw new AssertionError();
        }
        return this.m_db;
    }

    public boolean areDbTestsEnabled() {
        if (!$assertionsDisabled && !this.isSetup()) {
            throw new AssertionError();
        }
        return this.m_dbTestsEnabled;
    }

    protected String getString(Properties properties, String string) throws Exception {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            throw new Exception("Config file " + this.getConfigFilename() + " missing required key:" + string);
        }
        return string2.trim();
    }

    private static final String getString(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3.trim();
    }

    private Properties loadProperties() throws IOException {
        String string = this.getConfigFilename();
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(string)));
        return properties;
    }

    public boolean isSetup() {
        return this.m_setup;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$mcafee$epo$core$db$base$DatabaseTestSetup == null ? (class$com$mcafee$epo$core$db$base$DatabaseTestSetup = DatabaseTestSetup.class$("com.mcafee.epo.core.db.base.DatabaseTestSetup")) : class$com$mcafee$epo$core$db$base$DatabaseTestSetup).desiredAssertionStatus();
        m_instance = null;
    }
}

