/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.util.event;

import com.mcafee.epo.core.util.event.EventDispatcher;
import com.mcafee.epo.core.util.event.EventListener;
import com.mcafee.epo.core.util.event.EventNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class EventRegistrar {
    private static final HashMap m_eventDispatchers = new HashMap();

    public static final EventDispatcher createEvent() {
        return EventRegistrar.createEvent(false, false, null);
    }

    public static final EventDispatcher createEvent(String string) {
        return EventRegistrar.createEvent(false, false, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final EventDispatcher createEvent(boolean bl, boolean bl2, String string) {
        HashMap hashMap = m_eventDispatchers;
        synchronized (hashMap) {
            if (string != null) {
                EventDispatcherImpl eventDispatcherImpl = (EventDispatcherImpl)m_eventDispatchers.get(string);
                if (eventDispatcherImpl == null) {
                    eventDispatcherImpl = new EventDispatcherImpl(bl, bl2);
                    m_eventDispatchers.put(string, eventDispatcherImpl);
                }
                return eventDispatcherImpl;
            }
            return new EventDispatcherImpl(bl, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final EventDispatcher openEvent(String string) throws EventNotFoundException {
        HashMap hashMap = m_eventDispatchers;
        synchronized (hashMap) {
            EventDispatcherImpl eventDispatcherImpl = (EventDispatcherImpl)m_eventDispatchers.get(string);
            if (eventDispatcherImpl == null) {
                throw new EventNotFoundException(string);
            }
            return eventDispatcherImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEventDispatcher(String string) throws EventNotFoundException {
        HashMap hashMap = m_eventDispatchers;
        synchronized (hashMap) {
            EventDispatcherImpl eventDispatcherImpl = (EventDispatcherImpl)m_eventDispatchers.remove(string);
            if (eventDispatcherImpl == null) {
                throw new EventNotFoundException(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearEventDispatcher() {
        HashMap hashMap = m_eventDispatchers;
        synchronized (hashMap) {
            m_eventDispatchers.clear();
        }
    }

    private static class EventDispatcherImpl
    implements EventDispatcher {
        private ArrayList m_listeners = new ArrayList();
        boolean m_signaled = false;
        boolean m_manual = false;

        public EventDispatcherImpl(boolean bl, boolean bl2) {
            this.m_manual = bl;
            this.m_signaled = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerEventListener(EventListener eventListener) {
            EventDispatcherImpl eventDispatcherImpl = this;
            synchronized (eventDispatcherImpl) {
                this.m_listeners.add(eventListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEventListener(EventListener eventListener) {
            EventDispatcherImpl eventDispatcherImpl = this;
            synchronized (eventDispatcherImpl) {
                this.m_listeners.remove(eventListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void triggerEvent() {
            EventDispatcherImpl eventDispatcherImpl = this;
            synchronized (eventDispatcherImpl) {
                if (!this.m_signaled) {
                    this.m_signaled = true;
                    Iterator iterator = this.m_listeners.iterator();
                    while (iterator.hasNext()) {
                        EventListener eventListener = (EventListener)iterator.next();
                        eventListener.eventTriggered();
                    }
                    if (!this.m_manual) {
                        this.notifyAll();
                        this.m_signaled = false;
                    } else {
                        this.notify();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetEvent() {
            EventDispatcherImpl eventDispatcherImpl = this;
            synchronized (eventDispatcherImpl) {
                this.m_signaled = false;
            }
        }
    }
}

