/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.util.resource;

import com.mcafee.epo.core.util.LocaleName;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class EpoBundle {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$core$util$resource$EpoBundle == null ? (class$com$mcafee$epo$core$util$resource$EpoBundle = EpoBundle.class$("com.mcafee.epo.core.util.resource.EpoBundle")) : class$com$mcafee$epo$core$util$resource$EpoBundle));
    private Locale m_defaultLocale = Locale.getDefault();
    private HashMap m_bundles = new HashMap();
    private ClassLoader m_loader = this.getClass().getClassLoader();
    static /* synthetic */ Class class$com$mcafee$epo$core$util$resource$EpoBundle;

    public void setDefaultLocale(String string) {
        this.m_defaultLocale = new Locale(string);
    }

    public void setDefaultLocale(Locale locale) {
        this.m_defaultLocale = locale;
    }

    public Locale getDefaultLocale() {
        return this.m_defaultLocale;
    }

    public EpoBundle(String string) {
        this.init(string);
    }

    public EpoBundle(String string, ClassLoader classLoader) {
        if (classLoader != null) {
            this.m_loader = classLoader;
        }
        this.init(string);
    }

    public EpoBundle(String string, Locale locale, ClassLoader classLoader) {
        if (locale != null) {
            this.m_defaultLocale = locale;
        }
        if (classLoader != null) {
            this.m_loader = classLoader;
        }
        this.init(string);
    }

    private void init(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        m_log.debug((Object)("Creating a new ResourceBase for " + string));
        this.loadBundles(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBundles(String string) {
        Map map = LocaleName.getLanguages();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Locale locale = new Locale(string2);
            HashMap hashMap = this.m_bundles;
            synchronized (hashMap) {
                m_log.debug((Object)("Loading bundle for: " + string + " language: " + string2));
                this.m_bundles.put(string2, ResourceBundle.getBundle(string, locale, this.m_loader));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String string, String string2) {
        try {
            HashMap hashMap = this.m_bundles;
            synchronized (hashMap) {
                ResourceBundle resourceBundle = (ResourceBundle)this.m_bundles.get(string2);
                if (resourceBundle != null) {
                    return resourceBundle.getString(string);
                }
                resourceBundle = (ResourceBundle)this.m_bundles.get("en");
                if (resourceBundle != null) {
                    return resourceBundle.getString(string);
                }
                return string;
            }
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public String getString(String string) {
        return this.getString(string, this.m_defaultLocale.getLanguage());
    }

    public String formatString(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        return this.formatString(string, objectArray, this.m_defaultLocale);
    }

    public String formatString(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string2};
        return this.formatString(string, objectArray, new Locale(string3));
    }

    public String formatString(String string, Object[] objectArray) {
        return this.formatString(string, objectArray, this.m_defaultLocale);
    }

    public String formatString(String string, Object[] objectArray, String string2) {
        return this.formatString(string, objectArray, new Locale(string2));
    }

    private String formatString(String string, Object[] objectArray, Locale locale) {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        String string2 = this.getString(string, locale.getLanguage());
        if (!string2.equals(string)) {
            string2 = string2.replaceAll("'", "''");
            messageFormat.applyPattern(string2);
            return messageFormat.format(objectArray);
        }
        int n = 0;
        while (n < objectArray.length) {
            string2 = string2 + " " + objectArray[n].toString();
            ++n;
        }
        return string2;
    }

    public ResourceBundle getBundle(String string) {
        String string2 = string != null ? string : this.m_defaultLocale.getLanguage();
        ResourceBundle resourceBundle = (ResourceBundle)this.m_bundles.get(string2);
        if (resourceBundle == null) {
            resourceBundle = (ResourceBundle)this.m_bundles.get("en");
        }
        return resourceBundle;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

