/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.util.resource;

import com.mcafee.epo.core.util.resource.EpoBundle;
import com.mcafee.epo.core.util.resource.ResourceHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public abstract class ResourceBase
implements ResourceHandler {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$core$util$resource$ResourceBase == null ? (class$com$mcafee$epo$core$util$resource$ResourceBase = ResourceBase.class$("com.mcafee.epo.core.util.resource.ResourceBase")) : class$com$mcafee$epo$core$util$resource$ResourceBase));
    private final HashMap m_allBundles = new HashMap();
    static /* synthetic */ Class class$com$mcafee$epo$core$util$resource$ResourceBase;

    public abstract ClassLoader getClassLoader();

    public abstract String[] getBundleNames();

    public abstract String getDefaultBundleName();

    public ResourceBase() {
        this.init(null);
    }

    public ResourceBase(String string) {
        this.init(new Locale(string));
    }

    private void init(Locale locale) {
        String[] stringArray = this.getBundleNames();
        int n = 0;
        while (n < stringArray.length) {
            EpoBundle epoBundle = new EpoBundle(stringArray[n], locale, this.getClassLoader());
            if (epoBundle == null) {
                throw new MissingResourceException("Failed to find resource bundle.", stringArray[n], "");
            }
            this.m_allBundles.put(stringArray[n], epoBundle);
            ++n;
        }
    }

    public void setDefaultLocale(String string) {
        m_log.debug((Object)("Setting the default locale to " + string));
        Iterator iterator = this.m_allBundles.values().iterator();
        while (iterator.hasNext()) {
            EpoBundle epoBundle = (EpoBundle)iterator.next();
            epoBundle.setDefaultLocale(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getFromBundle(String string, String string2, String string3) {
        m_log.debug((Object)("Getting key: " + string2 + " from bundle: " + string + " in locale " + string3));
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        HashMap hashMap = this.m_allBundles;
        synchronized (hashMap) {
            EpoBundle epoBundle = (EpoBundle)this.m_allBundles.get(string);
            if (string3 != null) {
                return epoBundle.getString(string2, string3);
            }
            return epoBundle.getString(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String formatFromBundle(String string, String string2, String string3, String string4) {
        m_log.debug((Object)("Getting key: " + string2 + " from bundle: " + string + " in locale " + string4));
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        HashMap hashMap = this.m_allBundles;
        synchronized (hashMap) {
            EpoBundle epoBundle = (EpoBundle)this.m_allBundles.get(string);
            if (string4 != null) {
                return epoBundle.formatString(string2, string3, string4);
            }
            return epoBundle.formatString(string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String formatFromBundle(String string, String string2, Object[] objectArray, String string3) {
        m_log.debug((Object)("Getting key: " + string2 + " from bundle: " + string + " in locale " + string3));
        if (string == null || string2 == null || objectArray == null) {
            throw new NullPointerException();
        }
        HashMap hashMap = this.m_allBundles;
        synchronized (hashMap) {
            EpoBundle epoBundle = (EpoBundle)this.m_allBundles.get(string);
            if (string3 != null) {
                return epoBundle.formatString(string2, objectArray, string3);
            }
            return epoBundle.formatString(string2, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getBundle(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        ResourceBundle resourceBundle = null;
        HashMap hashMap = this.m_allBundles;
        synchronized (hashMap) {
            EpoBundle epoBundle = (EpoBundle)this.m_allBundles.get(string);
            if (epoBundle != null) {
                resourceBundle = epoBundle.getBundle(string2);
            }
        }
        return resourceBundle;
    }

    public EpoBundle getDefaultBundle() {
        return this.getBundle(this.getDefaultBundleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EpoBundle getBundle(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        EpoBundle epoBundle = null;
        HashMap hashMap = this.m_allBundles;
        synchronized (hashMap) {
            epoBundle = (EpoBundle)this.m_allBundles.get(string);
            if (epoBundle == null) {
                throw new MissingResourceException("The requested bundle is not managed by this Resource class.", string, "");
            }
        }
        return epoBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBundles() {
        HashMap hashMap = this.m_allBundles;
        synchronized (hashMap) {
            this.m_allBundles.clear();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

