/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.util.thread;

import com.mcafee.epo.core.util.thread.Stoplight;
import com.mcafee.epo.core.util.thread.TestThread;

public class TestThreadGroup {
    private Thread[] m_threads;
    private Stoplight m_stoplight = new Stoplight();

    public TestThreadGroup(int n, TestThread testThread, String string) throws CloneNotSupportedException {
        this(TestThreadGroup.makeThreadArray(n, testThread), string);
    }

    public TestThreadGroup(TestThread[] testThreadArray, String string) {
        this.m_threads = new Thread[testThreadArray.length];
        int n = 0;
        while (n < this.m_threads.length) {
            String string2 = string + n;
            TestThread testThread = testThreadArray[n];
            testThread.setStoplight(this.m_stoplight);
            this.m_threads[n] = new Thread((Runnable)testThread, string2);
            this.m_threads[n].start();
            ++n;
        }
    }

    public void start() {
        this.m_stoplight.okToStart();
    }

    public void requestStop() {
        this.m_stoplight.requestStop();
    }

    public void join() {
        try {
            int n = 0;
            while (n < this.m_threads.length) {
                this.m_threads[n].join();
                ++n;
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private static TestThread[] makeThreadArray(int n, TestThread testThread) throws CloneNotSupportedException {
        TestThread[] testThreadArray = new TestThread[n];
        int n2 = 0;
        while (n2 < n) {
            testThreadArray[n2] = (TestThread)testThread.clone();
            ++n2;
        }
        return testThreadArray;
    }
}

