/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.common.db;

import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.util.resource.Resource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public abstract class SimpleTable
extends DatabaseObject {
    public static final int COL_ID = 1;
    public static final int COL_NAME = 2;
    public static final int NUM_COLUMNS = 2;
    public static final int NUM_PROPERTIES = 2;
    public final String[] PROPERTY_NAMES = new String[]{this.getTable() + "Id", "Name"};
    private final String UNIQUE_SQL = "select * from " + this.getTable() + " where " + this.getTable() + "Id=?";
    protected long m_id = -1L;
    protected String m_name = null;

    public abstract String getTable();

    public int getNumColumns() {
        return 2;
    }

    public int getNumProperties() {
        return 2;
    }

    public String getPropertyName(int n) {
        return this.PROPERTY_NAMES[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SimpleTable getByName(Connection connection, String string, String string2, Class clazz) throws SQLException {
        SimpleTable simpleTable;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("select * from " + string + " where Name=?");
            preparedStatement.setString(1, string2);
            Vector vector = DatabaseObject.getByQuery(connection, preparedStatement, clazz, 1, 1);
            if (vector.size() == 0) {
                throw new SQLException(Resource.formatString("simpletable_zero_rows", new Object[]{string2, string}));
            }
            if (vector.size() > 1) {
                throw new SQLException(Resource.formatString("db_morethan_one", new Object[]{string2, string}));
            }
            simpleTable = (SimpleTable)vector.firstElement();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            DatabaseUtil.close(preparedStatement);
            throw throwable;
        }
        DatabaseUtil.close(preparedStatement);
        return simpleTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SimpleTable getById(Connection connection, String string, long l, Class clazz) throws SQLException {
        SimpleTable simpleTable;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("select * from " + string + " where " + string + "Id=?");
            preparedStatement.setLong(1, l);
            Vector vector = DatabaseObject.getByQuery(connection, preparedStatement, clazz, 1, 1);
            if (vector.size() == 0) {
                throw new SQLException(Resource.formatString("simpletable_zero_rows", new Object[]{new Long(l), string}));
            }
            if (vector.size() > 1) {
                throw new SQLException(Resource.formatString("db_morethan_one", new Object[]{new Long(l), string}));
            }
            simpleTable = (SimpleTable)vector.firstElement();
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            DatabaseUtil.close(preparedStatement);
            throw throwable;
        }
        DatabaseUtil.close(preparedStatement);
        return simpleTable;
    }

    public String getUniqueQuerySql() {
        return this.UNIQUE_SQL;
    }

    public String getInsertSql() {
        return "insert into " + this.getTable() + " values(?)";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam(preparedStatement, 1, this.getName());
    }

    public String getUpdateSql() {
        return "update " + this.getTable() + " set Name=? where " + this.getTable() + "Id=?";
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
        DatabaseObject.setParam(preparedStatement, 2, this.getId());
    }

    public void setUniqueID(int n) throws SQLException {
        this.setId(n);
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        this.m_id = resultSet.getInt(1);
        this.setName(resultSet.getString(2));
    }

    public long getId() {
        return this.m_id;
    }

    public void setId(long l) {
        this.m_id = l;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }
}

