/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.common.policy.db;

import com.mcafee.epo.common.policy.db.PolicyObject;
import com.mcafee.epo.core.db.EpoUser;
import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.util.resource.Resource;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PolicyType
extends DatabaseObject {
    private static final Logger m_log = Logger.getLogger((String)(class$com$mcafee$epo$common$policy$db$PolicyType == null ? (class$com$mcafee$epo$common$policy$db$PolicyType = PolicyType.class$("com.mcafee.epo.common.policy.db.PolicyType")) : class$com$mcafee$epo$common$policy$db$PolicyType).getName());
    public static final int NUM_COLUMNS = 6;
    public static final int NUM_PROPERTIES = 6;
    public static final int MAX_LEN_NAME = 128;
    public static final int MAX_LEN_URL = 1024;
    private static final int COLUMN_TYPE_ID = 1;
    private static final int COLUMN_TYPE_TEXT_ID = 2;
    private static final int COLUMN_CATEGORY_TEXT_ID = 3;
    private static final int COLUMN_FEATURE_TEXT_ID = 4;
    private static final int COLUMN_SINGLETON = 5;
    private static final int COLUMN_LEGACY = 6;
    public static final String[] PROPERTY_NAMES = new String[]{"", "TypeID", "TypeTextID", "CategoryTextID", "FeatureTextID", "Singleton", "Legacy"};
    private int m_nTypeID = 0;
    private String m_strType = "";
    private String m_strCategory = "";
    private String m_strFeature = "";
    private boolean m_bSingleton = false;
    private boolean m_bLegacy = false;
    private String m_strDisplayFeatureName = "";
    private String m_strDisplayCategoryName = "";
    private String m_strDisplayTypeName = "";
    static /* synthetic */ Class class$com$mcafee$epo$common$policy$db$PolicyType;
    static /* synthetic */ Class class$com$mcafee$epo$common$policy$db$PolicyObject;

    public void setValues(ResultSet resultSet) throws SQLException {
        this.m_nTypeID = resultSet.getInt(PROPERTY_NAMES[1]);
        this.m_strType = resultSet.getString(PROPERTY_NAMES[2]);
        this.m_strCategory = resultSet.getString(PROPERTY_NAMES[3]);
        this.m_strFeature = resultSet.getString(PROPERTY_NAMES[4]);
        this.m_bSingleton = resultSet.getBoolean(PROPERTY_NAMES[5]);
        this.m_bLegacy = resultSet.getBoolean(PROPERTY_NAMES[6]);
    }

    public String getUniqueQuerySql() {
        return "select * from EPOPolicyTypes where TypeID = ?";
    }

    public String getUniqueIdSql() {
        return "select * from EPOPolicyTypes where TypeID = ?";
    }

    public void prepareUniqueQuery(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam(preparedStatement, 1, this.m_nTypeID);
    }

    public String getInsertSql() {
        return "EPOPolicy_AddPolicyType ?,?,?,?,?,?,?";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam(preparedStatement, 2, this.m_strFeature);
        DatabaseObject.setParam(preparedStatement, 3, this.m_strCategory);
        DatabaseObject.setParam(preparedStatement, 4, this.m_strType);
        DatabaseObject.setParam(preparedStatement, 5, this.m_bSingleton);
        DatabaseObject.setParam(preparedStatement, 6, this.m_bLegacy);
    }

    public String getUpdateSql() {
        return "EPOPolicy_UpdatePolicyType ?,?,?,?";
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam(preparedStatement, 2, this.m_nTypeID);
        DatabaseObject.setParam(preparedStatement, 3, this.m_bSingleton);
        DatabaseObject.setParam(preparedStatement, 4, this.m_bLegacy);
    }

    public void setUniqueID(int n) throws SQLException {
        this.m_nTypeID = n;
    }

    public int getNumColumns() {
        return 6;
    }

    public int getNumProperties() {
        return 6;
    }

    public String getPropertyName(int n) {
        return PROPERTY_NAMES[n];
    }

    public int getTypeID() {
        return this.m_nTypeID;
    }

    public String getTypeTextID() {
        return this.m_strType;
    }

    public String getCategoryTextID() {
        return this.m_strCategory;
    }

    public String getFeatureTextID() {
        return this.m_strFeature;
    }

    public boolean getSingleton() {
        return this.m_bSingleton;
    }

    public boolean getLegacy() {
        return this.m_bLegacy;
    }

    public void setTypeID(int n) {
        this.m_nTypeID = n;
    }

    public void setTypeTextID(String string) {
        this.m_strType = string;
    }

    public void setCategoryTextID(String string) {
        this.m_strCategory = string;
    }

    public void setFeatureTextID(String string) {
        this.m_strFeature = string;
    }

    public void setSingleton(boolean bl) {
        this.m_bSingleton = bl;
    }

    public void setLegacy(boolean bl) {
        this.m_bLegacy = bl;
    }

    public String getDisplayName(Connection connection, String string, int n) {
        CallableStatement callableStatement = null;
        try {
            if (this.m_strDisplayTypeName.length() == 0) {
                callableStatement = connection.prepareCall("EPOPolicy_GetLocaleDisplayText ?,?,?,?");
                DatabaseObject.setParam(callableStatement, 1, string, 128);
                DatabaseObject.setParam(callableStatement, 2, this.m_strType, 128);
                DatabaseObject.setParam((PreparedStatement)callableStatement, 3, n);
                callableStatement.registerOutParameter(4, 12);
                callableStatement.execute();
                String string2 = callableStatement.getString(4);
                this.m_strDisplayTypeName = string2.length() > 0 ? string2 : this.m_strType;
            }
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {
            this.m_strDisplayTypeName = this.m_strType;
        }
        return this.m_strDisplayTypeName;
    }

    public String getDisplayFeatureName(Connection connection, String string, int n) {
        CallableStatement callableStatement = null;
        try {
            if (this.m_strDisplayFeatureName.length() == 0) {
                callableStatement = connection.prepareCall("EPOPolicy_GetLocaleDisplayText ?,?,?,?");
                DatabaseObject.setParam(callableStatement, 1, string, 128);
                DatabaseObject.setParam(callableStatement, 2, this.m_strFeature, 128);
                DatabaseObject.setParam((PreparedStatement)callableStatement, 3, n);
                callableStatement.registerOutParameter(4, 12);
                callableStatement.execute();
                String string2 = callableStatement.getString(4);
                this.m_strDisplayFeatureName = string2.length() > 0 ? string2 : this.m_strFeature;
            }
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {
            this.m_strDisplayFeatureName = this.m_strFeature;
        }
        return this.m_strDisplayFeatureName;
    }

    public String getDisplayCategoryName(Connection connection, String string, int n) {
        CallableStatement callableStatement = null;
        try {
            if (this.m_strDisplayFeatureName.length() == 0) {
                callableStatement = connection.prepareCall("EPOPolicy_GetLocaleDisplayText ?,?,?,?");
                DatabaseObject.setParam(callableStatement, 1, string, 128);
                DatabaseObject.setParam(callableStatement, 2, this.m_strCategory, 128);
                DatabaseObject.setParam((PreparedStatement)callableStatement, 3, n);
                callableStatement.registerOutParameter(4, 12);
                callableStatement.execute();
                String string2 = callableStatement.getString(4);
                this.m_strDisplayCategoryName = string2.length() > 0 ? string2 : this.m_strCategory;
            }
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {
            this.m_strDisplayCategoryName = this.m_strCategory;
        }
        return this.m_strDisplayCategoryName;
    }

    public static String getDisplayKeyName(Connection connection, String string, String string2, int n) {
        CallableStatement callableStatement = null;
        String string3 = null;
        try {
            callableStatement = connection.prepareCall("EPOPolicy_GetLocaleDisplayText ?,?,?,?");
            DatabaseObject.setParam(callableStatement, 1, string, 128);
            DatabaseObject.setParam(callableStatement, 2, string2, 128);
            DatabaseObject.setParam((PreparedStatement)callableStatement, 3, n);
            callableStatement.registerOutParameter(4, 12);
            callableStatement.execute();
            String string4 = callableStatement.getString(4);
            string3 = string4.length() > 0 ? string4 : string;
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {
            string3 = string2;
        }
        return string3;
    }

    public void add(Connection connection, boolean bl) throws SQLException {
        throw new SQLException("add requires a userID, please use add(Connection, int)");
    }

    public void update(Connection connection, boolean bl) throws SQLException {
        throw new SQLException("update requires a userID, please use update(Connection, int)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Connection connection, String string, int n) throws SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(this.getInsertSql());
            DatabaseObject.setParam((PreparedStatement)callableStatement, 1, n);
            this.prepareInsert(callableStatement);
            callableStatement.registerOutParameter(7, 4);
            callableStatement.execute();
            this.setTypeID(callableStatement.getInt(7));
            callableStatement = connection.prepareCall("EPOPolicy_AssignTypeToProduct ?,?,?, '', ''");
            DatabaseObject.setParam((PreparedStatement)callableStatement, 1, n);
            DatabaseObject.setParam((PreparedStatement)callableStatement, 2, this.getTypeID());
            if (string == null) {
                DatabaseObject.setParam((PreparedStatement)callableStatement, 3, this.getFeatureTextID());
            } else {
                DatabaseObject.setParam((PreparedStatement)callableStatement, 3, string);
            }
            callableStatement.execute();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DatabaseUtil.close(callableStatement);
            throw throwable;
        }
        DatabaseUtil.close(callableStatement);
    }

    public void add(Connection connection, int n) throws SQLException {
        this.add(connection, null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Connection connection, int n) throws SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(this.getUpdateSql());
            DatabaseObject.setParam((PreparedStatement)callableStatement, 1, n);
            this.prepareUpdate(callableStatement);
            callableStatement.execute();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close(callableStatement);
            throw throwable;
        }
        DatabaseUtil.close(callableStatement);
    }

    public PolicyObject createPolicyObject(Connection connection, String string, int n) throws SQLException {
        DatabaseObject databaseObject;
        if (n > 0 && (databaseObject = EpoUser.getById(connection, n)) != null && ((EpoUser)databaseObject).isGlobalAdmin()) {
            n = 0;
        }
        databaseObject = new PolicyObject();
        ((PolicyObject)databaseObject).setName(string);
        ((PolicyObject)databaseObject).setTypeID(this.m_nTypeID);
        ((PolicyObject)databaseObject).setOwnerID(n);
        ((PolicyObject)databaseObject).setEditFlags(0);
        ((PolicyObject)databaseObject).add(connection, n);
        connection.commit();
        ((PolicyObject)databaseObject).setOwnerName(connection);
        return databaseObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PolicyObject copyPolicyObject(Connection connection, int n, String string, int n2, boolean bl) throws SQLException {
        Statement statement = null;
        PolicyObject policyObject = null;
        try {
            try {
                DatabaseObject databaseObject;
                if (n2 > 0 && (databaseObject = EpoUser.getById(connection, n2)) != null && ((EpoUser)databaseObject).isGlobalAdmin()) {
                    n2 = 0;
                }
                databaseObject = PolicyObject.getById(connection, n);
                statement = connection.prepareCall("EPOPolicy_CopyPolicyObject ?,?,?,?,?,?");
                DatabaseObject.setParam((PreparedStatement)statement, 1, n2);
                DatabaseObject.setParam((PreparedStatement)statement, 2, n);
                DatabaseObject.setParam((PreparedStatement)statement, 3, string, 128);
                DatabaseObject.setParam((PreparedStatement)statement, 4, n2);
                DatabaseObject.setParam((PreparedStatement)statement, 5, bl);
                statement.registerOutParameter(6, 4);
                statement.execute();
                connection.commit();
                policyObject = PolicyObject.getById(connection, statement.getInt(6));
            }
            catch (Exception exception) {
                m_log.debug((Object)("CopyPolicy exception, err=" + exception.toString()));
                Object var10_11 = null;
                if (statement == null) return policyObject;
                statement.close();
                return policyObject;
            }
            Object var10_10 = null;
            if (statement == null) return policyObject;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
        return policyObject;
    }

    public PolicyObject[] getAvailablePolicies(Connection connection) throws SQLException {
        String string = "execute EPOPolicy_GetPolicyByType " + this.m_nTypeID;
        Vector vector = DatabaseObject.getByQuery(connection, string, class$com$mcafee$epo$common$policy$db$PolicyObject == null ? (class$com$mcafee$epo$common$policy$db$PolicyObject = PolicyType.class$("com.mcafee.epo.common.policy.db.PolicyObject")) : class$com$mcafee$epo$common$policy$db$PolicyObject);
        PolicyObject[] policyObjectArray = new PolicyObject[]{};
        policyObjectArray = vector.toArray(policyObjectArray);
        int n = 0;
        while (n < vector.size()) {
            policyObjectArray[n].setOwnerName(connection);
            ++n;
        }
        return policyObjectArray;
    }

    public static final PolicyType getById(Connection connection, int n) throws SQLException {
        PolicyType policyType = (PolicyType)DatabaseObject.getByQuery(connection, "execute EPOPolicy_GetTypeByID " + n, class$com$mcafee$epo$common$policy$db$PolicyType == null ? (class$com$mcafee$epo$common$policy$db$PolicyType = PolicyType.class$("com.mcafee.epo.common.policy.db.PolicyType")) : class$com$mcafee$epo$common$policy$db$PolicyType).get(0);
        return policyType;
    }

    public static final void deleteFromDatabase(Connection connection, int n, int n2) throws SQLException {
        DatabaseUtil.executeUpdate(connection, "execute EPOPOlicy_DeletePolicyType " + n + "," + n2);
    }

    public static final boolean isAccessable(Connection connection, EpoUser epoUser, int n) {
        boolean bl;
        block5: {
            int n2;
            block6: {
                bl = false;
                if (epoUser == null) break block5;
                n2 = (int)epoUser.getAutoId();
                if (!epoUser.isGlobalAccount()) break block6;
                bl = true;
                break block5;
            }
            if (!epoUser.isSiteAccount()) break block5;
            try {
                PreparedStatement preparedStatement = null;
                if (n2 > 0) {
                    preparedStatement = connection.prepareStatement("select TypeID from EPOPolicyTypePermissions where UserID=?");
                    preparedStatement.setInt(1, n2);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        int n3 = resultSet.getInt(1);
                        if (n3 != n) continue;
                        bl = true;
                        break;
                    }
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public static PolicyType getTypeByTextID(Connection connection, String string, String string2, String string3) throws SQLException {
        String string4 = "execute EPOPolicy_GetTypeByTextID '" + string + "','" + string2 + "','" + string3 + "'";
        Vector vector = DatabaseObject.getByQuery(connection, string4, class$com$mcafee$epo$common$policy$db$PolicyType == null ? (class$com$mcafee$epo$common$policy$db$PolicyType = PolicyType.class$("com.mcafee.epo.common.policy.db.PolicyType")) : class$com$mcafee$epo$common$policy$db$PolicyType);
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() > 1) {
            throw new SQLException(Resource.getString("db_morethan_one"));
        }
        return (PolicyType)vector.firstElement();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

