/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.common.ui.tables;

import com.mcafee.epo.common.ui.tables.HtmlTableRow;
import com.mcafee.epo.common.ui.tables.InvalidTableException;
import com.mcafee.epo.core.util.StringUtil;

public class HtmlTableCell {
    public static final int CELL_TYPE_MIN = 1;
    public static final int CELL_TYPE_FIRST = 1;
    public static final int CELL_TYPE_MIDDLE = 2;
    public static final int CELL_TYPE_LAST = 3;
    public static final int CELL_TYPE_ALL = 4;
    public static final int CELL_TYPE_SPACER = 5;
    public static final int CELL_TYPE_MAX = 5;
    protected String m_innerHtml = null;
    protected String m_onClick = null;
    protected String m_align = null;
    protected String m_width = null;
    protected String m_style = null;
    protected String m_id = null;
    protected HtmlTableRow m_parent = null;
    protected int m_colspan = 0;
    protected int m_rowspan = 0;

    public void getHtml(StringBuffer stringBuffer, int n) throws InvalidTableException {
        if (this.m_parent == null) {
            throw new InvalidTableException("Attempted to use HtmlTableCell or HtmlTableHeaderCell with no parent HtmlTableRow.");
        }
        stringBuffer.append("        <td");
        stringBuffer.append(" class='").append(this.getCssClass(n)).append("'");
        if (this.m_onClick != null) {
            stringBuffer.append(" onclick='").append(this.m_onClick).append("'");
        }
        if (this.m_align != null) {
            stringBuffer.append(" style='text-align:").append(this.m_align).append("'");
        }
        if (this.m_width != null) {
            stringBuffer.append(" width='").append(this.m_width).append("'");
        }
        if (this.m_style != null) {
            stringBuffer.append(" style='").append(this.m_style).append("'");
        }
        if (this.m_colspan != 0) {
            stringBuffer.append(" colspan='").append(this.m_colspan).append("'");
        }
        if (this.m_rowspan != 0) {
            stringBuffer.append(" rowspan='").append(this.m_rowspan).append("'");
        }
        if (this.m_id != null) {
            stringBuffer.append(" id='").append(this.m_id).append("'");
        }
        if (this.m_parent.getParent().isEllipsisTruncation() && this.m_innerHtml != null && this.m_innerHtml.length() > 0 && !this.m_innerHtml.startsWith("<") && !this.m_innerHtml.equals("&nbsp;")) {
            stringBuffer.append(" title='").append(StringUtil.safeJavascriptLiteral(this.m_innerHtml)).append("'");
        }
        stringBuffer.append(">");
        if (this.m_innerHtml != null) {
            stringBuffer.append(this.m_innerHtml);
        } else {
            stringBuffer.append("&nbsp;");
        }
        stringBuffer.append("</td>\n");
    }

    protected String getCssClass(int n) throws InvalidTableException {
        String string = "";
        if (this.m_parent.getParent().isEllipsisTruncation()) {
            string = "Ellipsis";
        }
        switch (n) {
            case 1: {
                return "TaskTableText" + string;
            }
            case 2: {
                return "TaskTableText" + string;
            }
            case 3: {
                return "TaskTableTextCapRight" + string;
            }
            case 4: {
                return "TaskTableTextCapRight" + string;
            }
            case 5: {
                return "TaskTableHdCapBoth" + string;
            }
        }
        throw new InvalidTableException("Attempted to set invalid cellType.");
    }

    public String getInnerHtml() {
        return this.m_innerHtml;
    }

    public void setInnerHtml(String string) {
        this.m_innerHtml = string;
    }

    public String getOnClick() {
        return this.m_onClick;
    }

    public void setOnClick(String string) {
        this.m_onClick = string;
    }

    public HtmlTableRow getParent() {
        return this.m_parent;
    }

    public void setParent(HtmlTableRow htmlTableRow) {
        this.m_parent = htmlTableRow;
    }

    public String getAlign() {
        return this.m_align;
    }

    public void setAlign(String string) {
        this.m_align = string;
    }

    public String getWidth() {
        return this.m_width;
    }

    public void setWidth(String string) {
        this.m_width = string;
    }

    public String getStyle() {
        return this.m_style;
    }

    public void setStyle(String string) {
        this.m_style = string;
    }

    public int getColspan() {
        return this.m_colspan;
    }

    public void setColspan(int n) {
        this.m_colspan = n;
    }

    public int getRowspan() {
        return this.m_rowspan;
    }

    public void setRowspan(int n) {
        this.m_rowspan = n;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String string) {
        this.m_id = string;
    }
}

