/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.common.ui.util;

import com.mcafee.epo.common.ui.util.PageState;
import com.mcafee.epo.common.ui.util.PropDisplayInterface;
import com.mcafee.epo.common.ui.util.PropSqlBuilderInterface;
import com.mcafee.epo.common.util.IPFormatException;
import com.mcafee.epo.core.db.EpoUser;
import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.core.util.StringUtil;
import com.mcafee.epo.core.util.resource.Resource;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public abstract class PropDisplayBase
implements PropDisplayInterface,
PropSqlBuilderInterface {
    private static final Logger m_log;
    public static int MAX_LIST_COUNT;
    protected DatabaseObject m_dbo;
    protected EpoUser m_user;
    protected String m_lang = null;
    static /* synthetic */ Class class$com$mcafee$epo$common$ui$util$PropDisplayBase;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PropDisplayBase(EpoUser epoUser) {
        this.m_user = epoUser;
        this.m_lang = epoUser != null ? epoUser.getLanguageId() : "en";
    }

    public abstract void calculateProperties() throws Exception;

    public void setDbo(DatabaseObject databaseObject) {
        this.m_dbo = databaseObject;
    }

    public DatabaseObject getDbo() {
        return this.m_dbo;
    }

    public void setEpoUser(EpoUser epoUser) {
        this.m_user = epoUser;
    }

    public EpoUser getEpoUser() {
        return this.m_user;
    }

    public void setDefaultLanguage(String string) {
        this.m_lang = string;
    }

    public String getDefaultLanguage() {
        return this.m_lang;
    }

    public String getTruncatedProperty(DatabaseObject databaseObject, int n) {
        String string;
        block4: {
            string = "";
            this.setDbo(databaseObject);
            try {
                if (!($assertionsDisabled || n > 0 && n <= this.m_dbo.getNumProperties())) {
                    throw new AssertionError();
                }
                if (this.m_dbo == null) break block4;
                Object object = this.m_dbo.getProperty(n);
                if (object != null) {
                    string = StringUtil.safeHtml(object.toString(), false, 30, "&hellip");
                    break block4;
                }
                string = "";
            }
            catch (Exception exception) {
                m_log.debug((Object)("Failed to get property: " + n), (Throwable)exception);
            }
        }
        return string;
    }

    public String getFullProperty(int n) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, IPFormatException {
        return this.getFullProperty(n, true);
    }

    public String getFullProperty(int n, boolean bl) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, IPFormatException {
        if (!($assertionsDisabled || n > 0 && n <= this.m_dbo.getNumProperties())) {
            throw new AssertionError();
        }
        String string = "";
        if (this.m_dbo != null) {
            Object object = this.m_dbo.getProperty(n);
            if (object == null) {
                object = "";
            }
            string = object.toString();
            if (bl) {
                string = StringUtil.safeHtml(string);
            }
        }
        return string;
    }

    public String getTruncatedProperty(int n) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, IPFormatException {
        return this.getFullProperty(n);
    }

    public String getFullHeader(int n) {
        if (!($assertionsDisabled || n > 0 && n <= this.m_dbo.getNumProperties())) {
            throw new AssertionError();
        }
        String string = "";
        DatabaseObject databaseObject = this.m_dbo;
        try {
            if (databaseObject == null) {
                databaseObject = (DatabaseObject)this.getDBClass().newInstance();
            }
            if (this.isPropertyDisplayable(n)) {
                string = Resource.getString(this.getTableName() + "propdisplay_" + databaseObject.getPropertyName(n), this.m_lang);
            }
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.getString("propdisplay_db_instance_failed"), (Throwable)exception);
        }
        return string;
    }

    public String getTruncatedHeader(int n) {
        return this.getFullHeader(n);
    }

    public int getDefaultSortOrder() {
        return 1;
    }

    public String getRowStyle() {
        return "TaskTableRow";
    }

    public abstract boolean isPropertyDisplayable(int var1);

    protected String getDefaultOrderByClause(int n, int n2) {
        return "order by " + n + (n2 == 1 ? " asc" : " desc");
    }

    public abstract int getDefaultSortCol();

    public String getOrderByClause(PageState pageState) {
        return this.getOrderByClause(pageState.getSortColumn(), pageState.getSortDirection());
    }

    public String getOrderByClause(int n, int n2) {
        return this.getDefaultOrderByClause(n, n2);
    }

    public abstract String getTableName();

    public abstract String getIdColumnName();

    public abstract String getSelectColumns();

    public abstract Class getDBClass();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$mcafee$epo$common$ui$util$PropDisplayBase == null ? (class$com$mcafee$epo$common$ui$util$PropDisplayBase = PropDisplayBase.class$("com.mcafee.epo.common.ui.util.PropDisplayBase")) : class$com$mcafee$epo$common$ui$util$PropDisplayBase).desiredAssertionStatus();
        m_log = Logger.getLogger((Class)(class$com$mcafee$epo$common$ui$util$PropDisplayBase == null ? (class$com$mcafee$epo$common$ui$util$PropDisplayBase = PropDisplayBase.class$("com.mcafee.epo.common.ui.util.PropDisplayBase")) : class$com$mcafee$epo$common$ui$util$PropDisplayBase));
        MAX_LIST_COUNT = 5;
    }
}

