/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core;

import com.mcafee.epo.core.db.base.Database;
import com.mcafee.epo.core.db.base.Queries;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.xml.DOMConfigurator;

public class EpoCore {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$core$EpoCore == null ? (class$com$mcafee$epo$core$EpoCore = EpoCore.class$("com.mcafee.epo.core.EpoCore")) : class$com$mcafee$epo$core$EpoCore));
    public static final String DEFAULT_LOG_FILENAME = "c:/epo.log";
    private static Properties m_config = null;
    private static Database m_db = null;
    private static boolean m_initialized = false;
    private static Exception m_initFailureCause = null;
    static /* synthetic */ Class class$com$mcafee$epo$core$EpoCore;

    public static final Database getEpoDb() {
        return m_db;
    }

    public static final boolean isInitialized() {
        return m_initialized;
    }

    public static final boolean initFailed() {
        return m_initFailureCause != null;
    }

    public static final Exception initFailureCause() {
        return m_initFailureCause;
    }

    public static final synchronized void start() {
        if (!m_initialized) {
            EpoCore.init();
            System.out.println("EpoCore started!");
        }
    }

    public static final synchronized void stop() {
        if (m_initialized) {
            EpoCore.shutdown();
            System.out.println("EpoCore stopped!");
            m_initialized = false;
        }
    }

    private static final void init() {
        m_initFailureCause = null;
        try {
            EpoCore.initLogging();
            EpoCore.loadConfig();
            EpoCore.initDatabase();
            m_initialized = true;
        }
        catch (Exception exception) {
            System.out.println("Atlas core: error during initialization:");
            System.out.println(exception);
            exception.printStackTrace(System.out);
            m_initFailureCause = exception;
        }
    }

    private static final void shutdown() {
        m_config = null;
        m_initFailureCause = null;
        m_initialized = false;
    }

    private static final void initDatabase() throws Exception {
        m_db = new Database(m_config, "epo", Queries.VALIDATE_EPO_DB);
    }

    private static final void loadConfig() throws Exception {
        String string = EpoCore.getCatalinaBaseDir() + "/conf/epo/atlas.properties";
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(string)));
        m_config = properties;
    }

    private static void initLogging() {
        FileAppender fileAppender;
        Object object;
        boolean bl;
        String string = "<empty>";
        try {
            string = EpoCore.getCatalinaBaseDir() + "/conf/epo/log-config.xml";
            DOMConfigurator.configureAndWatch((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger logger = Logger.getRootLogger();
        boolean bl2 = bl = !logger.getAllAppenders().hasMoreElements();
        if (bl) {
            object = new PatternLayout("%d{ISO8601} %-5p %-15c{2} %x - %m%n");
            fileAppender = new FileAppender();
            ConsoleAppender consoleAppender = new ConsoleAppender();
            fileAppender.setName("ToFile");
            fileAppender.setLayout((Layout)object);
            fileAppender.setBufferedIO(false);
            fileAppender.setFile(DEFAULT_LOG_FILENAME);
            fileAppender.setAppend(true);
            fileAppender.activateOptions();
            consoleAppender.setName("ToStdout");
            consoleAppender.setLayout((Layout)object);
            consoleAppender.setTarget("System.out");
            consoleAppender.activateOptions();
            logger.addAppender((Appender)fileAppender);
            logger.addAppender((Appender)consoleAppender);
            logger.setLevel(Level.INFO);
        }
        if (bl) {
            m_log.warn((Object)("Log initialization using " + string + " failed; using default log configuration."));
        }
        object = logger.getAllAppenders();
        while (object.hasMoreElements()) {
            fileAppender = (Appender)object.nextElement();
            if (!(fileAppender instanceof FileAppender)) continue;
            m_log.info((Object)("Writing to log file " + fileAppender.getFile()));
        }
    }

    private static final String getCatalinaBaseDir() throws Exception {
        String string = System.getProperty("catalina.base");
        if (string == null) {
            throw new Exception("Atlas internal error: property catalina.base not set!");
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

