/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.client;

import com.mcafee.epo.core.client.MessageUtil;
import com.mcafee.epo.core.client.SpipePrinter;
import com.mcafee.epo.core.spipe.EpoCrypto;
import com.mcafee.epo.core.spipe.SpipePackage;
import com.mcafee.epo.core.spipe.SpipeXmlParser;
import com.mcafee.epo.core.util.FileUtil;
import java.net.URL;
import java.security.PrivateKey;

public class SpipeClient {
    private URL m_url = null;
    private PrivateKey m_privKey = null;
    private SpipePackage[] m_packages = null;
    private String m_writeDir = null;

    public static void main(String[] stringArray) throws Exception {
        SpipeClient spipeClient = new SpipeClient();
        spipeClient.readArgs(stringArray);
        spipeClient.run();
    }

    private void run() throws Exception {
        int n = 0;
        while (n < this.m_packages.length) {
            System.out.println("Sending package (" + (n + 1) + "/" + this.m_packages.length + ")");
            SpipePackage.BinaryFormat binaryFormat = this.m_packages[n].write(this.m_privKey);
            byte[] byArray = MessageUtil.send(this.m_url, "application/octet-stream", binaryFormat.getBytes(), 0, binaryFormat.getLength());
            SpipePrinter.printPackageContents(new SpipePackage(byArray), this.m_writeDir);
            ++n;
        }
    }

    private static final void showUsageAndExit() {
        System.out.println("Usage: SpipeClient [<options>]");
        System.out.println("  where options are:");
        System.out.println("  -s <server>    server url (required)");
        System.out.println("                   e.g.:http://localhost/spipe/pkg");
        System.out.println("                   e.g.:http://localhost/spipe/echo - for testing");
        System.out.println("  -k <priv-key>  private key file (required)");
        System.out.println("  -f <bin-file>  binary spipe package file to send");
        System.out.println("  -x <xml-file>  xml file describing spipe pkgs to send");
        System.out.println("                 (either -f or -x must be specified");
        System.out.println("  -d <file-dir>  dir to write files");
        System.exit(-1);
    }

    private void readArgs(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n++];
            if (n >= stringArray.length) {
                SpipeClient.showUsageAndExit();
            }
            String string2 = stringArray[n];
            if (string.equals("-s")) {
                this.m_url = new URL(string2);
            } else if (string.equals("-k")) {
                this.m_privKey = EpoCrypto.loadEpoPrivateKey(string2);
            } else if (string.equals("-f")) {
                this.m_packages = new SpipePackage[1];
                this.m_packages[0] = new SpipePackage(FileUtil.loadAsBuffer(string2));
            } else if (string.equals("-x")) {
                SpipeXmlParser spipeXmlParser = new SpipeXmlParser(string2);
                this.m_packages = spipeXmlParser.getPackages();
            } else if (string.equals("-d")) {
                this.m_writeDir = string2;
            } else {
                SpipeClient.showUsageAndExit();
            }
            ++n;
        }
        if (this.m_url == null || this.m_privKey == null || this.m_packages == null || this.m_packages.length <= 0) {
            SpipeClient.showUsageAndExit();
        }
    }
}

