/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.client;

import com.mcafee.epo.core.spipe.EpoCrypto;
import com.mcafee.epo.core.spipe.FileData;
import com.mcafee.epo.core.spipe.SpipePackage;
import com.mcafee.epo.core.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class SpipePrinter {
    private SpipePackage m_pkg = null;
    PrivateKey m_privateKey = null;
    PublicKey m_publicKey = null;

    public SpipePrinter(String string, String string2) throws Exception {
        this.m_privateKey = EpoCrypto.loadEpoPrivateKey(string2);
        this.m_publicKey = EpoCrypto.loadEpoPublicKey(string2);
        this.m_pkg = new SpipePackage(FileUtil.loadAsBuffer(string), this.m_publicKey);
    }

    public SpipePrinter(byte[] byArray) throws IOException, GeneralSecurityException {
        this.m_privateKey = null;
        this.m_publicKey = null;
        this.m_pkg = new SpipePackage(byArray, this.m_publicKey);
    }

    public void run() throws Exception {
        SpipePrinter.printPackageContents(this.m_pkg, "c:/tmp/spipe-files");
    }

    public static void printPackageContents(SpipePackage spipePackage, String string) throws Exception {
        System.out.println("Version     :" + spipePackage.getVersion());
        System.out.println("Sender GUID :" + spipePackage.getSenderGUID());
        System.out.println("Pkg    GUID :" + spipePackage.getPackageGUID());
        System.out.println("Pkg Type    :" + spipePackage.getPackageType());
        System.out.println("ComputerName:" + spipePackage.getComputerName());
        int n = 0;
        while (n < spipePackage.getNumProperties()) {
            System.out.println("[" + n + "] Info    :" + spipePackage.getPropertyName(n) + " = " + spipePackage.getPropertyValue(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < spipePackage.getNumFiles()) {
            FileData fileData = spipePackage.getFile(n2);
            System.out.println("[" + n2 + "] File    : name=" + fileData.getPath() + " length=" + fileData.getData().length);
            if (string != null) {
                File file = new File(string + "/" + fileData.getPath());
                file.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(fileData.getData());
                fileOutputStream.close();
            }
            ++n2;
        }
    }

    public static void printPackageContents(SpipePackage spipePackage) throws Exception {
        SpipePrinter.printPackageContents(spipePackage, null);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.out.println("Usage: SpipePrinter <message-pkg-file> <priv-key-file>");
            System.exit(-1);
        }
        SpipePrinter spipePrinter = new SpipePrinter(stringArray[0], stringArray[1]);
        spipePrinter.run();
    }
}

