/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.db;

import com.mcafee.epo.common.server.ServerNative;
import com.mcafee.epo.core.db.EpoPassword;
import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.util.LocaleName;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.log4j.Logger;

public class EpoUser
extends DatabaseObject
implements HttpSessionBindingListener {
    private static Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$core$db$EpoUser == null ? (class$com$mcafee$epo$core$db$EpoUser = EpoUser.class$("com.mcafee.epo.core.db.EpoUser")) : class$com$mcafee$epo$core$db$EpoUser));
    public static final String USER_NAME = "name";
    public static final String USER_PASSWORD = "password";
    public static final String TABLE_NAME = "UserTable";
    public static final int COL_ID = 1;
    public static final int COL_USERNAME = 2;
    public static final int COL_PASSWORD = 3;
    public static final int COL_TIMESTAMP = 4;
    public static final int COL_HIDDENTIMESTAMP = 5;
    public static final int COL_ROOT_NODE_ID = 6;
    public static final int COL_WRITE_ACCESS = 7;
    public static final int COL_NT_USER = 8;
    public static final int NUM_COLS = 8;
    public static final int NUM_PROPERTIES = 9;
    public static final String[] PROPERTY_NAMES = new String[]{"AutoId", "UserName", "Password", "TheTimestamp", "TheHiddenTimestamp", "RootNodeId", "WriteAccess", "NTUser", "LanguageId"};
    protected static final String UNIQUE_SQL = "select * from UserTable where AutoId=?";
    protected static final String SQL_SELECT_BY_NAME = "select * from UserTable where UserName=?";
    protected static final String SQL_SELECT_BY_ID = "select * from UserTable where AutoID=?";
    protected static final String SQL_SELECT_WRITER = "select top 1 * from UserTable where WriteAccess=1";
    private boolean m_embedded = false;
    private boolean m_valid = false;
    private long m_id = -1L;
    private String m_username = "";
    private String m_password = "";
    private byte[] m_timestamp = null;
    private byte[] m_htimestamp = null;
    private Long m_rootNode = null;
    private List m_rootNodes = new ArrayList();
    private Boolean m_writeAccess = null;
    private boolean m_bNTUser = false;
    private long m_lastComm = 0L;
    private String m_langId = null;
    private boolean m_bSSPIUser = false;
    private static HashMap m_sessionBindings = new HashMap();
    static /* synthetic */ Class class$com$mcafee$epo$core$db$EpoUser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final EpoUser getByName(Connection connection, String string) throws SQLException {
        Vector vector;
        PreparedStatement preparedStatement;
        EpoUser epoUser;
        block7: {
            block6: {
                EpoUser epoUser2;
                if (string == null) {
                    return null;
                }
                epoUser = null;
                preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement(SQL_SELECT_BY_NAME);
                    preparedStatement.setString(1, string);
                    vector = DatabaseObject.getByQuery(connection, preparedStatement, class$com$mcafee$epo$core$db$EpoUser == null ? (class$com$mcafee$epo$core$db$EpoUser = EpoUser.class$("com.mcafee.epo.core.db.EpoUser")) : class$com$mcafee$epo$core$db$EpoUser, 1, -1);
                    if (vector != null) break block6;
                    epoUser2 = null;
                    Object var8_6 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    DatabaseUtil.close(preparedStatement);
                    throw throwable;
                }
                DatabaseUtil.close(preparedStatement);
                return epoUser2;
            }
            if (vector.size() != 0) break block7;
            EpoUser epoUser3 = null;
            Object var8_7 = null;
            DatabaseUtil.close(preparedStatement);
            return epoUser3;
        }
        if (vector.size() > 1) {
            throw new SQLException("User query returned more than one result.");
        }
        epoUser = (EpoUser)vector.firstElement();
        EpoUser.getMultiSiteAdminRootNodes(connection, epoUser);
        Object var8_8 = null;
        DatabaseUtil.close(preparedStatement);
        return epoUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final EpoUser getById(Connection connection, int n) throws SQLException {
        Vector vector;
        PreparedStatement preparedStatement;
        EpoUser epoUser;
        block7: {
            block6: {
                EpoUser epoUser2;
                if (n <= 0) {
                    return null;
                }
                epoUser = null;
                preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement(SQL_SELECT_BY_ID);
                    preparedStatement.setInt(1, n);
                    vector = DatabaseObject.getByQuery(connection, preparedStatement, class$com$mcafee$epo$core$db$EpoUser == null ? (class$com$mcafee$epo$core$db$EpoUser = EpoUser.class$("com.mcafee.epo.core.db.EpoUser")) : class$com$mcafee$epo$core$db$EpoUser, 1, -1);
                    if (vector != null) break block6;
                    epoUser2 = null;
                    Object var8_6 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    DatabaseUtil.close(preparedStatement);
                    throw throwable;
                }
                DatabaseUtil.close(preparedStatement);
                return epoUser2;
            }
            if (vector.size() != 0) break block7;
            EpoUser epoUser3 = null;
            Object var8_7 = null;
            DatabaseUtil.close(preparedStatement);
            return epoUser3;
        }
        if (vector.size() > 1) {
            throw new SQLException("User query returned more than one result.");
        }
        epoUser = (EpoUser)vector.firstElement();
        EpoUser.getMultiSiteAdminRootNodes(connection, epoUser);
        Object var8_8 = null;
        DatabaseUtil.close(preparedStatement);
        return epoUser;
    }

    private static final void getMultiSiteAdminRootNodes(Connection connection, EpoUser epoUser) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select NodeID from EPOSiteUserPermissions where UserID='" + epoUser.getAutoId() + "' ");
        while (resultSet.next()) {
            epoUser.addRootNoteId(resultSet.getLong(1));
        }
    }

    public static final EpoUser getNonReviewer(Connection connection) throws SQLException {
        Vector vector = DatabaseObject.getByQuery(connection, SQL_SELECT_WRITER, class$com$mcafee$epo$core$db$EpoUser == null ? (class$com$mcafee$epo$core$db$EpoUser = EpoUser.class$("com.mcafee.epo.core.db.EpoUser")) : class$com$mcafee$epo$core$db$EpoUser);
        if (vector.size() < 1) {
            throw new SQLException("Internal error: EpoUser.getNonReviewer returned zero rows");
        }
        return (EpoUser)vector.get(0);
    }

    public int getNumColumns() {
        return 8;
    }

    public int getNumProperties() {
        return 9;
    }

    public String getPropertyName(int n) {
        return PROPERTY_NAMES[n];
    }

    public String getUniqueQuerySql() {
        return UNIQUE_SQL;
    }

    public String getInsertSql() {
        return "insert into UserTable(UserName, Password, TheTimestamp, RootNodeId, WriteAccess) values(?,?,@@DBTS,?,?)";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setString(1, this.m_username);
        preparedStatement.setString(2, this.m_password);
        if (this.m_rootNode != null) {
            preparedStatement.setLong(3, this.m_rootNode);
        } else {
            preparedStatement.setNull(3, -5);
        }
        if (this.m_writeAccess != null) {
            preparedStatement.setBoolean(4, this.m_writeAccess);
        } else {
            preparedStatement.setNull(4, -7);
        }
    }

    public String getUpdateSql() {
        return "update UserTable set UserName=?, Password=?, TheTimestamp=@@DBTS, RootNodeId=?, WriteAccess=? where AutoId=?";
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
        preparedStatement.setLong(5, this.m_id);
    }

    public void setUniqueID(int n) throws SQLException {
        this.setAutoId(n);
    }

    public EpoUser() {
    }

    public EpoUser(String string, String string2) {
        this.m_username = string;
        this.m_password = string2;
    }

    public final boolean validateLogin(String string) throws Exception {
        block3: {
            block2: {
                this.m_valid = false;
                if (this.m_bNTUser) break block2;
                String string2 = EpoPassword.hashAndBase64Passphrase(this.m_username, string);
                if (!string2.equals(this.m_password)) break block3;
                this.m_valid = true;
                break block3;
            }
            m_log.debug((Object)"Authenticate NT user...");
            try {
                this.m_valid = ServerNative.processNTLogin(this.m_username, string);
            }
            catch (Exception exception) {
                this.m_valid = false;
            }
        }
        return this.m_valid;
    }

    public final boolean validateLoginHashed(String string) throws Exception {
        if (!string.equals(this.m_password)) {
            return false;
        }
        this.m_valid = true;
        return true;
    }

    public static final int sspiValidate(long l, String string, String string2, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Exception {
        m_log.debug((Object)("sspiStage: " + l));
        int n = ServerNative.processSSPIAuth(l, string, string2, stringBuffer, stringBuffer2);
        return n;
    }

    public final boolean isSiteAccount() {
        if (this.m_rootNode == null) {
            return false;
        }
        return this.m_rootNode != 0L;
    }

    public final boolean isGlobalAccount() {
        if (this.m_rootNode == null) {
            return false;
        }
        return this.m_rootNode == 0L;
    }

    public final boolean isReviewer() {
        if (this.m_writeAccess == null) {
            return true;
        }
        return this.m_writeAccess == false;
    }

    public final boolean isGlobalAdmin() {
        return !this.isSiteAccount() && !this.isReviewer();
    }

    public final boolean isSiteAdmin() {
        return this.isSiteAccount() && !this.isReviewer();
    }

    public boolean isAuthenticated() {
        return this.m_valid;
    }

    public boolean isAdminForThisSite(long l) {
        if (this.isSiteAccount()) {
            return l == this.getRootNodeId();
        }
        return true;
    }

    public void logout() {
        this.m_valid = false;
        this.m_embedded = false;
        this.m_password = "";
    }

    public long getAutoId() {
        return this.m_id;
    }

    public void setAutoId(long l) {
        this.m_id = l;
    }

    public String getUserName() {
        return this.m_username;
    }

    public void setUserName(String string) {
        this.m_username = string;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String string) {
        this.m_password = string;
    }

    public byte[] getTheTimestamp() {
        return this.m_timestamp;
    }

    public void setTheTimestamp(byte[] byArray) {
        this.m_timestamp = byArray;
    }

    public byte[] getTheHiddenTimestamp() {
        return this.m_htimestamp;
    }

    public void setTheHiddenTimestamp(byte[] byArray) {
        this.m_htimestamp = byArray;
    }

    public Long getRootNodeId() {
        return this.m_rootNode;
    }

    public void setRootNodeId(Long l) {
        this.m_rootNode = l;
    }

    public List getRootNodeIds() {
        return this.m_rootNodes;
    }

    public void setRootNodeIds(List list) {
        this.m_rootNodes = list;
    }

    public void addRootNoteId(long l) {
        this.m_rootNodes.add(new Long(l));
    }

    public Boolean getWriteAccess() {
        return this.m_writeAccess;
    }

    public void setWriteAccess(Boolean bl) {
        this.m_writeAccess = bl;
    }

    public boolean getNTUser() {
        return this.m_bNTUser;
    }

    public void setNTUser(boolean bl) {
        this.m_bNTUser = bl;
    }

    public boolean getIsSSPIUser() {
        return this.m_bSSPIUser;
    }

    public final boolean isSSPIUser() {
        return this.getIsSSPIUser();
    }

    public void setIsSSPIUser(boolean bl) {
        this.m_bSSPIUser = bl;
        if (this.m_bSSPIUser) {
            this.m_valid = true;
            this.m_rootNode = new Long(0L);
            this.m_writeAccess = new Boolean(false);
        }
    }

    public void setEmbedded(boolean bl) {
        this.m_embedded = bl;
    }

    public boolean getEmbedded() {
        return this.m_embedded;
    }

    public long getLastComm() {
        return this.m_lastComm;
    }

    public void setLastComm(long l) {
        this.m_lastComm = l;
    }

    public String getLanguageId() {
        return this.m_langId;
    }

    public void setLanguageId(String string) {
        this.m_langId = string;
    }

    public int getLocaleId() {
        return LocaleName.getIdFromLanguage(this.m_langId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        HttpSession httpSession = httpSessionBindingEvent.getSession();
        String string = httpSession.getId();
        m_log.debug((Object)("Binding login to session: " + string));
        HashMap hashMap = m_sessionBindings;
        synchronized (hashMap) {
            m_sessionBindings.put(string, httpSessionBindingEvent.getValue());
        }
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EpoUser getFromInternalSessionMap(String string) {
        m_log.debug((Object)"Getting the EpoUser from internal session mappings.");
        EpoUser epoUser = null;
        HashMap hashMap = m_sessionBindings;
        synchronized (hashMap) {
            epoUser = (EpoUser)m_sessionBindings.get(string);
            if (epoUser != null) {
                m_log.debug((Object)("Found login information for user " + epoUser.getUserName() + " in session " + string));
            } else {
                m_log.debug((Object)("Couldn't find login information for session " + string));
            }
        }
        return epoUser;
    }

    public EpoUser[] getUserList(Connection connection) throws SQLException {
        String string = "select * from UserTable";
        Vector vector = DatabaseObject.getByQuery(connection, string, class$com$mcafee$epo$core$db$EpoUser == null ? (class$com$mcafee$epo$core$db$EpoUser = EpoUser.class$("com.mcafee.epo.core.db.EpoUser")) : class$com$mcafee$epo$core$db$EpoUser);
        EpoUser[] epoUserArray = new EpoUser[]{};
        epoUserArray = vector.toArray(epoUserArray);
        return epoUserArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

