/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.db.base;

import com.mcafee.epo.core.db.base.DatabaseObjectImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.BitSet;

public class ChangeTrackingDBOImpl
extends DatabaseObjectImpl {
    private BitSet m_dirtyBits = new BitSet(this.getColumns().length);
    private boolean m_usingTrackingInterface;

    public ChangeTrackingDBOImpl(DatabaseObjectImpl.ClassInfo classInfo) {
        super(classInfo);
        this.m_usingTrackingInterface = false;
    }

    public ChangeTrackingDBOImpl(DatabaseObjectImpl.ClassInfo classInfo, boolean bl) {
        super(classInfo);
        this.m_usingTrackingInterface = bl;
    }

    public boolean isUsingTrackingInterface() {
        return this.m_usingTrackingInterface;
    }

    public void setUsingTrackingInterface(boolean bl) {
        this.m_usingTrackingInterface = bl;
    }

    public int getNumModifiedCols() {
        return this.m_dirtyBits.cardinality();
    }

    private boolean valueHasChanged(int n, Object object) {
        Object object2 = this.getProperty(n);
        if (object == null) {
            return object2 != null;
        }
        if (object2 == null) {
            return true;
        }
        return !object.equals(object2);
    }

    public void setProperty(String string, Object object) {
        this.setProperty(this.getPropertyIndex(string), object);
    }

    public void setProperty(int n, Object object) {
        if (this.valueHasChanged(n, object)) {
            if (this.isUpdateColumn(n)) {
                this.m_dirtyBits.set(n);
            }
            super.setProperty(n, object);
        }
    }

    public String getUpdateSql() {
        String string;
        if (this.m_usingTrackingInterface) {
            if (this.m_dirtyBits.cardinality() > 0) {
                DatabaseObjectImpl.Column[] columnArray = this.getColumns();
                StringBuffer stringBuffer = new StringBuffer("update [");
                stringBuffer.append(this.getTableName());
                stringBuffer.append("] set ");
                int n = 0;
                boolean bl = true;
                int n2 = 0;
                while (n2 < this.m_dirtyBits.cardinality()) {
                    n = this.m_dirtyBits.nextSetBit(n);
                    if (!bl) {
                        stringBuffer.append(", ");
                    } else {
                        bl = false;
                    }
                    stringBuffer.append(columnArray[n].getColumnName()).append("=?");
                    ++n;
                    ++n2;
                }
                this.getClassInfo().appendUpdateWhereClause(stringBuffer);
                string = stringBuffer.toString();
            } else {
                string = null;
            }
        } else {
            string = super.getUpdateSql();
        }
        return string;
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        if (this.m_usingTrackingInterface) {
            DatabaseObjectImpl.Column[] columnArray = this.getColumns();
            int n = 0;
            int n2 = 0;
            while (n2 < this.m_dirtyBits.cardinality()) {
                n = this.m_dirtyBits.nextSetBit(n);
                columnArray[n].setParam(this, preparedStatement, n2 + 1);
                ++n;
                ++n2;
            }
            this.getClassInfo().prepareUpdateWhereClause(this, preparedStatement, this.m_dirtyBits.cardinality());
        } else {
            super.prepareUpdate(preparedStatement);
        }
    }

    public void update(Connection connection) throws SQLException {
        super.update(connection);
        this.m_dirtyBits.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUpdateAllColumns(Connection connection) throws SQLException {
        boolean bl = this.m_usingTrackingInterface;
        this.m_usingTrackingInterface = false;
        try {
            super.update(connection);
            this.m_dirtyBits.clear();
            Object var4_3 = null;
            this.m_usingTrackingInterface = bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_usingTrackingInterface = bl;
            throw throwable;
        }
    }
}

