/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.db.base;

import com.mcafee.epo.core.db.EpoServerIni;
import com.mcafee.epo.core.db.base.DbConnectionPool;
import com.mcafee.epo.core.db.base.MSSqlServerInfo;
import com.mcafee.epo.core.util.resource.Resource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Database {
    private static final Logger m_log = Logger.getLogger((String)(class$com$mcafee$epo$core$db$base$Database == null ? (class$com$mcafee$epo$core$db$base$Database = Database.class$("com.mcafee.epo.core.db.base.Database")) : class$com$mcafee$epo$core$db$base$Database).getName());
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    public static final int IDLE_LIMIT_INFINITE = -1;
    private String m_dbServerName = "";
    private String m_databaseName = "";
    private String m_userName = "";
    private String m_password = "";
    private String m_validationQuery = "";
    private int m_jdbcDriverType = 2;
    private String m_instanceName = "";
    private String m_port = "1433";
    private String m_domain = "";
    private int m_maxActive = 16;
    private byte m_exhaustAction = 1;
    private int m_maxIdle = -1;
    private String m_conName = "";
    private String m_epoInstallDir = "";
    private String m_epoDBDir = "";
    private String m_epoAppServerIP = "";
    DbConnectionPool m_pool = null;
    static /* synthetic */ Class class$com$mcafee$epo$core$db$base$Database;

    public Database(Properties properties, String string, String string2) throws Exception {
        this.readCommonProperties(properties, string, string2);
        this.m_epoInstallDir = Database.getString(properties, "epo.install.dir", "c:/Program Files/McAfee/ePO/3.6.0");
        this.m_epoDBDir = Database.getString(properties, "epo.db.dir", "c:/Program Files/McAfee/ePO/3.6.0/DB");
        boolean bl = Database.getString(properties, "epo.use.server.ini", "false").equals("true");
        if (bl) {
            this.readFromServerIni(properties);
        } else {
            this.readFromProperties(properties);
        }
        this.init();
    }

    public Database(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n, int n2, int n3, byte by) throws Exception {
        this.m_dbServerName = string;
        this.m_databaseName = string4;
        this.m_userName = string5;
        this.m_password = string7;
        this.m_validationQuery = string8;
        this.m_jdbcDriverType = n;
        this.m_instanceName = string2;
        this.m_port = string3;
        this.m_domain = string6;
        this.m_conName = string9;
        this.m_maxActive = n2;
        this.m_exhaustAction = by;
        this.m_maxIdle = n3;
        this.init();
    }

    public void close() {
    }

    public Connection getConnection() throws SQLException {
        return this.m_pool.getConnection();
    }

    public DbConnectionPool getPool() {
        return this.m_pool;
    }

    public void validate() throws SQLException {
        this.m_pool.validate();
    }

    public DbConnectionPool createConnectionPool() throws Exception {
        DbConnectionPool dbConnectionPool = new DbConnectionPool(this.m_dbServerName, this.m_instanceName, this.m_port, this.m_databaseName, this.m_userName, this.m_domain, this.m_password, this.m_validationQuery, this.m_conName, this.m_jdbcDriverType, this.m_maxActive, this.m_exhaustAction, this.m_maxIdle);
        Connection connection = dbConnectionPool.getConnection();
        connection.close();
        return dbConnectionPool;
    }

    public String dbServerName() {
        return this.m_dbServerName;
    }

    public String databaseName() {
        return this.m_databaseName;
    }

    public String userName() {
        return this.m_userName;
    }

    public String userPassword() {
        return this.m_password;
    }

    public String instanceName() {
        return this.m_instanceName;
    }

    public String port() {
        return this.m_port;
    }

    public String userDomain() {
        return this.m_domain;
    }

    public String validationQuery() {
        return this.m_validationQuery;
    }

    public int jdbcDriverType() {
        return this.m_jdbcDriverType;
    }

    private final void init() throws Exception {
        m_log.info((Object)Resource.formatString("database_init_msg", new String[]{this.m_dbServerName, this.m_instanceName, this.m_port, this.m_databaseName}));
        this.m_pool = this.createConnectionPool();
        this.validate();
    }

    private final void readCommonProperties(Properties properties, String string, String string2) throws Exception {
        String string3;
        this.m_conName = string;
        this.m_maxActive = Integer.parseInt(Database.getString(properties, "db.pool.connections.max", "16"));
        String string4 = Database.getString(properties, "db.pool.exhausted.action", "grow");
        this.m_exhaustAction = (byte)2;
        if (string4.equals("block")) {
            this.m_exhaustAction = 1;
        }
        this.m_maxIdle = (string3 = Database.getString(properties, "db.pool.connections.idle.max", "infinite")).equals("infinite") ? -1 : Integer.parseInt(string3);
        String string5 = Database.getString(properties, string, "db.jdbc.driver", "jtds");
        this.m_jdbcDriverType = DbConnectionPool.stringTojdbcDriver(string5);
        this.m_validationQuery = string2;
    }

    private final void readFromServerIni(Properties properties) throws Exception {
        String string = this.m_epoDBDir + "/server.ini";
        m_log.debug((Object)("Loading server.ini: " + string));
        EpoServerIni epoServerIni = new EpoServerIni(string);
        this.m_dbServerName = epoServerIni.getDbServer();
        this.m_databaseName = epoServerIni.getDbName();
        this.m_userName = epoServerIni.getUserName();
        this.m_password = epoServerIni.getDecryptedPassword();
        this.m_instanceName = epoServerIni.getDbInstance();
        this.m_port = this.autoDetectSqlPort(Database.getString(properties, "epo.default.db.port", "1433"));
        this.m_domain = epoServerIni.getDomain();
        this.m_epoAppServerIP = epoServerIni.getAppServerIP();
    }

    private final void readFromProperties(Properties properties) throws Exception {
        this.m_dbServerName = Database.getString(properties, this.m_conName, "db.server.name", null);
        this.m_databaseName = Database.getString(properties, this.m_conName, "db.database.name", null);
        this.m_userName = Database.getString(properties, this.m_conName, "db.user.name", null);
        this.m_password = Database.getString(properties, this.m_conName, "db.user.passwd", null);
        this.m_instanceName = Database.getString(properties, this.m_conName, "db.instance.name", "");
        this.m_port = Database.getString(properties, this.m_conName, "db.port", "1433");
        this.m_domain = Database.getString(properties, this.m_conName, "db.user.domain", "");
        this.m_epoAppServerIP = Database.getString(properties, this.m_conName, "epo.appserver.ip", "");
    }

    private static final String addPrefix(String string, String string2) {
        if (string != null && string.length() > 0) {
            return string + "." + string2;
        }
        return string2;
    }

    private static final String getString(Properties properties, String string, String string2, String string3) {
        String string4 = properties.getProperty(Database.addPrefix(string, string2));
        if (string4 == null) {
            return string3;
        }
        return string4.trim();
    }

    private static final String getString(Properties properties, String string, String string2) {
        return Database.getString(properties, null, string, string2);
    }

    private final String autoDetectSqlPort(String string) {
        String string2;
        block3: {
            string2 = string;
            try {
                m_log.debug((Object)"Auto-detecting sql server port...");
                MSSqlServerInfo mSSqlServerInfo = new MSSqlServerInfo();
                mSSqlServerInfo.getInfo(this.m_dbServerName);
                int n = mSSqlServerInfo.getPortForInstance(this.m_instanceName);
                if (n != -1) {
                    m_log.debug((Object)("Successfully got port:" + n));
                    string2 = "" + n;
                    break block3;
                }
                m_log.debug((Object)("Couldn't get port; using default:" + string2));
            }
            catch (SQLException sQLException) {
                m_log.warn((Object)("Unable to dynamically obtain MS SQL Server password. Using " + string2 + "; change property epo.default.db.port if this is not correct."));
            }
        }
        return string2;
    }

    public final String getEPODBDir() {
        return this.m_epoDBDir;
    }

    public final String getEPOInstallDir() {
        return this.m_epoInstallDir;
    }

    public final String getEPOAppServerIP() {
        return this.m_epoAppServerIP;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

