/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.db.base;

import com.mcafee.epo.core.util.BeanUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;

public abstract class DatabaseObject
implements Cloneable {
    public static final int INVALID_ID = -1;
    public static final int ALL_ROWS = -1;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$mcafee$epo$core$db$base$DatabaseObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Connection connection, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        try {
            preparedStatement = connection.prepareStatement(this.getInsertSql());
            this.prepareInsert(preparedStatement);
            preparedStatement.executeUpdate();
            if (bl) {
                statement = connection.prepareStatement("select @@IDENTITY");
                ResultSet resultSet = statement.executeQuery();
                if (!resultSet.next()) {
                    throw new SQLException("DatabaseObject.add: couldn't get identity number!");
                }
                this.setUniqueID(resultSet.getInt(1));
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public void add(Connection connection) throws SQLException {
        this.add(connection, true);
    }

    protected Integer getInt(ResultSet resultSet, int n) throws SQLException {
        int n2 = resultSet.getInt(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return new Integer(n2);
    }

    protected Integer getInt(ResultSet resultSet, String string) throws SQLException {
        int n = resultSet.getInt(string);
        if (resultSet.wasNull()) {
            return null;
        }
        return new Integer(n);
    }

    protected Long getLong(ResultSet resultSet, int n) throws SQLException {
        long l = resultSet.getLong(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return new Long(l);
    }

    protected Boolean getBoolean(ResultSet resultSet, int n) throws SQLException {
        boolean bl = resultSet.getBoolean(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return new Boolean(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = this.getUpdateSql();
            if (string != null) {
                preparedStatement = connection.prepareStatement(string);
                this.prepareUpdate(preparedStatement);
                int n = preparedStatement.executeUpdate();
                if (n < 1) {
                    throw new SQLException("Update returned zero rows!");
                }
            }
            Object var6_5 = null;
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DatabaseObject getFromDatabase(Connection connection) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        DatabaseObject databaseObject;
        block7: {
            databaseObject = null;
            preparedStatement = null;
            preparedStatement = connection.prepareStatement(this.getUniqueQuerySql());
            this.prepareUniqueQuery(preparedStatement);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) break block7;
            DatabaseObject databaseObject2 = null;
            Object var8_8 = null;
            if (preparedStatement == null) return databaseObject2;
            preparedStatement.close();
            return databaseObject2;
        }
        try {
            try {
                databaseObject = (DatabaseObject)this.getClass().newInstance();
                databaseObject.setValues(resultSet);
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException("Internal Error: Instantion error in DatabaseObject.getFromDatabase()");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException("Internal Error: Illegal access error in DatabaseObject.getFromDatabase()");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SQLException("Internal Error: Unable to invoke setter method in DatabaseObjet.getFromDatabase()");
            }
            Object var8_9 = null;
            if (preparedStatement == null) return databaseObject;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
        return databaseObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdFromDatabase(Connection connection) throws SQLException {
        int n;
        block2: {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement(this.getUniqueIdSql());
                this.prepareUniqueQuery(preparedStatement);
                int n2 = -1;
                ResultSet resultSet = preparedStatement.executeQuery();
                n2 = resultSet.next() ? resultSet.getInt(1) : -1;
                n = n2;
                Object var7_6 = null;
                if (preparedStatement == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (preparedStatement == null) break block3;
                    preparedStatement.close();
                }
                throw throwable;
            }
            preparedStatement.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Vector getByQuery(Connection connection, String string, Class clazz, int n, int n2) throws SQLException {
        Vector vector;
        block3: {
            if (!$assertionsDisabled && n2 != -1 && n2 <= 0) {
                throw new AssertionError();
            }
            Statement statement = null;
            try {
                statement = n == 1 ? connection.createStatement() : connection.createStatement(1004, 1007);
                vector = DatabaseObject.processResultSet(statement.executeQuery(string), statement.getMaxRows(), n2, n, clazz);
                Object var8_7 = null;
                if (statement == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_8 = null;
                    if (statement == null) break block4;
                    statement.close();
                }
                throw throwable;
            }
            statement.close();
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Vector getByQuery(Connection connection, PreparedStatement preparedStatement, Class clazz, int n, int n2) throws SQLException {
        Vector vector;
        block3: {
            if (!$assertionsDisabled && n2 != -1 && n2 <= 0) {
                throw new AssertionError();
            }
            try {
                vector = DatabaseObject.processResultSet(preparedStatement.executeQuery(), preparedStatement.getMaxRows(), n2, n, clazz);
                Object var7_6 = null;
                if (preparedStatement == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var7_7 = null;
                    if (preparedStatement == null) break block4;
                    preparedStatement.close();
                }
                throw throwable;
            }
            preparedStatement.close();
        }
        return vector;
    }

    private static Vector processResultSet(ResultSet resultSet, int n, int n2, int n3, Class clazz) throws SQLException {
        try {
            if (n2 != -1) {
                int n4 = n;
                if (n4 == 0) {
                    n4 = n2;
                } else if (n2 < n4) {
                    n4 = n2;
                }
                resultSet.setFetchSize(n4);
            }
            if (n3 > 1 && !resultSet.absolute(n3 - 1)) {
                return new Vector();
            }
            Vector<DatabaseObject> vector = new Vector<DatabaseObject>();
            while (resultSet.next()) {
                DatabaseObject databaseObject = (DatabaseObject)clazz.newInstance();
                databaseObject.setValues(resultSet);
                vector.add(databaseObject);
                if (n2 != -1 && vector.size() >= n2) break;
            }
            return vector;
        }
        catch (InstantiationException instantiationException) {
            throw new SQLException("Internal Error: Instantion error in DatabaseObject.getByQuery()");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException("Internal Error: Illegal access error in DatabaseObject.getByQuery()");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException("Internal Error: Unable to invoke setter method in DatabaseObjet.getByQuery()");
        }
    }

    public static final Vector getByQuery(Connection connection, String string, Class clazz) throws SQLException {
        return DatabaseObject.getByQuery(connection, string, clazz, 1, -1);
    }

    public static final Vector getByQuery(Connection connection, PreparedStatement preparedStatement, Class clazz) throws SQLException {
        return DatabaseObject.getByQuery(connection, preparedStatement, clazz, 1, -1);
    }

    public Object getProperty(int n) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (!($assertionsDisabled || n > 0 && n <= this.getNumProperties())) {
            throw new AssertionError();
        }
        return this.getProperty(this.getPropertyName(n));
    }

    public Object getProperty(String string) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = this.getClass();
        String string2 = "get" + string;
        Method method = clazz.getMethod(string2, null);
        Object object = method.invoke((Object)this, new Object[0]);
        return object;
    }

    public Class getPropertyType(String string) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = this.getClass();
        String string2 = "get" + string;
        Method method = clazz.getMethod(string2, null);
        Class<?> clazz2 = method.getReturnType();
        return clazz2;
    }

    public void setProperty(String string, Object object) throws Exception {
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = object.getClass();
        Class[] classArray = new Class[]{clazz2};
        String string2 = "set" + string;
        Method method = clazz.getMethod(string2, classArray);
        Object[] objectArray = new Object[]{object};
        method.invoke((Object)this, objectArray);
    }

    public void setValues(ResultSet resultSet) throws SQLException, IllegalAccessException, InvocationTargetException {
        BeanUtil.initBean(resultSet, (Object)this);
    }

    public abstract String getInsertSql();

    public abstract void prepareInsert(PreparedStatement var1) throws SQLException;

    public abstract String getUpdateSql();

    public abstract void prepareUpdate(PreparedStatement var1) throws SQLException;

    public String getUniqueQuerySql() {
        throw new UnsupportedOperationException("getUniqueQuerySql not implemented for class " + this.getClass().toString());
    }

    public String getUniqueIdSql() {
        throw new UnsupportedOperationException("getUniqueIdSql not implemented for class " + this.getClass().toString());
    }

    public void prepareUniqueQuery(PreparedStatement preparedStatement) throws SQLException {
        throw new UnsupportedOperationException("prepareUniqueQuery not implemented for class " + this.getClass().toString());
    }

    public abstract void setUniqueID(int var1) throws SQLException;

    public int getNumColumns() {
        return 0;
    }

    public int getNumProperties() {
        return 0;
    }

    public String getPropertyName(int n) {
        return "";
    }

    protected static final void setParam(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        preparedStatement.setString(n, string);
    }

    protected static final void setParam(PreparedStatement preparedStatement, int n, String string, int n2) throws SQLException {
        if (string != null && string.length() > n2) {
            string = string.substring(0, n2);
        }
        preparedStatement.setString(n, string);
    }

    protected static final void setParam(PreparedStatement preparedStatement, int n, float f) throws SQLException {
        preparedStatement.setFloat(n, f);
    }

    protected static final void setParam(PreparedStatement preparedStatement, int n, Float f) throws SQLException {
        if (f == null) {
            preparedStatement.setNull(n, 4);
        } else {
            preparedStatement.setFloat(n, f.floatValue());
        }
    }

    protected static final void setParam(PreparedStatement preparedStatement, int n, double d) throws SQLException {
        preparedStatement.setDouble(n, d);
    }

    protected static final void setParam(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        preparedStatement.setInt(n, n2);
    }

    protected static final void setParam(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
        preparedStatement.setBytes(n, byArray);
    }

    protected static final void setBlob(PreparedStatement preparedStatement, int n, Blob blob) throws SQLException {
        preparedStatement.setBlob(n, blob);
    }

    protected static final void setClob(PreparedStatement preparedStatement, int n, Clob clob) throws SQLException {
        preparedStatement.setClob(n, clob);
    }

    protected static final void setParam(PreparedStatement preparedStatement, int n, Timestamp timestamp) throws SQLException {
        preparedStatement.setTimestamp(n, timestamp);
    }

    protected static final void setParam(PreparedStatement preparedStatement, int n, boolean bl) throws SQLException {
        preparedStatement.setBoolean(n, bl);
    }

    protected static final void setParam(PreparedStatement preparedStatement, int n, Integer n2) throws SQLException {
        if (n2 == null) {
            preparedStatement.setNull(n, 4);
        } else {
            preparedStatement.setInt(n, n2);
        }
    }

    protected static final void setParam(PreparedStatement preparedStatement, int n, long l) throws SQLException {
        preparedStatement.setLong(n, l);
    }

    protected static final void setParam(PreparedStatement preparedStatement, int n, Long l) throws SQLException {
        if (l == null) {
            preparedStatement.setNull(n, 4);
        } else {
            DatabaseObject.setParam(preparedStatement, n, (long)l);
        }
    }

    protected static final void setParam(PreparedStatement preparedStatement, int n, Boolean bl) throws SQLException {
        if (bl == null) {
            preparedStatement.setNull(n, 16);
        } else {
            preparedStatement.setBoolean(n, bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$mcafee$epo$core$db$base$DatabaseObject == null ? (class$com$mcafee$epo$core$db$base$DatabaseObject = DatabaseObject.class$("com.mcafee.epo.core.db.base.DatabaseObject")) : class$com$mcafee$epo$core$db$base$DatabaseObject).desiredAssertionStatus();
    }
}

