/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.spipe;

import java.io.IOException;

public class MemoryBuffer {
    private byte[] m_buf = null;
    private int m_pos = 0;

    public MemoryBuffer(byte[] byArray) {
        this.m_buf = byArray;
        this.m_pos = 0;
    }

    public final byte[] getBuffer() {
        return this.m_buf;
    }

    public final int getPosition() {
        return this.m_pos;
    }

    public final int getLength() {
        return this.m_buf.length;
    }

    public final void reset() {
        this.m_pos = 0;
    }

    public final boolean atEnd() {
        return this.m_pos >= this.m_buf.length;
    }

    public void setPosition(int n) {
        this.m_pos = n;
        if (this.m_pos < 0) {
            this.m_pos = 0;
        }
        if (this.m_pos >= this.m_buf.length) {
            this.m_pos = this.m_buf.length;
        }
    }

    public byte readInt8() throws IOException {
        if (this.m_pos >= this.m_buf.length) {
            throw new IOException("Passed end of buffer.");
        }
        byte by = this.m_buf[this.m_pos];
        ++this.m_pos;
        return by;
    }

    public short readInt16LE() throws IOException {
        if (this.m_pos + 1 >= this.m_buf.length) {
            throw new IOException("Passed end of buffer.");
        }
        short s = (short)(this.m_buf[this.m_pos + 1] << 8 & 0xFF00 | this.m_buf[this.m_pos + 0] & 0xFF);
        this.m_pos += 2;
        return s;
    }

    public final short readInt16BE() throws IOException {
        if (this.m_pos + 1 >= this.m_buf.length) {
            throw new IOException("Passed end of buffer.");
        }
        short s = (short)(this.m_buf[this.m_pos + 0] << 8 & 0xFF00 | this.m_buf[this.m_pos + 1] & 0xFF);
        this.m_pos += 2;
        return s;
    }

    public int readInt32LE() throws IOException {
        if (this.m_pos + 3 >= this.m_buf.length) {
            throw new IOException("Passed end of buffer.");
        }
        int n = this.m_buf[this.m_pos + 3] << 24 | this.m_buf[this.m_pos + 2] << 16 & 0xFF0000 | this.m_buf[this.m_pos + 1] << 8 & 0xFF00 | this.m_buf[this.m_pos + 0] & 0xFF;
        this.m_pos += 4;
        return n;
    }

    public int readInt32BE() throws IOException {
        if (this.m_pos + 3 >= this.m_buf.length) {
            throw new IOException("Passed end of buffer.");
        }
        int n = this.m_buf[this.m_pos + 0] << 24 | this.m_buf[this.m_pos + 1] << 16 & 0xFF0000 | this.m_buf[this.m_pos + 2] << 8 & 0xFF00 | this.m_buf[this.m_pos + 3] & 0xFF;
        this.m_pos += 4;
        return n;
    }

    public String readString(int n) throws IOException {
        if (this.m_pos + n - 1 >= this.m_buf.length) {
            throw new IOException("Passed end of buffer.");
        }
        if (n < 0) {
            throw new IOException("Negative size passed to readString");
        }
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            if (this.m_buf[this.m_pos + n2] == 0) break;
            ++n2;
        }
        String string = new String(this.m_buf, this.m_pos, n2, "UTF8");
        this.m_pos += n;
        return string;
    }

    public byte[] readBytes(int n) throws IOException {
        if (this.m_pos + n - 1 >= this.m_buf.length) {
            throw new IOException("Passed end of buffer.");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.m_buf, this.m_pos, byArray, 0, n);
        this.m_pos += n;
        return byArray;
    }
}

