/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.spipe;

import com.mcafee.epo.core.spipe.EpoCrypto;
import com.mcafee.epo.core.spipe.FileData;
import com.mcafee.epo.core.spipe.MemoryBuffer;
import com.mcafee.epo.core.spipe.PackageProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;

public class SpipePackage {
    public static final int SPIPE_VERSION_1 = 0x10000001;
    public static final int SPIPE_VERSION_2 = 0x20000001;
    public static final int SPIPE_VERSION_3 = 0x30000001;
    public static final int PACKAGE_TYPE_KEY = 1;
    public static final int PACKAGE_TYPE_FILE = 2;
    public static final int PACKAGE_TYPE_BUFFER = 3;
    private String m_senderGUID = "";
    private String m_packageGUID = "";
    private String m_computerName = "";
    private int m_packageType = 2;
    private int m_version = 0x30000001;
    private ArrayList m_files = new ArrayList();
    private ArrayList m_properties = new ArrayList();

    public SpipePackage() {
    }

    public SpipePackage(byte[] byArray) throws IOException, GeneralSecurityException {
        this.read(byArray);
    }

    public SpipePackage(byte[] byArray, PublicKey publicKey) throws IOException, GeneralSecurityException {
        this.read(byArray, publicKey);
    }

    public final void read(byte[] byArray) throws IOException, GeneralSecurityException {
        this.read(byArray, null);
    }

    /*
     * Unable to fully structure code
     */
    public final void read(byte[] var1_1, PublicKey var2_2) throws IOException, GeneralSecurityException {
        var3_3 = new MemoryBuffer(var1_1);
        this.xorData(var3_3.getBuffer());
        this.m_files.clear();
        this.m_properties.clear();
        if (var3_3.readInt8() != 80 || var3_3.readInt8() != 79) {
            throw new IOException("SPIPE package missing header sig.");
        }
        var4_4 = var3_3.readInt32LE();
        if (var4_4 != 0x10000001 && var4_4 != 0x20000001 && var4_4 != 0x30000001) {
            throw new IOException("Invalid SPIPE version:" + var4_4);
        }
        var5_5 = var3_3.readInt32LE();
        var6_6 = var3_3.readInt32LE();
        var3_3.readInt32LE();
        var7_7 = var3_3.readInt32LE();
        this.setSenderGUID(var3_3.readString(64));
        this.setPackageGUID(var3_3.readString(64));
        this.setPackageType(var3_3.readInt32LE());
        this.setComputerName(var3_3.readString(80));
        if (this.getPackageType() != 1 && this.getPackageType() != 2 && this.getPackageType() != 3) {
            throw new IOException("Unknown SPIPE package type:" + this.getPackageType());
        }
        if (var5_5 >= var3_3.getLength()) {
            throw new IOException("Data offset larger than package size");
        }
        if (var5_5 + var7_7 <= var3_3.getLength()) ** GOTO lbl29
        throw new IOException("Data size larger than package size");
lbl-1000:
        // 1 sources

        {
            var8_8 = var3_3.readString(var3_3.readInt32LE());
            var9_10 = var3_3.readString(var3_3.readInt32LE());
            this.m_properties.add(new PackageProperty(var8_8, (String)var9_10));
lbl29:
            // 2 sources

            ** while (var3_3.getPosition() < var5_5)
        }
lbl30:
        // 1 sources

        if (var3_3.getPosition() != var5_5) {
            throw new IOException("info values went into data region.");
        }
        var8_9 = var3_3.getPosition() + var7_7;
        while (var3_3.getPosition() < var8_9) {
            var3_3.readInt16LE();
            var9_10 = var3_3.readString(var3_3.readInt16LE());
            var10_11 = var3_3.readInt32LE();
            var11_12 = var3_3.readBytes(var10_11);
            this.m_files.add(new FileData((String)var9_10, var11_12));
        }
        if (var2_2 != null) {
            var9_10 = Signature.getInstance("SHA1withDSA");
            var9_10.initVerify(var2_2);
            var9_10.update(var3_3.getBuffer(), 0, var8_9);
            var10_11 = var3_3.readInt32LE();
            var11_12 = EpoCrypto.pgpSigToJavaSig(var3_3, var10_11);
            if (!var9_10.verify(var11_12)) {
                throw new SignatureException("SPIPE signature check failed.");
            }
        }
    }

    public final BinaryFormat write(PrivateKey privateKey) throws IOException, GeneralSecurityException {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(80);
        byteArrayOutputStream.write(79);
        SpipePackage.writeInt32LE(byteArrayOutputStream, this.m_version);
        SpipePackage.writeInt32LE(byteArrayOutputStream, 0);
        SpipePackage.writeInt32LE(byteArrayOutputStream, this.m_files.size());
        SpipePackage.writeInt32LE(byteArrayOutputStream, 0);
        SpipePackage.writeInt32LE(byteArrayOutputStream, 0);
        byteArrayOutputStream.write(this.stringToByteArray(this.m_senderGUID, 64));
        byteArrayOutputStream.write(this.stringToByteArray(this.m_packageGUID, 64));
        SpipePackage.writeInt32LE(byteArrayOutputStream, this.m_packageType);
        byteArrayOutputStream.write(this.stringToByteArray(this.m_computerName, 80));
        int n = 0;
        while (n < this.m_properties.size()) {
            PackageProperty packageProperty = this.getProperty(n);
            byte[] byArray3 = packageProperty.getName().getBytes("UTF8");
            object = packageProperty.getValue().getBytes("UTF8");
            SpipePackage.writeInt32LE(byteArrayOutputStream, byArray3.length);
            byteArrayOutputStream.write(byArray3);
            SpipePackage.writeInt32LE(byteArrayOutputStream, ((Object)object).length);
            byteArrayOutputStream.write((byte[])object);
            ++n;
        }
        int n2 = byteArrayOutputStream.size();
        int n3 = 0;
        while (n3 < this.m_files.size()) {
            object = this.getFile(n3);
            byArray2 = ((FileData)object).getPath().getBytes("UTF8");
            byArray = ((FileData)object).getData();
            SpipePackage.writeInt16LE(byteArrayOutputStream, (short)1);
            SpipePackage.writeInt16LE(byteArrayOutputStream, (short)byArray2.length);
            byteArrayOutputStream.write(byArray2);
            SpipePackage.writeInt32LE(byteArrayOutputStream, byArray.length);
            byteArrayOutputStream.write(byArray);
            ++n3;
        }
        int n4 = byteArrayOutputStream.size();
        byArray2 = new byte[64];
        byteArrayOutputStream.write(byArray2);
        byArray = byteArrayOutputStream.toByteArray();
        SpipePackage.writeInt32LE(byArray, 6, n2);
        SpipePackage.writeInt32LE(byArray, 18, n4 - n2);
        Signature signature = Signature.getInstance("SHA1withDSA");
        signature.initSign(privateKey);
        signature.update(byArray, 0, n4);
        byte[] byArray4 = EpoCrypto.javaSigToPgpSig(signature.sign());
        SpipePackage.writeInt32LE(byArray, n4, byArray4.length);
        int n5 = n4 + 4;
        System.arraycopy(byArray4, 0, byArray, n5, byArray4.length);
        this.xorData(byArray);
        return new BinaryFormat(byArray, n5 += byArray4.length);
    }

    public final String getSenderGUID() {
        return this.m_senderGUID;
    }

    public final void setSenderGUID(String string) {
        this.m_senderGUID = string;
    }

    public final String getPackageGUID() {
        return this.m_packageGUID;
    }

    public final void setPackageGUID(String string) {
        this.m_packageGUID = string;
    }

    public final String getComputerName() {
        return this.m_computerName;
    }

    public final void setComputerName(String string) {
        this.m_computerName = string;
    }

    public final int getPackageType() {
        return this.m_packageType;
    }

    public final void setPackageType(int n) {
        this.m_packageType = n;
    }

    public final int getVersion() {
        return this.m_version;
    }

    public final void setVersion(int n) {
        this.m_version = n;
    }

    public final int getNumFiles() {
        return this.m_files.size();
    }

    public final FileData getFile(int n) {
        return (FileData)this.m_files.get(n);
    }

    public final String getFileName(int n) {
        return this.getFile(n).getPath();
    }

    public final byte[] getFileData(int n) {
        return this.getFile(n).getData();
    }

    public final void addFile(FileData fileData) {
        this.m_files.add(fileData);
    }

    public final void addFile(String string, byte[] byArray) {
        this.m_files.add(new FileData(string, byArray));
    }

    public final void clearFiles() {
        this.m_files.clear();
    }

    public final int getNumProperties() {
        return this.m_properties.size();
    }

    public final PackageProperty getProperty(int n) {
        return (PackageProperty)this.m_properties.get(n);
    }

    public final String getProperty(String string) {
        int n = 0;
        while (n < this.m_properties.size()) {
            if (this.getProperty(n).getName().equals(string)) {
                return this.getProperty(n).getValue();
            }
            ++n;
        }
        return null;
    }

    public final String getPropertyName(int n) {
        return ((PackageProperty)this.m_properties.get(n)).getName();
    }

    public final String getPropertyValue(int n) {
        return ((PackageProperty)this.m_properties.get(n)).getValue();
    }

    public final void addProperty(PackageProperty packageProperty) {
        this.m_properties.add(packageProperty);
    }

    public final void addProperty(String string, String string2) {
        this.m_properties.add(new PackageProperty(string, string2));
    }

    public final void clearProperties() {
        this.m_properties.clear();
    }

    public boolean equals(Object object) {
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        SpipePackage spipePackage = (SpipePackage)object;
        if (!this.m_senderGUID.equals(spipePackage.m_senderGUID)) {
            return false;
        }
        if (!this.m_packageGUID.equals(spipePackage.m_packageGUID)) {
            return false;
        }
        if (!this.m_computerName.equals(spipePackage.m_computerName)) {
            return false;
        }
        if (this.m_packageType != spipePackage.m_packageType) {
            return false;
        }
        if (this.m_version != spipePackage.m_version) {
            return false;
        }
        if (this.m_properties.size() != spipePackage.m_properties.size()) {
            return false;
        }
        int n = 0;
        while (n < this.m_properties.size()) {
            if (!this.getPropertyName(n).equals(spipePackage.getPropertyName(n))) {
                return false;
            }
            if (!this.getPropertyValue(n).equals(spipePackage.getPropertyValue(n))) {
                return false;
            }
            ++n;
        }
        if (this.m_files.size() != spipePackage.m_files.size()) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.m_files.size()) {
            if (!this.getFileName(n2).equals(spipePackage.getFileName(n2))) {
                return false;
            }
            if (!Arrays.equals(this.getFileData(n2), spipePackage.getFileData(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private byte[] stringToByteArray(String string, int n) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes("UTF8");
        byte[] byArray2 = new byte[n];
        Arrays.fill(byArray2, (byte)0);
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length < byArray2.length ? byArray.length : byArray2.length);
        return byArray2;
    }

    private static final void writeInt32LE(ByteArrayOutputStream byteArrayOutputStream, int n) {
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(n >> 8 & 0xFF);
        byteArrayOutputStream.write(n >> 16 & 0xFF);
        byteArrayOutputStream.write(n >> 24 & 0xFF);
    }

    private static final void writeInt32LE(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 3] = (byte)(n2 >> 24 & 0xFF);
    }

    private static final void writeInt16LE(ByteArrayOutputStream byteArrayOutputStream, short s) {
        byteArrayOutputStream.write(s & 0xFF);
        byteArrayOutputStream.write(s >> 8 & 0xFF);
    }

    private void xorData(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(byArray[n] ^ 0xAA);
            ++n;
        }
    }

    public static class BinaryFormat {
        private byte[] m_bytes;
        private int m_length;

        public BinaryFormat(byte[] byArray, int n) {
            this.m_bytes = byArray;
            this.m_length = n;
        }

        public byte[] getBytes() {
            return this.m_bytes;
        }

        public int getLength() {
            return this.m_length;
        }
    }
}

