/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.spipe;

import com.mcafee.epo.core.spipe.SpipePackage;
import com.mcafee.epo.core.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SpipeXmlParser
extends DefaultHandler {
    public static final String ELEMENT_PACKAGE = "spipe";
    public static final String ELEMENT_INFO = "info";
    public static final String ELEMENT_FILE = "file";
    public static final String ATTR_SENDER_GUID = "sender-guid";
    public static final String ATTR_PACKAGE_GUID = "package-guid";
    public static final String ATTR_PACKAGE_TYPE = "package-type";
    public static final String ATTR_COMP_NAME = "computer-name";
    public static final String ATTR_INFO_NAME = "name";
    public static final String ATTR_INFO_VALUE = "value";
    public static final String ATTR_FILE_NAME = "name";
    public static final String ATTR_FILE_VALUE = "value";
    public static final String ATTR_FILE_VALUE_EXTERNAL = "valueFromFile";
    public static final String PKG_TYPE_FILE = "file";
    public static final String PKG_TYPE_KEY = "key";
    private SpipePackage m_current = null;
    private ArrayList m_packages = new ArrayList();

    public SpipeXmlParser() {
    }

    public SpipeXmlParser(byte[] byArray) throws IOException, ParserConfigurationException, SAXException {
        this.parse(new ByteArrayInputStream(byArray));
    }

    public SpipeXmlParser(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        this.parse(inputStream);
    }

    public SpipeXmlParser(String string) throws SAXException, IOException, ParserConfigurationException {
        this.parse(string);
    }

    public void parse(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        this.clear();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.newSAXParser().parse(inputStream, (DefaultHandler)this);
    }

    public void parse(String string) throws SAXException, IOException, ParserConfigurationException {
        this.parse(new FileInputStream(string));
    }

    public final int getNumPackages() {
        return this.m_packages.size();
    }

    public final SpipePackage getPackage(int n) {
        return (SpipePackage)this.m_packages.get(n);
    }

    public final SpipePackage[] getPackages() {
        return this.m_packages.toArray(new SpipePackage[0]);
    }

    private final void clear() {
        this.m_current = null;
        this.m_packages.clear();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = this.getElementName(string2, string3);
        if (string4 == ELEMENT_PACKAGE) {
            this.handlePackageElement(attributes);
        } else if (string4 == ELEMENT_INFO) {
            this.handleInfoElement(attributes);
        } else if (string4 == "file") {
            this.handleFileElement(attributes);
        }
    }

    private void handlePackageElement(Attributes attributes) throws SAXException {
        this.m_current = new SpipePackage();
        this.m_packages.add(this.m_current);
        this.m_current.setSenderGUID(this.getValue(attributes, ATTR_SENDER_GUID));
        this.m_current.setPackageGUID(this.getValue(attributes, ATTR_PACKAGE_GUID));
        this.m_current.setPackageType(this.getPackageType(attributes));
        this.m_current.setComputerName(this.getValue(attributes, ATTR_COMP_NAME));
    }

    private final int getPackageType(Attributes attributes) throws SAXException {
        int n;
        String string = this.getValue(attributes, ATTR_PACKAGE_TYPE, "file");
        if (string.equals("file")) {
            n = 2;
        } else if (string.equals(PKG_TYPE_KEY)) {
            n = 1;
        } else {
            throw new SAXException("Invalid package type:" + string);
        }
        return n;
    }

    private void handleInfoElement(Attributes attributes) throws SAXException {
        String string = attributes.getValue("name");
        String string2 = attributes.getValue("value");
        if (string == null || string2 == null) {
            throw new SAXException("Info element must have both name and value.");
        }
        this.m_current.addProperty(string, string2);
    }

    private void handleFileElement(Attributes attributes) throws SAXException {
        block5: {
            String string = attributes.getValue("name");
            String string2 = attributes.getValue("value");
            String string3 = attributes.getValue(ATTR_FILE_VALUE_EXTERNAL);
            if (string == null) {
                throw new SAXException("File element must have a name");
            }
            try {
                if (string2 != null) {
                    this.m_current.addFile(string, string2.getBytes("UTF8"));
                    break block5;
                }
                if (string3 != null) {
                    byte[] byArray = FileUtil.loadAsBuffer(string3);
                    this.m_current.addFile(string3, byArray);
                    break block5;
                }
                throw new SAXException("File element must have either 'value' or 'valueFromFile'");
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
    }

    private String getElementName(String string, String string2) {
        String string3 = string.intern();
        if (string3 == "") {
            string3 = string2.intern();
        }
        return string3;
    }

    private final String getValue(Attributes attributes, String string, String string2) {
        String string3 = attributes.getValue(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    private final String getValue(Attributes attributes, String string) {
        return this.getValue(attributes, string, "");
    }
}

