/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.core.util;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.misc.BASE64Encoder;

public class CertUtil {
    public static final String ALG_SECURE_RANDOM = "SHA1PRNG";
    public static final String ALG_KEY = "RSA";
    public static final String ALG_CERT_SIG = "SHA1WithRSA";
    public static final int KEY_LEN = 1024;

    public static final KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALG_KEY);
        keyPairGenerator.initialize(1024, CertUtil.getSecureRandom());
        return keyPairGenerator.genKeyPair();
    }

    public static X509Certificate generateSelfSignedCert(String string, KeyPair keyPair, long l) throws IOException, SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        X509Name x509Name = new X509Name(true, string);
        x509V3CertificateGenerator.setSerialNumber(CertUtil.createCertSerial());
        CertUtil.setValidityPeriod(x509V3CertificateGenerator, l);
        x509V3CertificateGenerator.setSignatureAlgorithm(ALG_CERT_SIG);
        x509V3CertificateGenerator.setSubjectDN(x509Name);
        x509V3CertificateGenerator.setIssuerDN(x509Name);
        x509V3CertificateGenerator.setPublicKey(keyPair.getPublic());
        CertUtil.addBasicConstraints(x509V3CertificateGenerator, true);
        CertUtil.addPublicKeyInfo(x509V3CertificateGenerator, keyPair.getPublic(), keyPair.getPublic());
        return x509V3CertificateGenerator.generateX509Certificate(keyPair.getPrivate());
    }

    public static X509Certificate generateSignedCert(String string, KeyPair keyPair, KeyPair keyPair2, X509Certificate x509Certificate, long l) throws IOException, SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        X509Name x509Name = new X509Name(true, string);
        X509Name x509Name2 = new X509Name(false, x509Certificate.getSubjectDN().getName());
        x509V3CertificateGenerator.setSerialNumber(CertUtil.createCertSerial());
        CertUtil.setValidityPeriod(x509V3CertificateGenerator, l);
        x509V3CertificateGenerator.setSignatureAlgorithm(ALG_CERT_SIG);
        x509V3CertificateGenerator.setSubjectDN(x509Name);
        x509V3CertificateGenerator.setIssuerDN(x509Name2);
        x509V3CertificateGenerator.setPublicKey(keyPair.getPublic());
        CertUtil.addBasicConstraints(x509V3CertificateGenerator, false);
        CertUtil.addPublicKeyInfo(x509V3CertificateGenerator, keyPair.getPublic(), keyPair2.getPublic());
        return x509V3CertificateGenerator.generateX509Certificate(keyPair2.getPrivate());
    }

    public static String makePEM(X509Certificate x509Certificate) throws CertificateEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = new BASE64Encoder().encode(x509Certificate.getEncoded()).trim();
        stringBuffer.append("-----BEGIN CERTIFICATE-----\n");
        stringBuffer.append(string).append("\n");
        stringBuffer.append("-----END CERTIFICATE-----\n");
        return stringBuffer.toString();
    }

    public static String makePEM(PrivateKey privateKey) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = new BASE64Encoder().encode(privateKey.getEncoded());
        stringBuffer.append("-----BEGIN PRIVATE KEY-----\n");
        stringBuffer.append(string).append("\n");
        stringBuffer.append("-----END PRIVATE KEY-----\n");
        return stringBuffer.toString();
    }

    public static void writeToKeystore(X509Certificate x509Certificate, KeyPair keyPair, Certificate[] certificateArray, String string) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        keyStore.setCertificateEntry("caCert", x509Certificate);
        keyStore.setKeyEntry("myKey", keyPair.getPrivate(), "snowcap".toCharArray(), certificateArray);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        keyStore.store(fileOutputStream, "snowcap".toCharArray());
    }

    private static final void addBasicConstraints(X509V3CertificateGenerator x509V3CertificateGenerator, boolean bl) {
        x509V3CertificateGenerator.addExtension(X509Extensions.BasicConstraints.getId(), true, (DEREncodable)new BasicConstraints(bl));
    }

    private static final void addPublicKeyInfo(X509V3CertificateGenerator x509V3CertificateGenerator, PublicKey publicKey, PublicKey publicKey2) throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = CertUtil.createPublicKeyInfo(publicKey);
        SubjectPublicKeyInfo subjectPublicKeyInfo2 = CertUtil.createPublicKeyInfo(publicKey2);
        x509V3CertificateGenerator.addExtension(X509Extensions.SubjectKeyIdentifier.getId(), false, (DEREncodable)new SubjectKeyIdentifier(subjectPublicKeyInfo));
        x509V3CertificateGenerator.addExtension(X509Extensions.AuthorityKeyIdentifier.getId(), false, (DEREncodable)new AuthorityKeyIdentifier(subjectPublicKeyInfo2));
    }

    private static void setValidityPeriod(X509V3CertificateGenerator x509V3CertificateGenerator, long l) {
        long l2 = l * 24L * 60L * 60L * 1000L;
        long l3 = 0L;
        long l4 = System.currentTimeMillis() + l2;
        x509V3CertificateGenerator.setNotBefore(new Date(l3));
        x509V3CertificateGenerator.setNotAfter(new Date(l4));
    }

    private static final BigInteger createCertSerial() throws NoSuchAlgorithmException {
        byte[] byArray = new byte[8];
        CertUtil.getSecureRandom().nextBytes(byArray);
        return new BigInteger(byArray).abs();
    }

    private static final SubjectPublicKeyInfo createPublicKeyInfo(PublicKey publicKey) throws IOException {
        return new SubjectPublicKeyInfo((ASN1Sequence)new DERInputStream((InputStream)new ByteArrayInputStream(publicKey.getEncoded())).readObject());
    }

    private static final SecureRandom getSecureRandom() throws NoSuchAlgorithmException {
        return SecureRandom.getInstance(ALG_SECURE_RANDOM);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.insertProviderAt((Provider)new BouncyCastleProvider(), 0);
        }
    }
}

