/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.action.concrete;

import com.mcafee.epo.compliance.action.Action;
import com.mcafee.epo.compliance.action.ActionContext;
import com.mcafee.epo.compliance.action.ActionEnvironment;
import com.mcafee.epo.compliance.action.ActionInvoker;
import com.mcafee.epo.compliance.db.ActionStatus;
import com.mcafee.epo.compliance.db.Host;
import com.mcafee.epo.compliance.db.SnowcapDatabaseObjectTestBase;
import com.mcafee.epo.compliance.db.action.ActionFactory;
import com.mcafee.epo.compliance.event.EventFactory;
import com.mcafee.epo.compliance.event.concrete.UserRequestEvent;
import com.mcafee.epo.compliance.server.ActionEnvironmentTestImpl;

public class ActionTestBase
extends SnowcapDatabaseObjectTestBase {
    private ActionFactory m_factory;

    public ActionFactory getActionFactory() {
        return this.m_factory;
    }

    public ActionTestBase(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        super.setUp();
        ActionEnvironment.setInstance(new ActionEnvironmentTestImpl());
        this.m_factory = new ActionFactory(this.m_con);
    }

    protected ActionStatus invokeHostAction(Host host, Action action) throws Exception {
        UserRequestEvent userRequestEvent = EventFactory.createUserRequestEvent(this.m_con, null, null, null);
        ActionContext actionContext = userRequestEvent.createActionContext();
        actionContext.setHost(host);
        return this.invokeAction(action, actionContext);
    }

    protected ActionStatus invokeAction(Action action, ActionContext actionContext) throws Exception {
        this.cleanupConnection();
        ActionStatus actionStatus = ActionInvoker.invokeAction(action, actionContext);
        this.initConnection();
        return actionStatus;
    }
}

