/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.client;

import com.mcafee.epo.compliance.client.CmdLineUtil;
import com.mcafee.epo.compliance.client.MessageUtil;
import com.mcafee.epo.compliance.message.TestData;
import com.mcafee.epo.compliance.util.Timer;
import com.mcafee.epo.compliance.util.thread.TestThread;
import com.mcafee.epo.compliance.util.thread.TestThreadGroup;
import java.net.URL;
import java.util.Date;

public class SimSensor {
    private long m_delay;
    private int m_hostsPerMessage;
    private int m_numIterations;
    private int m_numThreads;
    private URL m_serverURL;
    private long m_reportingPeriod;
    private long m_aggregationTime;
    private int m_hostsPerSubnet;

    public static void main(String[] stringArray) throws Exception {
        SimSensor simSensor = new SimSensor();
        simSensor.init(stringArray);
        simSensor.run();
    }

    public void run() throws Exception {
        System.out.println("Creating " + this.m_numThreads + " simulated sensors...");
        TestThread[] testThreadArray = new TestThread[this.m_numThreads];
        int n = 0;
        while (n < testThreadArray.length) {
            testThreadArray[n] = new WorkerThread();
            ++n;
        }
        TestThreadGroup testThreadGroup = new TestThreadGroup(testThreadArray, "SimSensor");
        testThreadGroup.start();
        if (this.m_numIterations < 0) {
            System.out.println("Running indefinitely; ctrl-c to exit test.");
        } else {
            System.out.println("Running " + this.m_numIterations + " iterations.");
        }
        testThreadGroup.join();
        System.out.println("Done.");
    }

    private static void showUsageAndExit() {
        System.out.println("Usage: SimSensor num-iterations server-url num-threads reporting-period agg-time hosts-per-subnet [keystore password]");
        System.out.println("where:");
        System.out.println("  num-iterations   : number of times each sensor should run through its set of hosts; -1 means forever.");
        System.out.println("  server-url       : server URL to post messages to");
        System.out.println("  num-threads      : number of event-sending threads to spawn. Each thread simulates a single sensor");
        System.out.println("  reporting-period : How often a sensore reports on a given host, in seconds. AKA 'Host Filter Timeout' in the sensor.");
        System.out.println("  agg-time         : Aggregation time, in seconds. Sensor will not send events any more often than once per this time value.");
        System.out.println("  hosts-per-subnet : How many hosts should each thread report on in each reporting period?");
        System.out.println("  keystore         : keystore to use with SSL. If omitted, SSL won't work. No need to specify if not using SSL.");
        System.out.println("  password         : keystore password");
        System.exit(-1);
    }

    public void init(String[] stringArray) throws Exception {
        if (stringArray.length < 5) {
            SimSensor.showUsageAndExit();
        }
        this.m_numIterations = CmdLineUtil.getArg(stringArray, 0, -1);
        this.m_serverURL = new URL(CmdLineUtil.getArg(stringArray, 1, "http://localhost:8080/compliance/engine"));
        this.m_numThreads = CmdLineUtil.getArg(stringArray, 2, 8);
        this.m_reportingPeriod = CmdLineUtil.getArg(stringArray, 3, 3600) * 1000;
        this.m_aggregationTime = CmdLineUtil.getArg(stringArray, 4, 0) * 1000;
        this.m_hostsPerSubnet = CmdLineUtil.getArg(stringArray, 5, 255);
        String string = CmdLineUtil.getArg(stringArray, 6, null);
        String string2 = CmdLineUtil.getArg(stringArray, 7, "");
        if (string != null) {
            MessageUtil.initSSL(string, string2);
        }
        if (this.m_aggregationTime <= 0L) {
            this.m_delay = this.m_reportingPeriod / (long)this.m_hostsPerSubnet;
            this.m_hostsPerMessage = 1;
        } else {
            this.m_delay = this.m_aggregationTime;
            this.m_hostsPerMessage = (int)(this.m_aggregationTime * (long)this.m_hostsPerSubnet / this.m_reportingPeriod);
        }
        System.out.println("Each sensor will send a message with " + this.m_hostsPerMessage + " hosts every " + this.m_delay / 1000L + " seconds.");
    }

    public class WorkerThread
    extends TestThread {
        private String[] m_messages = null;
        int m_nextIndex = 0;
        private int m_curIteration = 0;
        private Timer m_timer = new Timer();
        private long m_totalTime = 0L;
        private int m_numMsgsSent = 0;
        private long m_nextDelay = 0L;

        public WorkerThread() throws Exception {
            this.m_messages = TestData.createTestMessages(SimSensor.this.m_hostsPerSubnet / SimSensor.this.m_hostsPerMessage, SimSensor.this.m_hostsPerMessage, 1, 1, 1);
            this.m_nextDelay = (long)(Math.random() * (double)SimSensor.this.m_delay);
        }

        public boolean doTask() throws Exception {
            Thread.sleep(this.m_nextDelay);
            this.m_timer.start();
            MessageUtil.sendEvent(this.m_messages[this.m_nextIndex], SimSensor.this.m_serverURL);
            long l = this.m_timer.elapsed();
            this.m_totalTime += l;
            ++this.m_numMsgsSent;
            this.m_nextDelay = SimSensor.this.m_delay - l;
            if (this.m_nextDelay < 0L) {
                this.m_nextDelay = 0L;
            }
            ++this.m_nextIndex;
            if (this.m_nextIndex >= this.m_messages.length) {
                this.m_nextIndex = 0;
                ++this.m_curIteration;
                System.out.println(new Date() + " [" + this.m_curIteration + "] " + this.m_numMsgsSent + " messages sent; avg send time: " + (float)this.m_totalTime / (float)this.m_numMsgsSent + " ms. (send time per host: " + (float)this.m_totalTime / (float)SimSensor.this.m_hostsPerSubnet + " ms)");
                this.m_numMsgsSent = 0;
                this.m_totalTime = 0L;
                if (SimSensor.this.m_numIterations > 0 && this.m_curIteration >= SimSensor.this.m_numIterations) {
                    return false;
                }
            }
            return true;
        }
    }
}

