/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.db;

import com.mcafee.epo.common.util.IPFormatException;
import com.mcafee.epo.common.util.IPUtil;
import com.mcafee.epo.compliance.util.Resource;
import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.core.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;

public class Network
extends DatabaseObject {
    public static final int COL_ID = 1;
    public static final int COL_NETWORK_NAME = 2;
    public static final int COL_SUBNET = 3;
    public static final int COL_NET_ADDR = 4;
    public static final int COL_COVERED = 5;
    public static final int COL_ADDRESS_NUM = 6;
    public static final int NUM_COLUMNS = 6;
    public static final int PROP_NUM_SENSORS = 7;
    public static final int PROP_LAST_COMM = 8;
    public static final int PROP_STATUS = 9;
    public static final int PROP_ADDRESS_AND_MASK = 10;
    public static final int NUM_PROPERTIES = 10;
    public static final String[] PROPERTY_NAMES = new String[]{"", "NetworkId", "NetworkName", "SubnetMask", "NetworkAddress", "Covered", "NetworkAddressNum", "NumSensorsCalculated", "LastComTimeCalculated", "NetworkStatus", "AddressAndMask"};
    public static final int MAX_LEN_NAME = 255;
    public static final int MAX_LEN_SUBNET = 25;
    public static final int MAX_LEN_NET_ADDR = 25;
    public static final int INVALID_ID = -1;
    private int m_id = -1;
    private String m_networkName;
    private String m_subnetMask;
    private String m_networkAddress;
    private boolean m_covered = true;
    private int m_addressNum;
    private int m_numSensorsCalculated = 0;
    private Timestamp m_lastComTimeCalculated = null;
    private int m_status = -1;
    static /* synthetic */ Class class$com$mcafee$epo$compliance$db$Network;

    public Network() {
        this("", "", "");
    }

    public Network(String string, String string2, String string3) {
        this.m_networkName = string;
        this.setNetworkAddress(string2);
        this.m_subnetMask = string3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append(Resource.getString("network_subnet")).append(this.m_subnetMask).append(string);
        stringBuffer.append(Resource.getString("network_netaddr")).append(this.m_networkAddress).append(string);
        return stringBuffer.toString();
    }

    public static final Network[] getByQuery(Connection connection, String string) throws SQLException {
        return Network.getByQuery(connection, string, 1, -1);
    }

    public static final Network[] getByQuery(Connection connection, String string, int n, int n2) throws SQLException {
        Vector vector = DatabaseObject.getByQuery((Connection)connection, (String)string, (Class)(class$com$mcafee$epo$compliance$db$Network == null ? (class$com$mcafee$epo$compliance$db$Network = Network.class$("com.mcafee.epo.compliance.db.Network")) : class$com$mcafee$epo$compliance$db$Network), (int)n, (int)n2);
        Network[] networkArray = new Network[]{};
        networkArray = vector.toArray(networkArray);
        return networkArray;
    }

    public static final Network getByID(Connection connection, int n) throws SQLException {
        Network[] networkArray = Network.getByQuery(connection, "select * from Networks where NetworkID = '" + n + "'");
        if (networkArray.length == 0) {
            return null;
        }
        if (networkArray.length > 1) {
            throw new SQLException("Internal error: getNetworkByID() returned >1 row!");
        }
        Network network = networkArray[0];
        return network;
    }

    public static final Network getBySubnetInfo(Connection connection, String string, String string2) throws SQLException {
        Network[] networkArray = Network.getByQuery(connection, "select * from Networks where NetworkAddress = '" + string + "' and SubnetMask='" + string2 + "'");
        if (networkArray.length == 0) {
            return null;
        }
        if (networkArray.length > 1) {
            throw new SQLException("Internal error: getBySubnetInfo() returned >1 row!");
        }
        Network network = networkArray[0];
        return network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int updateCoveredStatus(Connection connection, int n, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = null;
        int n2 = 0;
        try {
            preparedStatement = connection.prepareStatement("update Networks set Covered=? where NetworkID=?");
            preparedStatement.setBoolean(1, bl);
            preparedStatement.setInt(2, n);
            n2 = preparedStatement.executeUpdate();
            Object var6_5 = null;
            if (preparedStatement == null) return n2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
        return n2;
    }

    public String getInsertSql() {
        return "insert into Networks values (?,?,?,?,?)";
    }

    public String getUpdateSql() {
        return "update Networks set NetworkName=?, SubnetMask=?, NetworkAddress=?, Covered=?, NetworkAddressNum=? where NetworkID=? ";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)1, (String)this.m_networkName, (int)255);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)2, (String)this.m_subnetMask, (int)25);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)3, (String)this.m_networkAddress, (int)25);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)4, (boolean)this.m_covered);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)5, (int)this.m_addressNum);
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)6, (int)this.m_id);
    }

    public String getUniqueQuerySql() {
        return "select * from Networks where (NetworkAddress = ? and SubnetMask = ?)";
    }

    public String getUniqueIdSql() {
        return "select NetworkID from Networks where (NetworkAddress = ? and SubnetMask = ?)";
    }

    public void prepareUniqueQuery(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setString(1, this.getNetworkAddress());
        preparedStatement.setString(2, this.getSubnetMask());
    }

    public void setUniqueID(int n) throws SQLException {
        this.setId(n);
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        this.m_id = resultSet.getInt(1);
        this.m_networkName = resultSet.getString(2);
        this.m_subnetMask = resultSet.getString(3);
        this.m_networkAddress = resultSet.getString(4);
        this.m_covered = resultSet.getBoolean(5);
        this.m_addressNum = resultSet.getInt(6);
        if (resultSet.getMetaData().getColumnCount() == 8) {
            this.m_numSensorsCalculated = resultSet.getInt(7);
            this.m_lastComTimeCalculated = resultSet.getTimestamp(8);
        } else {
            this.m_numSensorsCalculated = 0;
            this.m_lastComTimeCalculated = null;
        }
    }

    public int getNumColumns() {
        return 6;
    }

    public int getNumProperties() {
        return 10;
    }

    public String getPropertyName(int n) {
        return PROPERTY_NAMES[n];
    }

    public final void calculateProperties(long l, long l2, boolean bl) {
        this.m_status = bl ? 2 : (this.m_numSensorsCalculated < 1 || this.m_lastComTimeCalculated == null || this.m_lastComTimeCalculated.getTime() + l2 < l ? 1 : 0);
    }

    public int getId() {
        return this.m_id;
    }

    public void setId(int n) {
        this.m_id = n;
    }

    public int getNetworkId() {
        return this.m_id;
    }

    public void setNetworkId(int n) {
        this.m_id = n;
    }

    public String getNetworkName() {
        return this.m_networkName;
    }

    public void setNetworkName(String string) {
        this.m_networkName = string;
    }

    public String getSubnetMask() {
        return this.m_subnetMask;
    }

    public void setSubnetMask(String string) {
        this.m_subnetMask = string;
    }

    public String getNetworkAddress() {
        return this.m_networkAddress;
    }

    public void setNetworkAddress(String string) {
        this.m_networkAddress = string;
        this.setNetworkAddressNum(string);
    }

    public String getSubnetAddress() {
        return this.m_networkAddress;
    }

    public void setSubnetAddress(String string) {
        this.m_networkAddress = string;
    }

    public int getNumSensorsCalculated() {
        return this.m_numSensorsCalculated;
    }

    public void setNumSensorsCalculated(int n) {
        this.m_numSensorsCalculated = n;
    }

    public Timestamp getLastComTimeCalculated() {
        return this.m_lastComTimeCalculated;
    }

    public void setLastComTimeCalculated(Timestamp timestamp) {
        this.m_lastComTimeCalculated = timestamp;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setStatus(int n) {
        this.m_status = n;
    }

    public int getNetworkStatus() {
        return this.m_status;
    }

    public void setNetworkStatus(int n) {
        this.m_status = n;
    }

    public String getAddressAndMask() {
        return this.m_networkAddress + StringUtil.getShortNetmask((String)this.m_subnetMask);
    }

    public boolean getCovered() {
        return this.m_covered;
    }

    public void setCovered(boolean bl) {
        this.m_covered = bl;
    }

    public int getNetworkAddressNum() {
        return this.m_addressNum;
    }

    private void setNetworkAddressNum(String string) {
        try {
            this.m_addressNum = IPUtil.convert((String)string);
        }
        catch (IPFormatException iPFormatException) {
            this.m_addressNum = 0;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

