/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.db;

import com.mcafee.epo.common.ui.util.SessionUtil;
import com.mcafee.epo.compliance.db.SexpQueryUtil;
import com.mcafee.epo.compliance.ui.util.HostPropDisplay;
import com.mcafee.epo.compliance.ui.util.NetworkPropDisplay;
import com.mcafee.epo.core.condition.SexpException;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class QueryUtil {
    private static final Logger m_log;
    public static final int SUBNET_STATUS_MIN = 1;
    public static final int SUBNET_STATUS_ANY = 1;
    public static final int SUBNET_STATUS_NOT_MONITORED = 4;
    public static final int SUBNET_STATUS_MONITORED = 3;
    public static final int SUBNET_STATUS_FILTER = 2;
    public static final int SUBNET_STATUS_MAX = 4;
    public static String COUNT_COVERED_SUBNETS;
    public static String COUNT_UNCOVERED_SUBNETS;
    public static final int STATUS_MIN = 1;
    public static final int STATUS_ANY = 1;
    public static final int STATUS_FILTER = 2;
    public static final int STATUS_ROGUE = 3;
    public static final int STATUS_EXCEPTION = 4;
    public static final int STATUS_MANAGED = 5;
    public static final int STATUS_INACTIVE = 6;
    public static final int STATUS_MAX = 6;
    public static final int NETWORK_MIN = 1;
    public static final int NETWORK_ALL = 1;
    public static final int NETWORK_SINGLE = 2;
    public static final int NETWORK_MAX = 2;
    public static final int EVENTS_MIN = 1;
    public static final int EVENTS_ALL = 1;
    public static final int EVENTS_RMD = 2;
    public static final int EVENTS_UR = 3;
    public static final int EVENTS_SUNC = 4;
    public static final int EVENTS_APF = 5;
    public static final int EVENTS_SPF = 6;
    public static final int EVENTS_DISMISSED = 7;
    public static final int ACTIONS_MIN = 1;
    public static final int ACTIONS_ALL = 1;
    public static final int ACTIONS_DONE = 2;
    public static final int ACTIONS_IP = 3;
    public static final int ACTIONS_FAILED = 4;
    public static final int ACTIONS_PA = 5;
    public static final int ACTIONS_DS = 6;
    public static final int ACTIONS_ET = 7;
    public static final int ACTIONS_EXCEPT = 8;
    public static final int ACTIONS_DISMISSED = 9;
    public static final int ORDER_MIN = 1;
    public static final int ORDER_ASCENDING = 1;
    public static final int ORDER_DESCENDING = 2;
    public static final int ORDER_MAX = 2;
    static /* synthetic */ Class class$com$mcafee$epo$compliance$db$QueryUtil;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static final String makeHostQuery(Integer n, int n2, int n3, int n4, int n5, long l, String string) throws SexpException {
        if (!($assertionsDisabled || n3 >= 0 && n3 <= 29)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || n4 >= 1 && n3 <= 29)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || n2 >= 1 && n2 <= 6)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n5 != 1 && n5 != 2) {
            throw new AssertionError();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select * from Hosts");
        stringBuffer.append(" as H left join OUIs on H.OUI = OUIs.OUI ");
        stringBuffer.append(QueryUtil.makeHostWhereClause(n, n2, l, string));
        stringBuffer.append(" order by ");
        if (n3 != 0) {
            stringBuffer.append(n3).append(QueryUtil.getOrder(n5)).append(", ");
        }
        HostPropDisplay hostPropDisplay = new HostPropDisplay(null, null);
        stringBuffer.append(hostPropDisplay.getOrderByClause(n4, n5));
        return stringBuffer.toString();
    }

    public static final String makeHostWhereClause(Integer n, int n2, long l, String string) throws SexpException {
        StringBuffer stringBuffer = new StringBuffer();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis() - l);
        stringBuffer.append(" where Deleted=0");
        if (n != null) {
            stringBuffer.append(" and NetworkID=").append(n);
        }
        switch (n2) {
            case 4: {
                stringBuffer.append(" and Exception = 1");
                break;
            }
            case 6: {
                stringBuffer.append(" and Exception = 0 and (LastDetectTime is null or LastDetectTime < { ts '").append(timestamp).append("'})");
                break;
            }
            case 3: {
                stringBuffer.append(" and RogueType != 0 and Exception=0 and LastDetectTime > { ts '").append(timestamp).append("'}");
                break;
            }
            case 5: {
                stringBuffer.append(" and Exception = 0 and RogueType = 0 and LastDetectTime > { ts '").append(timestamp).append("'}");
                break;
            }
        }
        if (n2 == 2 && SessionUtil.isNonEmptyString((String)string)) {
            stringBuffer.append(" and").append(SexpQueryUtil.makeWhereSnippet(string, System.currentTimeMillis(), l));
        }
        return stringBuffer.toString();
    }

    public static final void appendSubnetWhereClause(StringBuffer stringBuffer, int n, long l, String string) throws SexpException {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis() - l);
        switch (n) {
            case 4: {
                stringBuffer.append(" where N.NetworkID not in (select distinct sen.NetworkID from Sensors as sen").append(" where sen.LastCommunicationTime > { ts '").append(timestamp).append("'}) ");
                break;
            }
            case 3: {
                stringBuffer.append(" where N.NetworkID in (select distinct sen.NetworkID from Sensors as sen").append(" where sen.LastCommunicationTime > { ts '").append(timestamp).append("'}) ");
                break;
            }
        }
        if (n == 2 && SessionUtil.isNonEmptyString((String)string)) {
            stringBuffer.append(" where ").append(SexpQueryUtil.makeWhereSnippet(string, System.currentTimeMillis(), l));
        }
    }

    public static final String makeSubnetQuery(String string, int n, int n2) {
        if (!($assertionsDisabled || n >= 1 && n <= 10)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 != 1 && n2 != 2) {
            throw new AssertionError();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select N.NetworkID, max(N.NetworkName), max(N.SubnetMask), ").append("max(N.NetworkAddress), max(N.Covered), max(N.NetworkAddressNum), count(S.SensorID), ").append("max(LastCommunicationTime) ").append("from Networks as N left join Sensors as S on N.NetworkID=S.NetworkID ");
        stringBuffer.append(string);
        stringBuffer.append(" group by N.NetworkID ");
        stringBuffer.append(" order by ");
        NetworkPropDisplay networkPropDisplay = new NetworkPropDisplay(null, null);
        stringBuffer.append(networkPropDisplay.getOrderByClause(n, n2));
        return stringBuffer.toString();
    }

    public static final String makeSubnetQuery(int n, int n2, int n3, long l, String string) throws SexpException {
        StringBuffer stringBuffer = new StringBuffer();
        QueryUtil.appendSubnetWhereClause(stringBuffer, n, l, string);
        return QueryUtil.makeSubnetQuery(stringBuffer.toString(), n2, n3);
    }

    public static final String makeSubnetWhereClause(int n, long l) throws SexpException {
        StringBuffer stringBuffer = new StringBuffer();
        QueryUtil.appendSubnetWhereClause(stringBuffer, n, l, null);
        return stringBuffer.toString();
    }

    public static final String getELQueryWhereClause(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" where ");
        if (n == 7) {
            stringBuffer.append(" E.Archive=1 ");
        } else {
            stringBuffer.append(" E.Archive!=1 ");
            switch (n) {
                case 2: {
                    stringBuffer.append(" AND E.EventType='").append(1).append("'");
                    break;
                }
                case 3: {
                    stringBuffer.append(" AND E.EventType='").append(2).append("'");
                    break;
                }
                case 5: {
                    stringBuffer.append(" AND E.EventType='").append(5).append("'");
                    break;
                }
                case 6: {
                    stringBuffer.append(" AND E.EventType='").append(4).append("'");
                    break;
                }
                case 4: {
                    stringBuffer.append(" AND E.EventType='").append(3).append("'");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static final String makeELQuery(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select E.EventLogId, E.CreateTime as CreateTime, E.EventType as EventType, E.SourceHostId as SourceHostId, E.SourceNetworkId as SourceNetworkId, E.SourceSensorId as SourceSensorId, E.Archive as Archive, E.ActionCount as ActionCount, H.FriendlyName as SourceHostName, N.NetworkAddress as SourceSubnetAddress, N.SubnetMask as SourceSubnetMask, S.SensorName as SensorName from EventLog as E left join Hosts as H on E.SourceHostId = H.HostId left join Networks as N on E.SourceNetworkId = N.NetworkID left join Sensors as S on E.SourceSensorId = S.SensorId ");
        stringBuffer.append(QueryUtil.getELQueryWhereClause(n));
        m_log.debug((Object)("EventLog query: " + stringBuffer.toString()));
        return stringBuffer.toString();
    }

    public static final String getActiveASWhereClause(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" where ");
        if (n == 9) {
            stringBuffer.append("A.Archive=1 ");
        } else {
            stringBuffer.append("A.Archive!=1 ");
            switch (n) {
                case 2: {
                    stringBuffer.append(" AND Status=0");
                    break;
                }
                case 3: {
                    stringBuffer.append(" AND (Status=-1 OR EndTime is null)");
                    break;
                }
                case 4: {
                    stringBuffer.append(" AND Status>0");
                    break;
                }
                case 5: {
                    stringBuffer.append(" AND A.ActionType='").append("actionstatus_agent_push").append("'");
                    break;
                }
                case 6: {
                    stringBuffer.append(" AND A.ActionType='").append("actionstatus_sensor_install").append("'");
                    break;
                }
                case 7: {
                    stringBuffer.append(" AND A.ActionType='").append("actionstatus_tool_run").append("'");
                    break;
                }
                case 8: {
                    stringBuffer.append(" AND (A.ActionType='").append("actionstatus_except_host").append("'").append(" OR A.ActionType='").append("actionstatus_unexcept_host").append("')");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static final String getActiveASListSQL(int n) {
        return "select A.*, E.EventType, E.CreateTime as EventLogTimestamp, H.FriendlyName as TargetHostName, N.SubnetMask as TargetSubnetMask, N.NetworkAddress as TargetNetworkAddress, S.SensorName as TargetSensorName from ActionStatus as A left join EventLog as E on A.EventLogId=E.EventLogId left join Hosts as H on A.TargetHostId=H.HostID left join Networks as N on A.TargetNetworkId=N.NetworkId left join Sensors as S on A.TargetSensorId=S.SensorId " + QueryUtil.getActiveASWhereClause(n);
    }

    public static final String getByEventLogIdSQL(int n) {
        String string = "select A.*, E.EventType as EventType, E.CreateTime as EventLogTimestamp, E.EventLogId as EventLogID  from ActionStatus as A right join EventLog as E on E.EventLogId=A.EventLogId " + QueryUtil.getByEventLogIdWhereClause(n, "A");
        return string;
    }

    public static final String getByEventLogIdWhereClause(int n, String string) {
        if (string == null) {
            return " where EventLogId='" + n + "' AND " + "Archive!=1";
        }
        return " where " + string + ".EventLogId='" + n + "' AND " + string + ".Archive!=1";
    }

    public static final String getJoinByHostIdSQL(int n) {
        return "select A.*, E.EventType as EventType, E.CreateTime as EventLogTimestamp, E.EventLogId as EventLogID from ActionStatus as A right join EventLog as E on E.EventLogId=A.EventLogId where (A.TargetHostId='" + n + "' OR E.SourceHostId='" + n + "') AND " + "E.Archive != 1 AND (A.Archive != 1 OR A.Archive IS NULL)";
    }

    public static final String getOrder(int n) {
        if (n == 2) {
            return " DESC";
        }
        return " ASC";
    }

    public static final void clearAllTables(Connection connection) throws SQLException {
        DatabaseUtil.clearTable((Connection)connection, (String)"ActionStatus");
        DatabaseUtil.clearTable((Connection)connection, (String)"EventLog");
        DatabaseUtil.clearTable((Connection)connection, (String)"Hosts");
        DatabaseUtil.clearTable((Connection)connection, (String)"Sensors");
        DatabaseUtil.clearTable((Connection)connection, (String)"Networks");
        DatabaseUtil.clearTable((Connection)connection, (String)"ActionSettings");
        DatabaseUtil.clearTable((Connection)connection, (String)"Actions");
        DatabaseUtil.clearTable((Connection)connection, (String)"Responses");
        DatabaseUtil.clearTable((Connection)connection, (String)"Contact");
        DatabaseUtil.clearTable((Connection)connection, (String)"Tools");
        DatabaseUtil.clearTable((Connection)connection, (String)"ActionStatus");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$mcafee$epo$compliance$db$QueryUtil == null ? (class$com$mcafee$epo$compliance$db$QueryUtil = QueryUtil.class$("com.mcafee.epo.compliance.db.QueryUtil")) : class$com$mcafee$epo$compliance$db$QueryUtil).desiredAssertionStatus();
        m_log = Logger.getLogger((Class)(class$com$mcafee$epo$compliance$db$QueryUtil == null ? (class$com$mcafee$epo$compliance$db$QueryUtil = QueryUtil.class$("com.mcafee.epo.compliance.db.QueryUtil")) : class$com$mcafee$epo$compliance$db$QueryUtil));
        COUNT_COVERED_SUBNETS = "select count(distinct n.NetworkID) from Networks as n ";
        COUNT_UNCOVERED_SUBNETS = "select count(distinct n.NetworkID) from Networks as n ";
    }
}

