/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.db;

import com.mcafee.epo.compliance.util.Resource;
import com.mcafee.epo.core.db.base.DatabaseObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;

public class Sensor
extends DatabaseObject {
    public static final int COL_ID = 1;
    public static final int COL_NETWORK_ID = 2;
    public static final int COL_MAC = 3;
    public static final int COL_SENSOR_NAME = 4;
    public static final int COL_IP_ADDRESS = 5;
    public static final int COL_OS_PLATFORM = 6;
    public static final int COL_OS_FAMILY = 7;
    public static final int COL_OS_VERSION = 8;
    public static final int COL_LAST_COMM_TIME = 9;
    public static final int COL_DOMAIN = 10;
    public static final int COL_SID = 11;
    public static final int COL_AGENT_GUID = 12;
    public static final int NUM_COLUMNS = 12;
    public static final int NUM_PROPERTIES = 12;
    public static final String[] PROPERTY_NAMES = new String[]{"", "Id", "NetworkID", "MAC", "SensorName", "IpAddress", "OSPlatform", "OSFamily", "OSVersion", "LastCommunicationTime", "Domain", "Sid", "AgentGUID"};
    public static final String DEFAULT_MAC = "000000000000";
    public static final int MAX_LEN_MAC = 12;
    public static final int MAX_LEN_NAME = 255;
    public static final int MAX_LEN_IP_ADDR = 50;
    public static final int MAX_LEN_OS_PLATFORM = 25;
    public static final int MAX_LEN_OS_FAMILY = 25;
    public static final int MAX_LEN_OS_VERSION = 25;
    public static final int MAX_LEN_DOMAIN = 16;
    public static final int MAX_LEN_SID = 48;
    public static final int MAX_LEN_AGENT_GUID = 36;
    public static final int INVALID_ID = -1;
    private int m_id;
    private int m_networkID;
    private String m_MAC;
    private String m_sensorName;
    private String m_IpAddress;
    private String m_OSPlatform;
    private String m_OSFamily;
    private String m_OSVersion;
    private String m_domain = "";
    private String m_sid = "";
    private String m_agentGUID = "";
    private Timestamp m_lastCommunicationTime;
    static /* synthetic */ Class class$com$mcafee$epo$compliance$db$Sensor;

    public Sensor() {
        this(-1, DEFAULT_MAC, "", "", "", "", "", new Timestamp(0L), "", "", "");
    }

    public Sensor(int n, String string, String string2, String string3, String string4, String string5, String string6, Timestamp timestamp, String string7, String string8, String string9) {
        this.setId(-1);
        this.setNetworkID(n);
        this.setMAC(string);
        this.setSensorName(string2);
        this.setIpAddress(string3);
        this.setOSFamily(string5);
        this.setOSPlatform(string4);
        this.setOSVersion(string6);
        this.setLastCommunicationTime(timestamp);
        this.setDomain(string7);
        this.setSid(string8);
        this.setAgentGUID(string9);
    }

    public static final Sensor[] getByQuery(Connection connection, String string) throws SQLException {
        return Sensor.getByQuery(connection, string, 1, -1);
    }

    public static final Sensor[] getByQuery(Connection connection, String string, int n, int n2) throws SQLException {
        Vector vector = DatabaseObject.getByQuery((Connection)connection, (String)string, (Class)(class$com$mcafee$epo$compliance$db$Sensor == null ? (class$com$mcafee$epo$compliance$db$Sensor = Sensor.class$("com.mcafee.epo.compliance.db.Sensor")) : class$com$mcafee$epo$compliance$db$Sensor), (int)n, (int)n2);
        Sensor[] sensorArray = new Sensor[]{};
        sensorArray = vector.toArray(sensorArray);
        return sensorArray;
    }

    public static final Sensor getByID(Connection connection, int n) throws SQLException {
        Sensor[] sensorArray = Sensor.getByQuery(connection, "select * from Sensors where SensorID = " + n);
        if (sensorArray.length == 0) {
            return null;
        }
        return sensorArray[0];
    }

    public static final Sensor[] getByNetworkID(Connection connection, int n) throws SQLException {
        Sensor[] sensorArray = Sensor.getByQuery(connection, "select * from Sensors where NetworkID = " + n);
        if (sensorArray.length == 0) {
            return null;
        }
        return sensorArray;
    }

    public String getInsertSql() {
        return "insert into Sensors values (?,?,?,?,?,?,?,?,?,?,?)";
    }

    public String getUpdateSql() {
        return "update Sensors set NetworkID=?, MAC=?, SensorName=?, IPAddress=?, OSPlatform=?, OSFamily=?, OSVersion=?, LastCommunicationTime=?, Domain=?, SID=?, AgentGUID=? where SensorID=? ";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)1, (int)this.m_networkID);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)2, (String)this.m_MAC, (int)12);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)3, (String)this.m_sensorName, (int)255);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)4, (String)this.m_IpAddress, (int)50);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)5, (String)this.m_OSPlatform, (int)25);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)6, (String)this.m_OSFamily, (int)25);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)7, (String)this.m_OSVersion, (int)25);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)8, (Timestamp)this.m_lastCommunicationTime);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)9, (String)this.m_domain, (int)16);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)10, (String)this.m_sid, (int)48);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)11, (String)this.m_agentGUID, (int)36);
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)12, (int)this.m_id);
    }

    public String getUniqueQuerySql() {
        return "select * from Sensors where MAC = ?";
    }

    public String getUniqueIdSql() {
        return "select SensorID from Sensors where MAC = ?";
    }

    public void prepareUniqueQuery(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setString(1, this.getMAC());
    }

    public void setUniqueID(int n) throws SQLException {
        this.setId(n);
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        this.m_id = resultSet.getInt(1);
        this.m_networkID = resultSet.getInt(2);
        this.m_MAC = resultSet.getString(3);
        this.m_sensorName = resultSet.getString(4);
        this.m_IpAddress = resultSet.getString(5);
        this.m_OSPlatform = resultSet.getString(6);
        this.m_OSFamily = resultSet.getString(7);
        this.m_OSVersion = resultSet.getString(8);
        this.m_lastCommunicationTime = resultSet.getTimestamp(9);
        this.m_domain = resultSet.getString(10);
        this.m_sid = resultSet.getString(11);
        this.m_agentGUID = resultSet.getString(12);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("NET ID:").append(this.m_networkID).append(string);
        stringBuffer.append("SENSOR NAME:").append(this.m_sensorName).append(string);
        stringBuffer.append("IP:").append(this.m_IpAddress).append(string);
        stringBuffer.append("MAC:").append(this.m_MAC).append(string);
        stringBuffer.append("OS:").append(this.m_OSFamily).append(" ").append(this.m_OSPlatform).append(" ").append(this.m_OSVersion).append(string);
        stringBuffer.append("LAST COM:").append(this.m_lastCommunicationTime).append(string);
        return stringBuffer.toString();
    }

    public int getNumColumns() {
        return 12;
    }

    public int getNumProperties() {
        return 12;
    }

    public String getPropertyName(int n) {
        return PROPERTY_NAMES[n];
    }

    public boolean isMacDefault() {
        return this.getMAC() == DEFAULT_MAC;
    }

    public void setOSInfo(String string, String string2, String string3) {
        this.setOSPlatform(string);
        this.setOSFamily(string2);
        this.setOSVersion(string3);
    }

    public int getId() {
        return this.m_id;
    }

    public void setId(int n) {
        this.m_id = n;
    }

    public int getNetworkID() {
        return this.m_networkID;
    }

    public void setNetworkID(int n) {
        this.m_networkID = n;
    }

    public Timestamp getLastCommunicationTime() {
        return this.m_lastCommunicationTime;
    }

    public void setLastCommunicationTime(Timestamp timestamp) {
        this.m_lastCommunicationTime = timestamp;
    }

    public String getMAC() {
        return this.m_MAC;
    }

    public void setMAC(String string) {
        if (string.length() != 12) {
            throw new IllegalArgumentException(Resource.formatString("host_template_wrong_mac_length", string));
        }
        this.m_MAC = string;
    }

    public String getSensorName() {
        return this.m_sensorName;
    }

    public void setSensorName(String string) {
        this.m_sensorName = string;
    }

    public String getIpAddress() {
        return this.m_IpAddress;
    }

    public void setIpAddress(String string) {
        this.m_IpAddress = string;
    }

    public String getOSPlatform() {
        return this.m_OSPlatform;
    }

    public void setOSPlatform(String string) {
        this.m_OSPlatform = string;
    }

    public String getOSFamily() {
        return this.m_OSFamily;
    }

    public void setOSFamily(String string) {
        this.m_OSFamily = string;
    }

    public String getOSVersion() {
        return this.m_OSVersion;
    }

    public void setOSVersion(String string) {
        this.m_OSVersion = string;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public void setDomain(String string) {
        this.m_domain = string;
    }

    public String getSid() {
        return this.m_sid;
    }

    public void setSid(String string) {
        this.m_sid = string;
    }

    public String getAgentGUID() {
        return this.m_agentGUID;
    }

    public void setAgentGUID(String string) {
        this.m_agentGUID = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

