/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.db;

import com.mcafee.epo.compliance.db.SchemaVersion;
import com.mcafee.epo.compliance.db.SchemaVersionException;
import com.mcafee.epo.core.db.base.Database;
import com.mcafee.epo.core.db.base.DatabaseTestSetup;
import com.mcafee.epo.core.db.base.Queries;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;

public class SnowcapDbTestSetup
extends DatabaseTestSetup {
    private Database m_epoDb = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$mcafee$epo$compliance$db$SnowcapDbTestSetup;

    public String getConfigFilename() {
        return "Unittest.properties";
    }

    public String getValidationQuery() {
        return Queries.VALIDATE_SNOWCAP_DB;
    }

    public String name() {
        return "compliance";
    }

    public void ensureAllConnectionsClosed(Test test, TestResult testResult) {
        super.ensureAllConnectionsClosed(test, testResult);
        this.ensureAllConnectionsClosed("EPO", this.getEpoDatabase(), test, testResult);
    }

    public boolean testSchemaVersion(Test test, TestResult testResult) {
        boolean bl = true;
        try {
            SchemaVersion.verifyDbSchemaVersion(this.getDatabase());
        }
        catch (SchemaVersionException schemaVersionException) {
            testResult.addFailure(test, new AssertionFailedError(schemaVersionException.toString()));
            bl = false;
        }
        return bl;
    }

    public String getEpoValidationQuery() {
        return Queries.VALIDATE_EPO_DB;
    }

    public Connection getEpoConnection() throws SQLException {
        if (!$assertionsDisabled && !this.isSetup()) {
            throw new AssertionError();
        }
        return this.m_epoDb.getConnection();
    }

    public Database getEpoDatabase() {
        if (!$assertionsDisabled && !this.isSetup()) {
            throw new AssertionError();
        }
        return this.m_epoDb;
    }

    public void additionalSetup(Properties properties) throws Exception {
        this.m_epoDb = new Database(properties, "epo", Queries.VALIDATE_EPO_DB);
    }

    protected void additionalCleanup() {
        if (this.m_epoDb != null) {
            this.m_epoDb.close();
            this.m_epoDb = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$mcafee$epo$compliance$db$SnowcapDbTestSetup == null ? (class$com$mcafee$epo$compliance$db$SnowcapDbTestSetup = SnowcapDbTestSetup.class$("com.mcafee.epo.compliance.db.SnowcapDbTestSetup")) : class$com$mcafee$epo$compliance$db$SnowcapDbTestSetup).desiredAssertionStatus();
    }
}

