/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.db.action;

import com.mcafee.epo.compliance.db.action.ActionFactory;
import com.mcafee.epo.compliance.db.action.ActionFactoryException;
import com.mcafee.epo.compliance.db.action.ActionPropertyException;
import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.util.BeanUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public abstract class ActionBase
extends DatabaseObject
implements Serializable {
    public static final int INVALID_ID = -1;
    public static final int COL_ID = 1;
    public static final int COL_RESPONSE_ID = 2;
    public static final int COL_TYPE = 3;
    public static final int NUM_COLUMNS = 3;
    public static final int COL_SETTING_ACTION_ID = 1;
    public static final int COL_SETTING_NAME = 2;
    public static final int COL_SETTING_VALUE = 3;
    public static final int NUM_SETTING_COLUMNS = 3;
    public static final String SQL_GET_SETTINGS = "select Name,Value from ActionSettings where ActionId = ?";
    public static final String SQL_GET_BY_ID = "select * from Actions where ActionId = ?";
    public static final String SQL_GET_BY_RESP = "select * from Actions where ResponseId = ?";
    public static final String SQL_INSERT_ACTION = "insert into Actions values (?,?)";
    public static final String SQL_INSERT_SETTING = "insert into ActionSettings values (?,?,?)";
    public static final String SQL_DELETE_SETTINGS = "delete from ActionSettings where ActionId = ?";
    public static final String SQL_DELETE_ACTION = "delete from Actions where ActionId = ?";
    private int m_id = -1;
    private Integer m_responseId = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$mcafee$epo$compliance$db$action$ActionBase;

    public static ActionBase getById(Connection connection, int n, ActionFactory actionFactory) throws SQLException, ActionFactoryException, ActionPropertyException {
        ActionBase actionBase = ActionBase.createActionById(connection, n, actionFactory);
        if (actionBase != null) {
            actionBase.loadSettings(connection);
        }
        return actionBase;
    }

    public static ActionBase[] getByResponseId(Connection connection, int n, ActionFactory actionFactory) throws SQLException, ActionFactoryException, ActionPropertyException {
        ActionBase[] actionBaseArray = ActionBase.createActionByResponseId(connection, n, actionFactory);
        int n2 = 0;
        while (n2 < actionBaseArray.length) {
            actionBaseArray[n2].loadSettings(connection);
            ++n2;
        }
        return actionBaseArray;
    }

    public static void deleteByResponseId(Connection connection, int n, ActionFactory actionFactory) throws SQLException, ActionFactoryException, ActionPropertyException {
        ActionBase[] actionBaseArray = ActionBase.getByResponseId(connection, n, actionFactory);
        int n2 = 0;
        while (n2 < actionBaseArray.length) {
            actionBaseArray[n2].delete(connection);
            ++n2;
        }
    }

    public static void deleteByActionId(Connection connection, int n, ActionFactory actionFactory) throws SQLException, ActionFactoryException, ActionPropertyException {
        ActionBase actionBase = ActionBase.getById(connection, n, actionFactory);
        if (actionBase != null) {
            actionBase.delete(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActionBase[] getPreConfiguredActions(Connection connection, ActionFactory actionFactory) throws SQLException, ActionFactoryException, IllegalAccessException, InvocationTargetException, ActionPropertyException {
        ActionBase[] actionBaseArray = new ActionBase[]{};
        Vector<ActionBase> vector = new Vector<ActionBase>();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select * from Actions where ResponseId is null");
            while (resultSet.next()) {
                String string = resultSet.getString("Type");
                ActionBase actionBase = actionFactory.create(string);
                BeanUtil.initBean((ResultSet)resultSet, (Object)actionBase);
                actionBase.loadSettings(connection);
                vector.add(actionBase);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            DatabaseUtil.close((Statement)statement);
            throw throwable;
        }
        DatabaseUtil.close((Statement)statement);
        return vector.toArray(actionBaseArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        try {
            preparedStatement = connection.prepareStatement(SQL_INSERT_ACTION);
            if (this.m_responseId != null) {
                preparedStatement.setInt(1, this.m_responseId);
            } else {
                preparedStatement.setNull(1, 4);
            }
            preparedStatement.setString(2, this.getType());
            preparedStatement.executeUpdate();
            statement = connection.prepareStatement("select @@IDENTITY");
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                throw new SQLException("couldn't get id after Action insert!");
            }
            this.setId(resultSet.getInt(1));
            this.update(connection);
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public void update(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        try {
            preparedStatement = connection.prepareStatement(SQL_DELETE_SETTINGS);
            preparedStatement.setInt(1, this.m_id);
            preparedStatement.executeUpdate();
            statement = connection.prepareStatement(SQL_INSERT_SETTING);
            int n = 1;
            while (n <= this.getNumProperties()) {
                statement.setInt(1, this.m_id);
                statement.setString(2, this.getPropertyName(n));
                statement.setString(3, this.getPropertyAsString(n));
                statement.executeUpdate();
                ++n;
            }
        }
        catch (ActionPropertyException actionPropertyException) {
            throw new SQLException(actionPropertyException.getMessage());
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        try {
            preparedStatement = connection.prepareStatement(SQL_DELETE_SETTINGS);
            preparedStatement.setInt(1, this.m_id);
            preparedStatement.executeUpdate();
            statement = connection.prepareStatement(SQL_DELETE_ACTION);
            statement.setInt(1, this.m_id);
            statement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadSettings(Connection connection) throws SQLException, ActionPropertyException {
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = connection.prepareStatement(SQL_GET_SETTINGS);
                preparedStatement.setInt(1, this.m_id);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    this.setPropertyAsString(string, string2);
                }
            }
            catch (Exception exception) {
                throw new ActionPropertyException(exception);
            }
            Object var7_7 = null;
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    public abstract String getType();

    public abstract int getNumProperties();

    public abstract String getPropertyName(int var1);

    public abstract boolean showInActionList();

    public abstract boolean appliesToStatus(int var1);

    public String getInsertSql() {
        return "insert into Actions values(?,?)";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        if (this.getResponseId() == null) {
            preparedStatement.setNull(1, 4);
        } else {
            preparedStatement.setInt(1, this.getResponseId());
        }
        preparedStatement.setString(2, this.getType());
    }

    public String getUpdateSql() {
        return "update Actions set ResponseID=?, Type=? where ActionID=?";
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
        preparedStatement.setInt(3, this.getId());
    }

    public int getPropertyIndex(String string) throws ActionPropertyException {
        int n = 1;
        while (n <= this.getNumProperties()) {
            if (this.getPropertyName(n).equals(string)) {
                return n;
            }
            ++n;
        }
        throw new ActionPropertyException("Invalid proeprty name:" + string);
    }

    public String getPropertyAsString(int n) throws ActionPropertyException {
        try {
            return this.propToString(n, this.getProperty(n));
        }
        catch (Exception exception) {
            throw new ActionPropertyException(exception);
        }
    }

    public void setProperty(int n, Object object) throws ActionPropertyException {
        if (object == null) {
            return;
        }
        String string = "";
        try {
            if (!($assertionsDisabled || n > 0 && n <= this.getNumProperties())) {
                throw new AssertionError();
            }
            string = this.getPropertyName(n);
            Class<?> clazz = this.getClass();
            String string2 = "set" + string;
            Method method = clazz.getMethod(string2, object.getClass());
            Object object2 = method.invoke((Object)this, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ActionPropertyException("Error setting property:" + string + "(" + n + ")", exception);
        }
    }

    public void setProperty(String string, Object object) throws ActionPropertyException {
        this.setProperty(this.getPropertyIndex(string), object);
    }

    public void setPropertyAsString(int n, String string) throws ActionPropertyException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.setProperty(n, this.stringToProp(n, string));
    }

    public void setPropertyAsString(String string, String string2) throws ActionPropertyException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        this.setPropertyAsString(this.getPropertyIndex(string), string2);
    }

    protected String propToString(int n, Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    protected Object stringToProp(int n, String string) throws ActionPropertyException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object object = this.getProperty(n);
        if (object instanceof String) {
            return string;
        }
        if (object instanceof Integer) {
            return new Integer(Integer.parseInt(string));
        }
        if (object instanceof Boolean) {
            return Boolean.valueOf(string);
        }
        return string;
    }

    public int getId() {
        return this.m_id;
    }

    public void setId(int n) {
        this.m_id = n;
    }

    public void setUniqueID(int n) {
        this.setId(n);
    }

    public int getActionID() {
        return this.getId();
    }

    public void setActionID(int n) {
        this.setId(n);
    }

    private static final ActionBase createActionById(Connection connection, int n, ActionFactory actionFactory) throws SQLException, ActionFactoryException {
        ActionBase[] actionBaseArray = ActionBase.createActionsByQuery(connection, SQL_GET_BY_ID, n, actionFactory);
        if (actionBaseArray.length == 0) {
            return null;
        }
        return actionBaseArray[0];
    }

    private static final ActionBase[] createActionByResponseId(Connection connection, int n, ActionFactory actionFactory) throws SQLException, ActionFactoryException {
        return ActionBase.createActionsByQuery(connection, SQL_GET_BY_RESP, n, actionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ActionBase[] createActionsByQuery(Connection connection, String string, int n, ActionFactory actionFactory) throws SQLException, ActionFactoryException {
        ActionBase[] actionBaseArray;
        block3: {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setInt(1, n);
                ResultSet resultSet = preparedStatement.executeQuery();
                Vector<ActionBase> vector = new Vector<ActionBase>();
                while (resultSet.next()) {
                    int n2 = resultSet.getInt(1);
                    int n3 = resultSet.getInt(2);
                    String string2 = resultSet.getString(3);
                    ActionBase actionBase = actionFactory.create(string2);
                    actionBase.setId(n2);
                    actionBase.setResponseId(new Integer(n3));
                    vector.add(actionBase);
                }
                ActionBase[] actionBaseArray2 = new ActionBase[]{};
                actionBaseArray = vector.toArray(actionBaseArray2);
                Object var12_13 = null;
                if (preparedStatement == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var12_14 = null;
                    if (preparedStatement == null) break block4;
                    preparedStatement.close();
                }
                throw throwable;
            }
            preparedStatement.close();
        }
        return actionBaseArray;
    }

    public Integer getResponseId() {
        return this.m_responseId;
    }

    public void setResponseId(Integer n) {
        this.m_responseId = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$mcafee$epo$compliance$db$action$ActionBase == null ? (class$com$mcafee$epo$compliance$db$action$ActionBase = ActionBase.class$("com.mcafee.epo.compliance.db.action.ActionBase")) : class$com$mcafee$epo$compliance$db$action$ActionBase).desiredAssertionStatus();
    }
}

