/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.event;

import com.mcafee.epo.compliance.db.Parameterizer.ParamPropertyException;
import com.mcafee.epo.compliance.event.Event;
import com.mcafee.epo.core.condition.EvalContext;
import com.mcafee.epo.core.condition.EvaluationException;
import com.mcafee.epo.core.condition.Sexp;
import com.mcafee.epo.core.condition.SexpLong;
import com.mcafee.epo.core.condition.SexpString;
import java.sql.Timestamp;

public class EventEvalContext
implements EvalContext {
    private Event m_event = null;

    public EventEvalContext(Event event) {
        this.m_event = event;
    }

    public Sexp getPropertyValue(String string) throws EvaluationException {
        try {
            int n = this.m_event.getParamPropertyIndex(string);
            Object object = this.m_event.getParamProperty(n);
            if (object != null) {
                if (object instanceof Timestamp) {
                    return new SexpLong(((Timestamp)object).getTime());
                }
                if (object instanceof Integer) {
                    return new SexpLong((long)((Integer)object).intValue());
                }
                return new SexpString(object.toString());
            }
            return new SexpString("");
        }
        catch (ParamPropertyException paramPropertyException) {
            throw new EvaluationException("Invalid event property name:" + string);
        }
    }

    public long now() {
        return this.m_event.timestamp();
    }
}

