/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.message;

import com.mcafee.epo.compliance.db.Host;
import com.mcafee.epo.compliance.db.Network;
import com.mcafee.epo.compliance.db.Sensor;
import com.mcafee.epo.compliance.message.HostDetectedMessage;
import com.mcafee.epo.core.util.FileUtil;
import com.mcafee.epo.core.util.StringUtil;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Random;

public class TestData {
    public static String EXAMPLE_EVENT_FILE = "xml/example-event.xml";
    public static String MINIMAL_EVENT_FILE = "xml/minimal-event.xml";
    public static String EXAMPLE_START_MSG = "xml/example-msg-start.xml";
    public static String EXAMPLE_STOP_MSG = "xml/example-msg-stop.xml";
    public static String EVENT_TEMPLATE_FILENAME = "xml/event-template.xml";
    public static String SENSOR_TEMPLATE_FILENAME = "xml/sensor-template.xml";
    public static String HOST_TEMPLATE_FILENAME = "xml/host-template.xml";
    private static String m_xmlDoc = null;
    private static final char[] NAME_CHARACTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] HEX_CHARACTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    private static final Random m_rand = new Random(System.currentTimeMillis());

    public static String getTestEvent() throws IOException {
        if (m_xmlDoc == null) {
            m_xmlDoc = FileUtil.loadAsString((String)EXAMPLE_EVENT_FILE);
        }
        return m_xmlDoc;
    }

    public static final HostDetectedMessage[] createTestEvents(int n, int n2, int n3) throws Exception {
        Object object;
        String[] stringArray;
        Object object2;
        HostDetectedMessage[] hostDetectedMessageArray = new HostDetectedMessage[n];
        Sensor[] sensorArray = new Sensor[n2];
        Network[] networkArray = new Network[n2];
        int n4 = 0;
        while (n4 < n2) {
            Sensor sensor = new Sensor();
            object2 = new Network();
            sensorArray[n4] = sensor;
            networkArray[n4] = object2;
            ((Network)((Object)object2)).setNetworkAddress(TestData.randomIP());
            ((Network)((Object)object2)).setSubnetMask(TestData.randomIP());
            ((Network)((Object)object2)).setNetworkName(TestData.randomName());
            sensor.setIpAddress(((Network)((Object)object2)).getNetworkAddress());
            sensor.setLastCommunicationTime(new Timestamp(0L));
            sensor.setMAC(TestData.randomMAC());
            sensor.setSensorName(((Network)((Object)object2)).getNetworkName());
            stringArray = TestData.randomOSInfo();
            sensor.setOSInfo(stringArray[0], stringArray[1], stringArray[2]);
            ++n4;
        }
        int n5 = 0;
        while (n5 < n) {
            hostDetectedMessageArray[n5] = new HostDetectedMessage();
            object2 = hostDetectedMessageArray[n5];
            ((HostDetectedMessage)object2).setSensor(null);
            stringArray = new Host();
            ((HostDetectedMessage)object2).addHost((Host)stringArray);
            object = TestData.randomName();
            stringArray.setDnsName((String)object);
            stringArray.setNetbiosName((String)object);
            stringArray.setMAC(TestData.randomMAC());
            stringArray.setNetworkAddress(TestData.randomIP());
            String[] stringArray2 = TestData.randomOSInfo();
            stringArray.setOSInfo(stringArray2[0], stringArray2[1], stringArray2[2]);
            stringArray.setLastDetectTime(new Timestamp(0L));
            int n6 = 0;
            while (n6 < n3) {
                stringArray.addUser(TestData.randomName());
                ++n6;
            }
            ++n5;
        }
        int n7 = 0;
        while (n7 < n2) {
            int n8 = 0;
            while (hostDetectedMessageArray[n8 = m_rand.nextInt(n)].getSensor() != null) {
            }
            hostDetectedMessageArray[n8].setSensor(sensorArray[n7]);
            hostDetectedMessageArray[n8].setNetwork(networkArray[n7]);
            ++n7;
        }
        int n9 = 0;
        while (n9 < n) {
            object = hostDetectedMessageArray[n9];
            if (((HostDetectedMessage)object).getSensor() == null) {
                int n10 = m_rand.nextInt(n2);
                hostDetectedMessageArray[n9].setSensor(sensorArray[n10]);
                hostDetectedMessageArray[n9].setNetwork(networkArray[n10]);
            }
            ++n9;
        }
        return hostDetectedMessageArray;
    }

    public static final String[] createTestMessages(int n, int n2, int n3, int n4, int n5) throws Exception {
        int n6;
        Object object;
        String[] stringArray;
        String string = FileUtil.loadAsString((String)EVENT_TEMPLATE_FILENAME);
        String string2 = FileUtil.loadAsString((String)SENSOR_TEMPLATE_FILENAME);
        String string3 = FileUtil.loadAsString((String)HOST_TEMPLATE_FILENAME);
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        StringUtil.Map map = new StringUtil.Map(){

            public String get(String string) {
                String string2 = (String)hashMap.get(string);
                if (string2 == null) {
                    string2 = "";
                }
                return string2;
            }
        };
        String[] stringArray2 = new String[n4];
        String[] stringArray3 = new String[n4];
        int n7 = 0;
        while (n7 < n4) {
            stringArray2[n7] = TestData.randomIP();
            stringArray3[n7] = TestData.randomIP();
            ++n7;
        }
        String[] stringArray4 = new String[n3];
        int n8 = 0;
        int n9 = 0;
        while (n9 < n3) {
            stringArray = TestData.randomOSInfo();
            hashMap.put("sensor.nbname", TestData.randomName());
            hashMap.put("sensor.ip", TestData.randomIP());
            hashMap.put("sensor.os.platform", stringArray[0]);
            hashMap.put("sensor.os.family", stringArray[1]);
            hashMap.put("sensor.os.version", stringArray[2]);
            hashMap.put("sensor.nbcomment", TestData.randomName());
            hashMap.put("sensor.mac", TestData.randomMAC());
            hashMap.put("sensor.netmask", stringArray3[n8]);
            hashMap.put("sensor.netaddr", stringArray2[n8]);
            stringArray4[n9] = StringUtil.substitute((String)string2, (StringUtil.Map)map);
            if (++n8 >= n4) {
                n8 = 0;
            }
            ++n9;
        }
        stringArray = new String[n];
        int n10 = 0;
        while (n10 < n) {
            object = new StringBuffer();
            n6 = 0;
            while (n6 < n2) {
                String[] stringArray5 = TestData.randomOSInfo();
                String string4 = TestData.randomName();
                hashMap.put("host.detect.time", "2003-04-16T16:43:44.314-08:00");
                hashMap.put("host.name.nb", string4);
                hashMap.put("host.name.dns", string4);
                hashMap.put("host.os.platform", stringArray5[0]);
                hashMap.put("host.os.family", stringArray5[1]);
                hashMap.put("host.os.version", stringArray5[2]);
                hashMap.put("host.ip", TestData.randomIP());
                hashMap.put("host.mac", TestData.randomMAC());
                hashMap.put("host.nbcomment", TestData.randomName());
                StringBuffer stringBuffer = new StringBuffer();
                int n11 = 0;
                while (n11 < n5) {
                    stringBuffer.append("<User><Name>").append(TestData.randomName()).append("</Name></User>\n");
                    ++n11;
                }
                hashMap.put("host.users", stringBuffer.toString());
                ((StringBuffer)object).append(StringUtil.substitute((String)string3, (StringUtil.Map)map)).append("\n");
                ++n6;
            }
            stringArray[n10] = ((StringBuffer)object).toString();
            ++n10;
        }
        object = new String[n];
        n6 = 0;
        while (n6 < n3) {
            int n12 = 0;
            while (object[n12 = m_rand.nextInt(n)] != null) {
            }
            hashMap.put("event.create.time", "2003-04-16T16:43:45.000-08:00");
            hashMap.put("sensor", stringArray4[n6]);
            hashMap.put("hosts", stringArray[n12]);
            object[n12] = StringUtil.substitute((String)string, (StringUtil.Map)map);
            ++n6;
        }
        int n13 = 0;
        while (n13 < n) {
            if (object[n13] == null) {
                hashMap.put("event.create.time", "2003-04-16T16:43:45.000-08:00");
                hashMap.put("sensor", stringArray4[m_rand.nextInt(n3)]);
                hashMap.put("hosts", stringArray[n13]);
                object[n13] = StringUtil.substitute((String)string, (StringUtil.Map)map);
            }
            ++n13;
        }
        return object;
    }

    private static final String randomIP() {
        byte[] byArray = new byte[4];
        m_rand.nextBytes(byArray);
        return m_rand.nextInt(256) + "." + m_rand.nextInt(256) + "." + m_rand.nextInt(256) + "." + m_rand.nextInt(256);
    }

    private static final String randomName() {
        int n = m_rand.nextInt(10) + 3;
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(NAME_CHARACTERS[m_rand.nextInt(NAME_CHARACTERS.length)]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static final String randomMAC() {
        StringBuffer stringBuffer = new StringBuffer(12);
        int n = 0;
        while (n < 12) {
            stringBuffer.append(HEX_CHARACTERS[m_rand.nextInt(HEX_CHARACTERS.length)]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static final String[] randomOSInfo() {
        int n = m_rand.nextInt(5);
        switch (n) {
            case 0: {
                return new String[]{"Windows", "NT", "4.0 Workstation"};
            }
            case 1: {
                return new String[]{"Windows", "NT", "2000 Professional"};
            }
            case 2: {
                return new String[]{"Windows", "9x", "ME"};
            }
            case 3: {
                return new String[]{"Windows", "NT", "4.0 Server"};
            }
            case 4: {
                return new String[]{"Linux", "Redhat", "7.2"};
            }
        }
        return new String[]{"", "", ""};
    }
}

