/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.server;

import com.mcafee.epo.compliance.server.Server;
import com.mcafee.epo.compliance.server.ServerInitException;
import com.mcafee.epo.compliance.util.Resource;
import com.mcafee.epo.core.util.thread.FileBiff;
import com.mcafee.epo.core.util.thread.FileChangeListener;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ServerProperties
extends Properties
implements FileChangeListener {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$compliance$server$ServerProperties == null ? (class$com$mcafee$epo$compliance$server$ServerProperties = ServerProperties.class$("com.mcafee.epo.compliance.server.ServerProperties")) : class$com$mcafee$epo$compliance$server$ServerProperties));
    public static final String SERVER_CONFIG_FILENAME = "ComplianceServer.properties";
    private URL m_filename;
    private boolean m_init = false;
    static /* synthetic */ Class class$com$mcafee$epo$compliance$server$ServerProperties;

    private void findPropertiesFile() {
        this.m_filename = (class$com$mcafee$epo$compliance$server$ServerProperties == null ? (class$com$mcafee$epo$compliance$server$ServerProperties = ServerProperties.class$("com.mcafee.epo.compliance.server.ServerProperties")) : class$com$mcafee$epo$compliance$server$ServerProperties).getClassLoader().getResource(SERVER_CONFIG_FILENAME);
    }

    public void loadProperties() throws Exception {
        this.findPropertiesFile();
        if (this.m_filename != null) {
            m_log.info((Object)Resource.formatString("serverproperties_loading", this.m_filename.getFile()));
            InputStream inputStream = this.m_filename.openStream();
            if (inputStream != null) {
                this.load(inputStream);
                this.m_init = true;
            }
        }
        if (!this.m_init) {
            throw new ServerInitException(Resource.formatString("server_template_load_config_failed", SERVER_CONFIG_FILENAME));
        }
    }

    public void setupChangeListeners(FileBiff fileBiff) throws Exception {
        if (!this.m_init) {
            this.loadProperties();
        }
        fileBiff.addChangeListener(this.m_filename.getFile(), 1000L, (FileChangeListener)this);
    }

    public void onFileChanged(String string) {
        try {
            m_log.info((Object)Resource.getString("serverproperties_reloading"));
            this.loadProperties();
            Server.setGeneralProperties(this);
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.formatString("serverproperties_loadfailed", this.m_filename.getFile()), (Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

