/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.servlet;

import com.mcafee.epo.compliance.db.Host;
import com.mcafee.epo.compliance.message.HostDetectedMessage;
import com.mcafee.epo.compliance.message.MessageParser;
import com.mcafee.epo.compliance.rsd.ErrorHandler;
import com.mcafee.epo.compliance.rsd.MessageProcessor;
import com.mcafee.epo.compliance.server.Server;
import com.mcafee.epo.compliance.util.Resource;
import com.mcafee.epo.compliance.util.Timer;
import com.mcafee.epo.core.servlet.util.UserUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.cert.X509Certificate;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class MainServlet
extends HttpServlet {
    private static final Logger m_log = Logger.getLogger((String)(class$com$mcafee$epo$compliance$servlet$MainServlet == null ? (class$com$mcafee$epo$compliance$servlet$MainServlet = MainServlet.class$("com.mcafee.epo.compliance.servlet.MainServlet")) : class$com$mcafee$epo$compliance$servlet$MainServlet).getName());
    static /* synthetic */ Class class$com$mcafee$epo$compliance$servlet$MainServlet;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        printWriter.println("<html><head><title>");
        printWriter.println(Resource.getString("mainservlet_title", string));
        printWriter.println("</title></head><body><b>");
        printWriter.println(Resource.getString("mainservlet_rmd_system", string));
        printWriter.println("</b></body></html>");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        HostDetectedMessage hostDetectedMessage = null;
        Timer timer = null;
        long l = 0L;
        boolean bl = Server.profilingEnabled();
        if (!MainServlet.isRequestTrusted(httpServletRequest)) {
            String string = httpServletRequest.getRemoteAddr();
            if (string == null) {
                string = "";
            }
            m_log.error((Object)Resource.formatString("mainservlet_error_unauthenticated", string));
            httpServletResponse.sendError(401);
            return;
        }
        if (bl) {
            timer = new Timer();
            timer.start();
        }
        try {
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)"Starting to parse event from sensor...");
            }
            hostDetectedMessage = MessageParser.parseEvent((InputStream)httpServletRequest.getInputStream());
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)("Successfully parsed message from sensor:" + hostDetectedMessage.getSensor().getSensorName()));
            }
            if (Server.shouldLogAllEvents()) {
                m_log.debug((Object)"\n======================================================================\n");
                m_log.debug((Object)hostDetectedMessage.toString());
                m_log.debug((Object)"\n======================================================================\n");
            }
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.formatString("mainservlet_template_error_parsing_request", exception.toString()), (Throwable)exception);
            httpServletResponse.sendError(500);
            return;
        }
        if (bl) {
            l = timer.elapsed();
        }
        boolean bl2 = this.processEvent(hostDetectedMessage);
        if (this.shouldSensorBeActive(hostDetectedMessage)) {
            httpServletResponse.addHeader("ContinueOperation", "yes");
        } else {
            httpServletResponse.addHeader("ContinueOperation", "no");
        }
        httpServletResponse.setStatus(200);
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("Finished processing message from sensor:" + hostDetectedMessage.getSensor().getSensorName()));
        }
        if (bl) {
            long l2 = timer.elapsed();
            if (bl2) {
                Server.getStatistics().eventProcessed(hostDetectedMessage.getNumHosts(), l2, l2 - l);
                if (m_log.isDebugEnabled()) {
                    m_log.debug((Object)("Parsing time: " + l + ", Message processing time: " + (l2 - l)));
                }
            } else {
                Server.getStatistics().errorEvent(l2);
            }
        }
    }

    private static final boolean isRequestTrusted(HttpServletRequest httpServletRequest) {
        X509Certificate[] x509CertificateArray = (X509Certificate[])httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
        return x509CertificateArray != null && x509CertificateArray.length > 0 && x509CertificateArray[0].getSubjectDN().getName().equals("CN=RogueSystemSensor, OU=ePO, O=McAfee");
    }

    private boolean processEvent(HostDetectedMessage hostDetectedMessage) {
        ErrorHandlerImpl errorHandlerImpl = new ErrorHandlerImpl();
        int n = Server.numEventProcRetries();
        if (n < 0) {
            n = 0;
        }
        while (n >= 0) {
            errorHandlerImpl.clearErrors();
            MessageProcessor.instance().processEvent(hostDetectedMessage, Server.getDb(), Server.getEpoDb(), errorHandlerImpl);
            if (!errorHandlerImpl.hadErrors()) {
                return true;
            }
            m_log.warn((Object)Resource.getString("mainservlet_retrying_process_event"));
            --n;
        }
        return false;
    }

    private boolean shouldSensorBeActive(HostDetectedMessage hostDetectedMessage) {
        int n = hostDetectedMessage.getNetwork().getId();
        int n2 = hostDetectedMessage.getSensor().getId();
        long l = hostDetectedMessage.getSensor().getLastCommunicationTime().getTime();
        if (n == -1 || n2 == -1) {
            m_log.debug((Object)"Incoming message missing sensorID/networkID; asking sensor to be passive.");
            return false;
        }
        boolean bl = Server.getActiveSensorTable().processSensor(n, n2, l);
        if (bl) {
            m_log.debug((Object)("Asking sensor to be active :" + hostDetectedMessage.getSensor().getSensorName()));
        } else {
            m_log.debug((Object)("Asking sensor to be passive:" + hostDetectedMessage.getSensor().getSensorName()));
        }
        return bl;
    }

    public void init() throws ServletException {
        try {
            Server.init(this.getServletContext());
            m_log.info((Object)Resource.getString("mainservlet_init_complete"));
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.formatString("mainservlet_template_error_initializing", exception.getMessage()), (Throwable)exception);
            throw new ServletException((Throwable)exception);
        }
    }

    public void destroy() {
        Server.shutdown();
        m_log.info((Object)Resource.getString("mainservlet_stopped"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ErrorHandlerImpl
    implements ErrorHandler {
        private boolean m_hadErrors = false;

        public void onSensorInsertError(HostDetectedMessage hostDetectedMessage, Exception exception) {
            m_log.error((Object)Resource.formatString("mainservlet_template_error_sensor_insert", exception.toString()), (Throwable)exception);
            m_log.error((Object)Resource.formatString("mainservlet_template_event_name", hostDetectedMessage.toString()));
            this.m_hadErrors = true;
        }

        public void onHostInsertError(Host host, Exception exception) {
            m_log.error((Object)Resource.formatString("mainservlet_template_error_host_insert", exception.toString()), (Throwable)exception);
            m_log.error((Object)Resource.formatString("mainservlet_template_host_name", host.toString()));
            this.m_hadErrors = true;
        }

        public void onError(Exception exception) {
            m_log.error((Object)Resource.formatString("mainservlet_template_error_processing_event", exception.toString()), (Throwable)exception);
            this.m_hadErrors = true;
        }

        public void clearErrors() {
            this.m_hadErrors = false;
        }

        public boolean hadErrors() {
            return this.m_hadErrors;
        }
    }
}

