/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.ui;

import com.mcafee.epo.common.ui.util.SessionUtil;
import com.mcafee.epo.compliance.action.Action;
import com.mcafee.epo.compliance.action.ActionContext;
import com.mcafee.epo.compliance.action.ActionInvocationException;
import com.mcafee.epo.compliance.action.ActionInvoker;
import com.mcafee.epo.compliance.db.Host;
import com.mcafee.epo.compliance.db.HostStatus;
import com.mcafee.epo.compliance.db.action.ActionBase;
import com.mcafee.epo.compliance.db.epo.EpoDatabase;
import com.mcafee.epo.compliance.event.EventFactory;
import com.mcafee.epo.compliance.event.concrete.UserRequestEvent;
import com.mcafee.epo.compliance.server.Server;
import com.mcafee.epo.compliance.ui.util.ActionUtil;
import com.mcafee.epo.compliance.util.Resource;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.ui.ActionBeanBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ManualActionBean
extends ActionBeanBase {
    private static final Logger m_log = Logger.getLogger((String)(class$com$mcafee$epo$compliance$ui$ManualActionBean == null ? (class$com$mcafee$epo$compliance$ui$ManualActionBean = ManualActionBean.class$("com.mcafee.epo.compliance.ui.ManualActionBean")) : class$com$mcafee$epo$compliance$ui$ManualActionBean).getName());
    private Action m_action;
    static /* synthetic */ Class class$com$mcafee$epo$compliance$ui$ManualActionBean;

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        String string = null;
        String string2 = "";
        m_log.debug((Object)"Validating the manual action.");
        String string3 = httpServletRequest.getParameter("actionType");
        m_log.debug((Object)("Action type is: " + string3));
        ActionUtil.ActionMap actionMap = ActionUtil.getActions();
        m_log.debug((Object)("Action Map is: " + actionMap));
        this.m_action = (Action)actionMap.get(string3);
        ActionBase actionBase = (ActionBase)((Object)this.m_action);
        if (actionBase == null) {
            string2 = Resource.getString("manualactionbean_unrecognized_action_request", this.m_lang);
            string = "actiontaken.jsp";
        } else {
            m_log.debug((Object)("Found a " + actionBase.getType() + " action in the request"));
            boolean bl = false;
            int n = 0;
            while (n <= 3) {
                if (actionBase.appliesToStatus(n) && SessionUtil.atLeastOneIntStartsWith((HttpServletRequest)httpServletRequest, (String)HostStatus.asString(n, this.m_lang))) {
                    bl = true;
                    m_log.debug((Object)("Found some hosts checked, request is good.: " + HostStatus.asString(n, this.m_lang)));
                }
                ++n;
            }
            if (!bl) {
                m_log.debug((Object)"Didn't find the required checked hosts... request is bad.");
                string2 = Resource.getString("manualactionbean_missing_selection_" + actionBase.getType(), this.m_lang);
                string = "actiontaken.jsp";
            }
            if (string3.equals("pushAgent")) {
                return this.setupForAgentPush(httpServletRequest);
            }
        }
        SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getString("jsputil_user_input_required", this.m_lang), (String)string2, (String)"displaymachines.do");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        Iterator iterator;
        String string = null;
        string = httpServletRequest.getParameter("returnaction");
        ActionContext actionContext = null;
        Connection connection = null;
        String string2 = ((ActionBase)((Object)this.m_action)).getType();
        m_log.debug((Object)("Type val is: " + string2));
        UserRequestEvent userRequestEvent = null;
        Vector vector = null;
        try {
            connection = Server.getDb().getConnection();
            userRequestEvent = EventFactory.createUserRequestEvent(connection, null, null, null);
            vector = this.gatherSelectedHosts(httpServletRequest, connection);
            iterator = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            DatabaseUtil.close((Connection)connection);
            connection = null;
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        connection = null;
        if (string2.equals("pushAgent")) {
            httpServletRequest.getSession().setAttribute("sessionSelectedMachines", (Object)vector);
            return "agentpush.jsp";
        }
        boolean bl = false;
        iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (Host)((Object)iterator.next());
            actionContext = userRequestEvent.createActionContext();
            actionContext.setHost((Host)((Object)object));
            try {
                if (this.m_action.isAsyncAction()) {
                    m_log.debug((Object)"Executing action async.");
                    ActionInvoker actionInvoker = Server.getActionInvoker();
                    actionInvoker.addToQueue(this.m_action, actionContext);
                    continue;
                }
                m_log.debug((Object)"Executing action synchronously.");
                ActionInvoker.invokeAction(this.m_action, actionContext);
            }
            catch (ActionInvocationException actionInvocationException) {
                m_log.debug((Object)"Caught an exception", (Throwable)actionInvocationException);
                bl = true;
            }
        }
        if (bl) {
            object = Resource.getString("manualaction_error", this.m_lang);
            SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getString("jsputil_user_input_required", this.m_lang), (String)object, (String)this.m_action.getManualTargetPage());
            return "actiontaken.jsp";
        }
        m_log.debug((Object)("Return action:" + string));
        if (string == null || string.length() == 0) {
            return this.m_action.getManualTargetPage();
        }
        return string;
    }

    private Vector gatherSelectedHosts(HttpServletRequest httpServletRequest, Connection connection) throws SQLException {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        String string = null;
        Vector<Host> vector = new Vector<Host>();
        if (!enumeration.hasMoreElements()) {
            m_log.debug((Object)"Cannot find any valid, checked machines.");
        }
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            m_log.debug((Object)("Checking identifier: " + string));
            if (!ActionUtil.isHostIdentifier(string, this.m_lang)) continue;
            m_log.debug((Object)("Found a host parameter: " + string));
            string = string.replaceAll("\\D", "");
            Host host = Host.getByID(connection, Integer.parseInt(string));
            if (host == null) continue;
            vector.add(host);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String setupForAgentPush(HttpServletRequest httpServletRequest) throws Exception {
        CharSequence charSequence;
        Connection connection = null;
        Connection connection2 = null;
        HashMap hashMap = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        String string = Resource.getString("jsputil_machine_inactive", this.m_lang);
        String string2 = Resource.getString("jsputil_machine_rogue", this.m_lang);
        String string3 = Resource.getString("jsputil_machine_managed", this.m_lang);
        connection2 = Server.getEpoDb().getConnection();
        try {
            hashMap = EpoDatabase.getAgentList(connection2, "EPO", 68, this.m_lang);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            DatabaseUtil.close((Connection)connection2);
            connection2 = null;
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection2);
        connection2 = null;
        connection = Server.getDb().getConnection();
        try {
            while (enumeration.hasMoreElements()) {
                charSequence = (String)enumeration.nextElement();
                if (((String)charSequence).indexOf(string) == 0) {
                    charSequence = ((String)charSequence).substring(string.length(), ((String)charSequence).length());
                    arrayList.add(Host.getByID(connection, Integer.parseInt((String)charSequence)).getNetworkAddress());
                    continue;
                }
                if (((String)charSequence).indexOf(string2) == 0) {
                    charSequence = ((String)charSequence).substring(string2.length(), ((String)charSequence).length());
                    arrayList.add(Host.getByID(connection, Integer.parseInt((String)charSequence)).getNetworkAddress());
                    continue;
                }
                if (((String)charSequence).indexOf(string3) != 0) continue;
                charSequence = ((String)charSequence).substring(string3.length(), ((String)charSequence).length());
                arrayList.add(Host.getByID(connection, Integer.parseInt((String)charSequence)).getNetworkAddress());
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        charSequence = new StringBuffer(1024);
        this.buildAgentOptions((StringBuffer)charSequence, hashMap);
        httpServletRequest.getSession().removeAttribute("sessionSelectedMachines");
        httpServletRequest.getSession().setAttribute("sessionSelectedMachines", arrayList);
        httpServletRequest.setAttribute("availableEpoAgents", (Object)((StringBuffer)charSequence).toString());
        return "agentpush.jsp";
    }

    private void buildAgentOptions(StringBuffer stringBuffer, HashMap hashMap) {
        Iterator iterator = hashMap.entrySet().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            stringBuffer.append("<option ");
            if (bl) {
                bl = false;
                stringBuffer.append("selected ");
            }
            stringBuffer.append("value='").append(string2).append("'>");
            stringBuffer.append(string).append("</option>");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

