/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.ui.deploywizard;

import com.mcafee.epo.common.db.epo.EpoHost;
import com.mcafee.epo.common.ui.tables.HtmlTable;
import com.mcafee.epo.common.ui.tables.HtmlTableHeader;
import com.mcafee.epo.common.ui.tables.HtmlTableRow;
import com.mcafee.epo.common.ui.util.PaginationState;
import com.mcafee.epo.compliance.db.Configuration;
import com.mcafee.epo.compliance.db.Network;
import com.mcafee.epo.compliance.db.epo.EpoDatabase;
import com.mcafee.epo.compliance.db.epo.EpoHostUtil;
import com.mcafee.epo.compliance.server.Server;
import com.mcafee.epo.compliance.ui.deploywizard.DeployWizardHelperBase;
import com.mcafee.epo.compliance.ui.deploywizard.DeployWizardStateBean;
import com.mcafee.epo.compliance.ui.deploywizard.SelectSensorDeployHelper;
import com.mcafee.epo.compliance.ui.util.EpoHostList;
import com.mcafee.epo.compliance.ui.util.SubnetInfo;
import com.mcafee.epo.compliance.util.Resource;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.servlet.util.UserUtil;
import com.mcafee.epo.core.ui.InvalidParameterException;
import com.mcafee.epo.core.util.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DisplaySensorDeployDetailsHelper
extends DeployWizardHelperBase {
    private SelectSensorDeployHelper m_autoSelector = null;

    public DisplaySensorDeployDetailsHelper(DeployWizardStateBean deployWizardStateBean) {
        super(deployWizardStateBean);
    }

    public String subValidate(HttpServletRequest httpServletRequest) throws Exception {
        Integer n = this.getState().getSensorDeploySubnetDetailsIndex();
        if (n == null || n <= -1) {
            throw new InvalidParameterException("Error: DisplaySensorDeployDetailsHelper - Missing or invalid subnet details index.");
        }
        Integer n2 = this.getState().getSensorDeployHostIndex();
        if (n2 == null || n2 <= 0) {
            throw new InvalidParameterException("Error: DisplaySensorDeployDetailsHelper - Missing or invalid host index.");
        }
        if (this.getState().getDeploymentAuto().booleanValue()) {
            this.m_autoSelector = new SelectSensorDeployHelper(this.getState());
            String string = this.m_autoSelector.validate(httpServletRequest);
            if (string != null) {
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        String string2 = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        if (this.getState().getDeploymentAuto().booleanValue() && !this.getState().isAutoSelectionDone()) {
            this.m_autoSelector.execute(httpServletRequest, httpServletResponse);
            this.getState().setAutoSelectionDone(true);
        }
        int n = this.getState().getSensorDeploySubnetDetailsIndex();
        int n2 = this.getState().getSensorDeployHostIndex();
        EpoHostList epoHostList = this.getState().getHostList();
        SubnetInfo subnetInfo = epoHostList.getAt(n);
        Configuration configuration = Server.getConfiguration();
        epoHostList.updateIndex(n + 1, configuration.getPageCount());
        PaginationState paginationState = new PaginationState(1, 1, configuration.getPageCount(), null);
        paginationState.getPagMgr().setIndex(n2);
        StringBuffer stringBuffer = new StringBuffer(1024);
        HtmlTable htmlTable = null;
        HtmlTableHeader htmlTableHeader = null;
        HtmlTableRow htmlTableRow = null;
        Network network = this.getNetwork(subnetInfo);
        String string3 = network.getAddressAndMask();
        if (string3.length() <= 0) {
            string3 = Resource.getString("jsputil_unknown_network", string2);
        }
        if ((string = network.getNetworkName()).length() > 0) {
            string3 = string3 + " (" + string + ")";
        }
        httpServletRequest.setAttribute("currentSubnet", (Object)string3);
        this.buildPrevNextHeader(stringBuffer, n, epoHostList.size(), string2);
        stringBuffer.append("<br>");
        htmlTable = new HtmlTable();
        htmlTable.setHasCheckbox(true);
        htmlTable.setPaginationMgr(paginationState.getPagMgr());
        htmlTableHeader = htmlTable.getHeader();
        htmlTableHeader.setCheckboxId("checkboxToggle");
        htmlTableHeader.addCell(Resource.getString("jsputil_status", string2));
        htmlTableHeader.addCell(Resource.getString("jsputil_hostname", string2));
        htmlTableHeader.addCell(Resource.getString("jsputil_ip_address", string2));
        htmlTableHeader.addCell(Resource.getString("jsputil_type", string2));
        htmlTableHeader.addCell(Resource.getString("jsputil_os", string2));
        htmlTableHeader.addCell(Resource.getString("jsputil_cpu", string2));
        htmlTableHeader.addCell(Resource.getString("jsputil_ram", string2));
        htmlTableHeader.addCell(Resource.getString("jsputil_last_detect", string2));
        Connection connection = null;
        try {
            connection = Server.getEpoDb().getConnection();
            EpoHost[] epoHostArray = EpoHostUtil.getBySubnet(connection, subnetInfo.m_networkAddress, subnetInfo.m_subnetMask);
            connection.commit();
            boolean bl = false;
            paginationState.getPagMgr().setListCount(epoHostArray.length);
            int n3 = n2 + configuration.getPageCount() - 1;
            if (n3 > epoHostArray.length) {
                n3 = epoHostArray.length;
            }
            int n4 = n2 - 1;
            while (n4 < n3) {
                if (subnetInfo.containsHost(epoHostArray[n4].getLeafNodeID())) {
                    htmlTableRow = htmlTable.addRow(7);
                    bl = true;
                } else {
                    htmlTableRow = htmlTable.addRow(4);
                    bl = false;
                }
                htmlTableRow.setCheckboxId("machineId" + epoHostArray[n4].getLeafNodeID() + ":" + epoHostArray[n4].getHostname());
                if (bl) {
                    htmlTableRow.addCell(Resource.getString("jsputil_deploy_sensor", string2));
                } else {
                    htmlTableRow.addCell("&nbsp;");
                }
                htmlTableRow.addCell(StringUtil.safeHtml((String)epoHostArray[n4].getHostname()));
                htmlTableRow.addCell(StringUtil.safeHtml((String)epoHostArray[n4].getIpAddress()));
                if (this.isServerClass(epoHostArray[n4].getOsPlatform())) {
                    htmlTableRow.addCell(Resource.getString("jsputil_server", string2));
                } else {
                    htmlTableRow.addCell(Resource.getString("jsputil_workstation", string2));
                }
                htmlTableRow.addCell(StringUtil.safeHtml((String)epoHostArray[n4].getOs()));
                htmlTableRow.addCell(String.valueOf(epoHostArray[n4].getCpuSpeed()));
                htmlTableRow.addCell(String.valueOf(epoHostArray[n4].getMemory()));
                htmlTableRow.addCell(StringUtil.formatDateTime((Timestamp)new Timestamp(EpoDatabase.parseAgentTime(epoHostArray[n4].getLastUpdate()))));
                ++n4;
            }
            paginationState.getPagMgr().computePagination();
            Object var23_22 = null;
        }
        catch (Throwable throwable) {
            Object var23_23 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        stringBuffer.append(htmlTable.getHtml(string2));
        httpServletRequest.setAttribute("sensorDeployDetails", (Object)stringBuffer.toString());
        this.getState().setSensorDeploySubnetDetailsIndex(new Integer(n));
        this.getState().setSensorDeployHostIndex(new Integer(n2));
        return "deploywizard.jsp";
    }

    private void buildPrevNextHeader(StringBuffer stringBuffer, int n, int n2, String string) {
        stringBuffer.append("<table cellspacing=3 cellpadding=3 border=0 class='Toolbar' width='100%'>\n").append("<tr valign=center><td>");
        this.addControl(stringBuffer, Resource.getString("jsputil_previous_subnet", string), n - 1, true, n > 0);
        stringBuffer.append(" <img src='images/px_trans.gif' height=1 width=9 border=0> \n");
        this.addControl(stringBuffer, Resource.getString("jsputil_next_subnet", string), n + 1, false, n < n2 - 1);
        stringBuffer.append("</td></tr></table>\n");
    }

    private void addControl(StringBuffer stringBuffer, String string, int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        stringBuffer2.append("images/");
        if (bl) {
            stringBuffer2.append("ViewPrevious");
        } else {
            stringBuffer2.append("ViewNext");
        }
        if (!bl2) {
            stringBuffer2.append("Disabled");
        }
        stringBuffer2.append(".gif");
        if (bl2) {
            stringBuffer.append("<a href='Javascript:displayAnother( ").append(n).append(")'><img src='").append(stringBuffer2.toString()).append("' align=absMiddle border=0> ").append(string).append("</a>");
        } else {
            stringBuffer.append("<img src='").append(stringBuffer2.toString()).append("' align=absMiddle border=0> ").append("<span style='color:").append("#AAAAAA").append("'>").append(string).append("</span>");
        }
        stringBuffer.append("\n");
    }

    private boolean isServerClass(String string) {
        Pattern pattern = Pattern.compile("Server");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Network getNetwork(SubnetInfo subnetInfo) throws SQLException {
        Network network;
        Connection connection = Server.getDb().getConnection();
        try {
            network = Network.getBySubnetInfo(connection, subnetInfo.getNetworkAddress(), subnetInfo.getSubnetMask());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        return network;
    }
}

